<?PHP
/*
  index.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$abs_path = dirname(__FILE__);
include $abs_path."/global.php";

if (isset($_POST[l])) $_GET[l] = $_POST[l];
if (isset($_POST[m])) $_GET[m] = $_POST[m];
if (isset($_POST[p])) $_GET[p] = $_POST[p];

// Initiate Ajax
if (in_array($_GET[l], $run_ajax)) {
	$ajax = new ajax();
	echo $ajax->$_GET[l]($_GET[p]);
	exit;
}

// Product Image Popups
if ($_GET[l] == 'product_images') {
	$product	= get('products', $_GET[p]);
	$image		= get('products_images', $_GET[i]);
	
	$product[large_image] = ((isset($image[id]))?$image[large_image]:$product[large_image]);
	$size = @getimagesize($settings[productpath].$product[large_image], $imageinfo);
	$product[image_size] = $size[3];
	
	$index[page_title] = $settings[metatitle];
	echo template('product_detail_image_popup.html', array('product' => $product, 'index' => $index));
	exit;
}

// Set Base URL
if ($_GET[setbase] == 1) $index[base_url] = '<base href="'.$settings[shopurl].'" />';

// Shop Open?
if ($settings[shopstatus] == "Off" && ($_GET[l] != 'page_view')) {
	unset($_GET[l]); unset($_GET[c]); unset($_GET[m]); unset($_GET[p]);
}

// Set Global Data
$index[year] 				= date('Y');
$index[foot_out]			= foot_out();
$categories['list'] 		= showcategories();
$search['optionlist']		= catoptionlist(cats2array(0), 0, '');
$list['years']				= get_years();
$manufacturers['list']		= manufacturers_list();
$bestsellers['list'] 		= listbestsellers();
$cart_contents['list']		= cart_contents();
$cart_contents['subtotal']	= p($cart->subtotal());
$currency['list']			= currency_list();
$currency['self']			= 'index.php';

// Set Default Meta Tags
$index[page_title]			= $settings[metatitle];
$index[page_keywords]		= $settings[metakeywords];
$index[page_description]	= $settings[metadescription];

// Set Previous Location
$halt_array = array('previous', 'gift_certificates', 'cart_view', 'add_gift_cert', 'addtocart', 'update_cart', 'login', 'logout');
if (!in_array($_GET[l], $halt_array)) set_previous();

switch ($_GET[l]) {
	case '':
		$_GET[c] = $settings[mainpageproducts];
		if ($settings[mainpage] == 2) { $hide[] = 'Products'; }
		if ($settings[mainpage] == 3) { $hide[] = 'Welcome'; }
		
		$index[main_content] = template('page_welcome.html', array('welcome' => $welcome, 'list' => array_merge(product_list(), array('heading' => $lang['welcome'][$_GET[c]])), 'lang' => $lang['welcome'], 'alert' => array('message' => $ae->display()), 'hide' => $hide));
		break;
		
	case 'product_list':
		$data						= product_list();
		$hide						= ($data[products_count]==0)?array('Products'):array();
		$category					= get('categories', $_GET[c]);
		$manufacturer				= get('manufacturers', $_GET[m]);
		$index[page_title]			= (($_GET[m]!="")?$manufacturer[meta_title]:$category[meta_title]);
		$index[page_keywords]		= ($_GET[m]!="")?$manufacturer[meta_keywords]:$category[meta_keywords];
		$index[page_description]	= ($_GET[m]!="")?$manufacturer[meta_desc]:$category[meta_desc];
		
		$index[main_content] = template('list_products.html', array('list' => $data, 'lang' => $lang['product_list'], 'alert' => array('message' => $ae->display()), 'hide' => $hide));
		break;
		
	case 'product_detail':
		$product = get('products', $_GET[p]);
		$index[page_title]			= $product[meta_title];
		$index[page_keywords]		= $product[meta_keywords];
		$index[page_description]	= $product[meta_description];
		$index[main_content]		= item_detail($product[id], $product);
		break;
		
	case 'addtocart':
		if (is_array($_GET['product'])) $_POST['product'] = $_GET['product'];
		$product_id = intval($_POST['product']['id']);
		$product_quantity = intval($_POST['product']['quantity']);
		$prod = get('products', $product_id);
		
		if (hasoptions($product_id) && !is_array($_POST['option'])) {
			$ae->new_error($lang['cart_view']['selectopt'].'"'.$prod[title].'"');
			header("location: ".$settings[shopurl]."index.php?l=product_detail&p=".$product_id);
			exit;
		}
		
		$reg = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."users_wishlist` WHERE `id`='".$_POST[regid]."'");
		$errors = prevalidateitem($product_id, $product_quantity, ((is_array($_POST['option']))?$_POST['option']:array()));
		if (!$errors && $cart->additem($product_id, $product_quantity, ((is_array($_POST['option']))?$_POST['option']:array()), (($reg[id]!="")?$reg[id]:''))) {
			$sess->dvar('cart'); $sess->svar('cart', $cart);
			$ae->new_alert('"'.$prod[title].'"'.$lang['product_list']['addedd']);
			header("location: ".$settings[shopurl]."index.php?".(($settings[addtocart]=='goback')?substr(get_previous(), 1):'l=cart_view'));
		} else {
			header("location: ".$_SERVER["HTTP_REFERER"]);
		}
		
		exit;
		break;
		
	case 'update_cart':
		updatecart($_POST['remove'], $_POST['quantity']);
		$sess->dvar('cart'); $sess->svar('cart', $cart);
		if (is_array($_POST[plugin])) foreach ($_POST[plugin] as $k => $v) $add .= '&'.$k.'='.$v;
		header("location: ".$settings[shopurl]."index.php?l=cart_view".$add); exit;
		break;
		
	case 'cart_view':
		if (!isset($cart)) { header("location: ".$settings[shopurl]."index.php?l=cart_view"); exit; }
		$index[main_content] = showcart();
		break;
		
	case 'page_view':
		$list[categories]		= $search['optionlist'];
		$list[manufacturers]	= $manufacturers['list'];
		$list[site_map]			= ($_GET[p] == 'site_map')?sitemap_render():'';
		
		$meta_data = get('pages_meta_data', sanitize($_GET[p]), 'page');
		if ($settings[imageverify] != "Yes") $hide[] = "Image Verification";
		if ($settings[giftcerts] != "Yes") $hide[] = "Gift Certificates";
		
		$index[page_title]			= ($meta_data[id]!="")?$meta_data[meta_title]:ucwords(str_replace("_", " ", $_GET[p]));
		$index[page_keywords]		= ($meta_data[id]!="")?$meta_data[meta_keywords]:$index[page_keywords];
		$index[page_description]	= ($meta_data[id]!="")?$meta_data[meta_description]:$index[page_description];
		
		$index[main_content]	= template('page_'.$_GET[p].'.html', array('hide' => $hide, 'list' => $list, 'lang' => $lang[$_GET[p]], 'message' => array('error' => $ae->display())));
		break;
		
	case 'add_gift_cert':
		if ($settings[giftcerts] == 'No') {
			header("location: $settings[shopurl]"); exit;
		}
		$index[main_content] = $gs->check_data();
		break;
		
	case 'search_list':
		if (isset($_POST[s])) {
			$query_string = $_SERVER["QUERY_STRING"].search_helper($_POST[s]);
			header("location: ".$settings[shopurl]."index.php?".$query_string);	exit;
		}
		if ($sess->gvar('s') != "" && $_GET[s] == "") {
			$query_string = $_SERVER["QUERY_STRING"].search_helper($sess->gvar('s'));
			header("location: ".$settings[shopurl]."index.php?".$query_string);	exit;
		}
		$list = search_list();
		$list[manufacturers]	= $manufacturers['list'];
		$index[main_content]	= template('list_products_search.html', array('list' => $list, 'lang' => $lang['advanced_search'], 'message' => array('error' => $ae->display())));
		break;
		
	case 'registry_list':
		if (isset($_POST[s])) {
			$query_string = $_SERVER["QUERY_STRING"].search_helper($_POST[s]);
			header("location: ".$settings[shopurl]."index.php?".$query_string);	exit;
		}
		if ($sess->gvar('s') != "" && $_GET[s] == "") {
			$query_string = $_SERVER["QUERY_STRING"].search_helper($sess->gvar('s'));
			header("location: ".$settings[shopurl]."index.php?".$query_string);	exit;
		}
		$list = registry_list();
		$index[page_title] = $lang['registry']['heading'];
		$index[main_content] = template('list_registry_search.html', array('list' => $list, 'lang' => $lang['registry']));
		break;
		
	case 'wishlist':
		$list = wishlist();
		$user = get('users', $_GET[uid]);
		$index[main_content] = template('page_user_wishlist.html', array('user' => $user, 'list' => $list, 'lang' => $lang['wishlist']));
		break;
		
	case 'registry':
		$list = registry();
		$user = get('users', $_GET[uid]);
		$index[main_content] = template('page_user_registry.html', array('user' => $user, 'list' => $list, 'lang' => $lang['registry']));
		break;
		
	case 'account':
		if ($_GET[p]!="download") check_secure();
		if (!islogged()) {
			check_secure(); $index[main_content] = account_signup();
		} else {
			$_page = ($_GET[p]=="")?'details':$_GET[p];
			switch ($_page) {
				case 'details':		$data = account_output(); break;
				case 'order':		$data = order_output(); break;
				case 'download':	$data = download(); break;
			}
			$index[main_content] = template('account_'.$_page.'.html', array_merge($data, array('hide' => $data[account][hide], 'lang' => $lang['account'], 'tab' => array($_GET[tab] => 'tabbertabdefault'))));
		}
		break;
		
	case 'checkout':
		if ($cart->product_count() > 0) {
			$sess->svar('cart', $cart);
			savecart();
			redirect('checkout.php?', true);
		} else empty_redirect();
		break;
		
	case 'login':
		perform_login();
		break;
		
	case 'previous':
		header("location: ".((is_secure())?$settings[secureurl]:$settings[shopurl])."index.php".get_previous()); exit;
		break;
		
	case 'logout':
		$sess->destroy();
		if (is_secure()) header("location: ".$settings[shopurl]."index.php?l=logout");
		else header("location: ".$settings[shopurl]); exit;
		break;
		
	case 'hashlogin':
		unhash_me($_GET[hash]);
		break;
		
	default:
		$index[page_title]		= ucwords(str_replace("_", " ", $_GET[l]));
		$index[main_content]	= template('page_'.$_GET[l].'.html', array('hide' => $hide, 'list' => $list, 'message' => array('error' => $ae->display()), 'lang' => $lang[$_GET[l]]));
		break;
}

///////////////////////
// Start Loading Tables
///////////////////////
$table_array = table_list();
for ($i=0; $i<count($table_array); $i++) {
	$file_name	= $table_array[$i][file_name];
	$table_name	= $table_array[$i][table_name];
	if ($table_name == 'information' && $settings[giftcerts] == 'No') $hide[] = 'Gift Certificates';
	if ($table_name == 'information' && $settings[registry] == 'No') $hide[] = 'Registry';
	if ($table_name == 'information' && !islogged()) $hide[] = 'Logout';
	if ($table_name == 'login_box' && $sess->gvar('login_error') == 1) { $sess->dvar('login_error'); $login_box[error] = $lang['account']['pass_error']; }
	$table[$table_name] = template($file_name, array($table_name => ${$table_name}, 'lang' => $lang[$table_name], 'hide' => $hide));
}

////////////
// Save Cart
////////////

$sess->svar('cart', $cart);
savecart();

//////////////
// Page Output
//////////////

if ($settings[width] == '100%' || $settings[width] == '') $hide[] = 'Fixed1';
if ($settings[width] == '100%' || $settings[width] == '') $hide[] = 'Fixed2';
if (islogged()) $hide[] = 'Login';
else $hide[] = 'Logout';

if ($_GET[setbase] == 1) $hide[] = 'Cart';

$index_out = template('main_index.html', array('index' => $index, 'table' => $table, 'lang' => $lang['index'], 'hide' => $hide));
if ($sess->gvar('my_rate') != "" && $sess->gvar('my_rate') != $settings[defaultrate]) $index_out = parsePRICE($index_out);

echo html_links(stripslashes($index_out));
$DB_site->close();

//$cart->debug();
//$sess->debug();
?>