<?PHP
/*
  include/shipping/usps_int.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "USPS_INT";
$ADDON_FULLNAME	= "USPS International";
$ADDON_VERSION 	= "4.1";
$ADDON_TYPE 	= "Shipping";
$CLASS_NAME 	= "uspsi_integration";

class uspsi_integration {
	var $class_vars;
	var $xml_code;
	var $loc_code;
	var $package_id = 0;
	var $shipm;
	
	var $shipn = array(
		"Global Express Guaranteed",
		"Express Mail International",
		"Priority Mail International",
		"First Class Mail International"
	);
	
	function uspsi_integration ($class_vars) {
		$this->class_vars	= $class_vars;
		
		// What services should be matched to results.
		$this->shipm = array(
			"Global Express Guaranteed" 		=> 'Global Express Guaranteed', // Also Available: Global Express Guaranteed Non-Document Rectangular, Global Express Guaranteed Non-Document Non-Rectangular, USPS GXG Envelopes
			"Express Mail International" 		=> 'Express Mail International (EMS)', // Also Available: Express Mail International (EMS) Flat-Rate Envelope
			"Priority Mail International" 		=> 'Priority Mail International', // Also Available: Priority Mail International Flat-Rate Envelope, Priority Mail International Flat-Rate Box, Priority Mail International Large Flat-Rate Box
			"First Class Mail International" 	=> 'First Class Mail International Package', // Also Available: First Class Mail International Large Envelope
		);
	}
	
	function start () {
		global $settings;
		$this->xml_code = $settings[startuspsi];
	}
	
	function setaddress ($from_city, $from_state, $from_zip, $from_country, $to_city, $to_state, $to_zip, $to_country) {
		global $DB_site, $dbprefix;
		$country = $DB_site->query_first("SELECT * FROM ".$dbprefix."state_country where abb='".$to_country."' AND type='1'");
		if ($country[name] == "United Kingdom") { $country[name] = "Great Britain"; }
		$this->loc_code = '<Country>'.urlencode($country[name]).'</Country>';
    }
	
	function add_package($weight, $length="", $width="", $height="") {
		global $settings;
		if ($settings[weight_units] == "LB") { $pounds = floor($weight); $ounces = round(16 * ($weight - floor($weight))); }
		if ($settings[weight_units] == "OZ") { $ounces = round($weight); $pounds = '0'; }
		$this->xml_code .= '<Package%20ID="'.$this->package_id.'"><Pounds>'.$pounds.'</Pounds><Ounces>'.$ounces.'</Ounces><MailType>package</MailType>'.$this->loc_code.'</Package>';
		$this->package_id++;
	}
	
	function end_all () {
		$this->xml_code .= '</IntlRateRequest>';
	}
	
	function process () {
		global $settings, $cconnect, $discounts, $coupon;
		$data = "API=IntlRate&XML=".$this->xml_code;
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$result	= $this->parse_return($results);
		$return = array();
		
		if ($result[error] != "") {
			array_push($return, array('status' => '', 'statuscode' => 0, 'error' => $result[error], 'errorcode' => 0, 'rate' => '', 'method' => ''));
		} else {
			$free = array();
			$temp = explode("::", $this->class_vars[free]);
			for ($i=0; $i<count($temp); $i++) array_push($free, $temp[$i]);
			
			$accepted = explode("::", $this->class_vars[accepted]);
			for ($i=0; $i<count($accepted); $i++) {
				$service = $this->shipm[$accepted[$i]];
				$display = $accepted[$i];
				foreach ($result[result] as $k => $v) {
					if (trim($service) == trim($v[MailService])) {
						$set_free = (($discounts[free_shipping]==1 || $coupon[free_shipping]==1) && in_array($accepted[$i], $free))?1:0;
						array_push($return, array('status' => '', 'statuscode' => 1, 'error' => '', 'errorcode' => 0, 'rate' => ($set_free==1)?0:$v[Rate], 'method' => trim($display)));
					}
				}
			}
		}
		
		return $return;
	}
	
	function parse_return ($in) {
		$rarray 		= parse_xml($in, array('Service', 'Package'));
		$return 		= array('result' => array(), 'error' => '');
		$parse_array 	= array();
		$total			= 0;
		
		while (list ($key, $val) = @each ($rarray[IntlRateResponse][Package])) {
			$error = $rarray[IntlRateResponse][Package][$key][Error][Description];
			if ($error!="") { $return[error] = $error; }
			while (list ($key2, $val2) = @each ($rarray[IntlRateResponse][Package][$key][Service])) {
				$method_name	= $rarray[IntlRateResponse][Package][$key][Service][$key2][SvcDescription];
				$ship_amount	= $rarray[IntlRateResponse][Package][$key][Service][$key2][Postage];
				$parse_array[$method_name][amount] += $ship_amount;
				$parse_array[$method_name][method]  = $method_name;
				$parse_array[$method_name][hitnum] += 1;
			}
			$total++;
		}
		
		while (list ($key, $val) = @each ($parse_array)) {
			if ($parse_array[$key][hitnum] == $total) {
				$this_val = array(
					'MailService' => $parse_array[$key][method], 
					'Rate' => $parse_array[$key][amount]
				);
				array_push($return[result], $this_val);
			}
		}
		
		$return[error]  = ($return[error]!="")?$return[error]:$rarray[Error][Description];
		return $return;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='uspsi_integration', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='0', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='uspsi_integration', `internalname`='url', `name`='', `moptions`='', `options`='', `value`='http://production.shippingapis.com/ShippingAPI.dll', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='uspsi_integration', `internalname`='accepted', `name`='Shipping Methods', `moptions`='".implode("::", $this->shipn)."->".implode("::", $this->shipn)."', `options`='', `value`='Global Express Guaranteed::Express Mail International::Priority Mail International::First-Class Mail International', `help`='', `size`='0', `dorder`='2', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='uspsi_integration', `internalname`='free', `name`='Free Methods', `moptions`='".implode("::", $this->shipn)."->".implode("::", $this->shipn)."', `options`='', `value`='', `help`='Please select any methods you wish to offer free when free shipping is provided using discounts or coupons.', `size`='0', `dorder`='3', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='uspsi_integration', `internalname`='multi_support', `name`='', `moptions`='', `options`='', `value`='1', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_shipping where `module`='uspsi_integration'");
	}
}
?>
