<?PHP
/*
  include/shipping/dhl.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/
  
$ADDON_NAME 	= "DHL";
$ADDON_FULLNAME	= "DHL / Airborne";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Shipping";
$CLASS_NAME 	= "dhl_integration";

class dhl_integration {
	var $class_vars;
	var $xml_code;
	var $xml_code1;
	var $xml_code2;
	var $xml_code3;
	var $xml_code4;
	var $ship_date;
	
	var $shipv = array("G","S","N","E");
		
	var $shipn = array(
		"Ground",
		"Second Day Service",
		"Next Afternoon",
		"Express"
	);
	
	function dhl_integration ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function start () {
		
		$day = date("D");
		if ($day == "Sat") {
			$this->ship_date = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+3, date("Y")));
		} elseif ($day == "Sun") {
			$this->ship_date = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+2, date("Y")));
		} else {
			$this->ship_date = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1, date("Y")));
		}
		
		$this->xml_code1 = '
		<?xml version="1.0" encoding="UTF-8"?>
			<eCommerce action="Request" version="1.1">
				<Requestor><ID>'.$this->class_vars[acc_usr].'</ID><Password>'.$this->class_vars[acc_pass].'</Password></Requestor>
				<Shipment action=\'RateEstimate\' version=\'1.0\'>
					<ShippingCredentials>
						<ShippingKey>'.$this->class_vars[shipping_key].'</ShippingKey>
						<AccountNbr>'.$this->class_vars[acc_num].'</AccountNbr>
					</ShippingCredentials>
					<ShipmentDetail>
						<ShipDate>'.$this->ship_date.'</ShipDate>
						<Service>
							<Code><!--//SHIP_CODE//--></Code>
						</Service>
						<ShipmentType>
							<Code>'.$this->class_vars[box_type].'</Code>
						</ShipmentType>';
	}
	
	function setaddress ($from_city, $from_state, $from_zip, $from_country, $to_city, $to_state, $to_zip, $to_country) {
		$this->xml_code3 .= '
			</ShipmentDetail>
			<Billing>
				<Party>
					<Code>S</Code>
				</Party>
			</Billing>
			<Receiver>
				<Address>
					<City>'.$to_city.'</City>
					<State>'.$to_state.'</State>
					<Country>'.$to_country.'</Country>
					<PostalCode>'.$to_zip.'</PostalCode>
				</Address>
			</Receiver>
		</Shipment>';
    }
	
	function add_package($weight, $length="", $width="", $height="") {
		$this->xml_code2 .= '
		<Weight>'.$weight.'</Weight>
		<Dimensions>
			<Width>'.$width.'</Width>
			<Height>'.$height.'</Height>
			<Length>'.$length.'</Length>
		</Dimensions>';
	}
	
	function end_all () {
		$this->xml_code4 .= '</eCommerce>';
	}
	
	function process () {
		global $settings, $cconnect, $discounts, $coupon, $set_free;
		$return = array();
		$temp = explode("::", $this->class_vars[accepted]);
		for ($i=0; $i<count($temp); $i++) {
			$meth = $temp[$i];
			$methods[$meth] = 1;
		}
		
		$free = array();
		$temp = explode("::", $this->class_vars[free]);
		for ($i=0; $i<count($temp); $i++) {
			array_push($free, $temp[$i]);
		}
		
		for ($i=0; $i<count($this->shipv); $i++) {
			$temp = $this->shipv[$i];
			if ($methods[$temp] == 1) {
				$set_free = (($discounts[free_shipping]==1 || $coupon[free_shipping]==1) && in_array($temp, $free))?1:0;
				$this->xml_code = $this->xml_code1.$this->xml_code2.$this->xml_code3.$this->xml_code4;
				$xml_code = str_replace("<!--//SHIP_CODE//-->", $temp, $this->xml_code);
				
				$header_array = array(
					"POST / HTTP/1.0",
				    "Content-type: application/x-www-form-urlencoded",
				    "Content-length: ".strlen($xml_code)
				);
				
				$header = "POST / HTTP/1.0\r\n".
					"Content-Type: application/x-www-form-urlencoded\r\n".
					"Content-Length: " . strlen ($xml_code) . "\r\n\r\n";
				
				$results = $cconnect->connect($xml_code, $header, $header_array, $this->class_vars[url]);
				$result	= $this->parse_return($results, $i);
				
				$return = array_merge($return, $result);
			}
		}
		
		return $return;
	}
	
	
	function parse_return ($in, $num) {
		global $set_free;
		$rarray = parse_xml($in);
		
		$return[$num][status]		= $rarray[eCommerce][Shipment][Result][Desc];
		$return[$num][statuscode]	= $rarray[eCommerce][Shipment][Result][Code];
		$return[$num][error]		= $rarray[eCommerce][Shipment][Faults][Fault][Desc];
		$return[$num][errorcode]	= $rarray[eCommerce][Shipment][Faults][Fault][Code];
		$return[$num][rate]			= ($set_free==1)?0:$rarray[eCommerce][Shipment][EstimateDetail][RateEstimate][TotalChargeEstimate];
		$return[$num][method]		= $this->shipn[$num];
		
		return $return;
	}
	
	function register () {
		global $cconnect;
		$this->xml_code = '
		<?xml version="1.0" encoding="UTF-8"?>
			<eCommerce action="Request" version="1.1">
				<Requestor><ID>'.$this->class_vars[acc_usr].'</ID><Password>'.$this->class_vars[acc_pass].'</Password></Requestor>
				<Register action=\'ShippingKey\' version=\'1.0\'>
					<AccountNbr>'.$this->class_vars[acc_num].'</AccountNbr>
					<PostalCode>'.$settings[zip].'</PostalCode>
				</Register>
			</eCommerce>';
			
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($this->xml_code)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($this->xml_code) . "\r\n\r\n";
		
		$results = $cconnect->connect($this->xml_code, $header, $header_array, $this->class_vars[url]);
		$result = parse_xml($results);
		
		return $result;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='0', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='url', `name`='', `moptions`='', `options`='', `value`='https://eCommerce.airborne.com/ApiLanding.asp', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='acc_num', `name`='Account Number', `moptions`='', `options`='', `value`='', `help`='', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='acc_usr', `name`='Account Username', `moptions`='', `options`='', `value`='', `help`='', `size`='20', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='acc_pass', `name`='Account Password', `moptions`='', `options`='', `value`='', `help`='', `size`='20', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='shipping_key', `name`='Shipping Key', `moptions`='', `options`='', `value`='', `help`='', `size`='30', `dorder`='5', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='accepted', `name`='Shipping Methods', `moptions`='".implode("::", $this->shipv)."->".implode("::", $this->shipn)."', `options`='', `value`='G::S::N::E', `help`='', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='free', `name`='Free Methods', `moptions`='".implode("::", $this->shipv)."->".implode("::", $this->shipn)."', `options`='', `value`='G', `help`='Please select any methods you wish to offer free when free shipping is provided using discounts or coupons.', `size`='0', `dorder`='7', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='box_type', `name`='Typical Box Type', `moptions`='', `options`='P::L->Package::Letter', `value`='P', `help`='', `size`='0', `dorder`='8', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='dhl_integration', `internalname`='multi_support', `name`='', `moptions`='', `options`='', `value`='0', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_shipping where `module`='dhl_integration'");
	}
}
?>
