<?PHP
/*
  include/plugins/checkout_by_amazon.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Checkout by Amazon";
$ADDON_VERSION 	= "1.0";
$CLASS_NAME 	= "checkout_by_amazon";

class checkout_by_amazon {
	var $class_vars;
	var $ctype;
	var $cart_info;
	var $charge_shipping = 0;
	
	function checkout_by_amazon ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function sign_n_pack ($data, $key) {
		global $abs_path;
		include_once $abs_path.'/include/classes/class.hmac.php';
		$crypt = new crypt_hmac($key, 'sha1');
		$signature = $crypt->hash($data);
		$bin_signature = pack('H*', $signature);
		return base64_encode($bin_signature);
	}
	
	function pass_cart () {
		global $settings;
		for ($i=0; $i<count($this->cart_info); $i++) {
			$prod = get('products', $this->cart_info[$i][items]);
			$vars = array(
				'sku'			=> $prod[num],
				'merchant_id'	=> trim($this->class_vars[merchant_id]),
				'title'			=> $this->cart_info[$i][title],
				'short_desc'	=> $this->cart_info[$i][description],
				'price'			=> $this->cart_info[$i][price],
				'currency'		=> $settings[defaultrate],
				'quantity'		=> $this->cart_info[$i][quantity],
				'weight'		=> $prod[weight],
				'weight_unit'	=> strtolower($settings[weight_units]),
				'taxes'			=> ($prod[charge_tax]!='y')?'item-non-taxable':'default-tax-table',
				'shipping'		=> ($prod[charge_shipping]!='y')?xml_doc('include/plugins/checkout_by_amazon/amazon_cart_item_shipping.xml', array('ship_method' => 'item-non-shippable')):'{ShippingMethods}',
			);
			$this->charge_shipping = ($prod[charge_shipping]!='y')?0:1;
			$items .= xml_doc('include/plugins/checkout_by_amazon/amazon_cart_item.xml', $vars);
		}
		return $items;
	}
	
	function render () {
		global $DB_site, $dbprefix, $settings, $abs_path, $lang, $sess, $cart;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		if ($cart->product_count() == 0) return;
		
		$this->cart_info = $cart->pass_cart();
		$cart_data[items] = $this->pass_cart();
		
    	////////////////
		// Set Tax Rules
		////////////////
		
		$results = $DB_site->query("SELECT *, t.name as name FROM `".$dbprefix."taxes` t 
			LEFT JOIN `".$dbprefix."state_country` sc ON t.tvalue=sc.id WHERE
			t.`type`='".STATE."' OR t.`type`='".PROVINCE."'
		");
		while ($row = $DB_site->fetch_assoc($results)) {
			$vars = array(
				'rate' 		=> ($row[rate]/100),
				'shiptaxed' => ($settings[taxtoshipping]==1)?'true':'false',
				'state'		=> ereg_replace("[^A-Za-z]", "", $row[abb])
			);
			$cart_data[taxes] .= xml_doc('include/plugins/checkout_by_amazon/amazon_cart_state_tax.xml', $vars);
		}
		
		$results = $DB_site->query("SELECT *, t.name as name FROM `".$dbprefix."taxes` t 
			LEFT JOIN `".$dbprefix."state_country` sc ON t.tvalue=sc.id WHERE
			t.`type`='".ZIPCODE."'
		");
		while ($row = $DB_site->fetch_assoc($results)) {
			$vars = array(
				'rate' 		=> ($row[rate]/100),
				'shiptaxed' => ($settings[taxtoshipping]==1)?'true':'false',
				'zip'		=> $row[name]
			);
			$cart_data[taxes] .= xml_doc('include/plugins/checkout_by_amazon/amazon_cart_zip_tax.xml', $vars);
		}
		
		$results = $DB_site->query("SELECT *, t.name as name FROM `".$dbprefix."taxes` t 
			LEFT JOIN `".$dbprefix."state_country` sc ON t.tvalue=sc.id WHERE
			t.`type`='".COUNTRY."'
		");
		while ($row = $DB_site->fetch_assoc($results)) {
			$vars = array(
				'rate' 		=> ($row[rate]/100),
				'shiptaxed' => ($settings[taxtoshipping]==1)?'true':'false',
				'country'	=> $row[abb]
			);
			// Country Not Yet Supported?
			// $cart_data[taxes] .= xml_doc('include/plugins/checkout_by_amazon/amazon_cart_zip_tax.xml', $vars);
		}
		
		/////////////////////
		// Set Shipping Rules
		/////////////////////
		
		if ($this->charge_shipping != 0) {
			switch ($settings[shipmethod]) {
				case 'fixed':
					switch ($settings[method]) {
						case 'perorder':
							$shipping[rates] = $settings[rate] + $settings[handling];
							$cart_data[shipping] = xml_doc('include/plugins/checkout_by_amazon/amazon_cart_shipping_shipmentbased.xml', array('name' => 'item-per-order', 'price' => $shipping[rates], 'currency' => $settings[defaultrate]));
							$cart_data[ship_methods] .= xml_doc('include/plugins/checkout_by_amazon/amazon_cart_item_shipping.xml', array('ship_method' => 'item-per-order'));
							break;
						case 'perpound':
							$cart_data[shipping] = xml_doc('include/plugins/checkout_by_amazon/amazon_cart_shipping_weightbased.xml', array('name' => 'item-per-pound', 'price' => $settings[rate], 'handling' => $settings[handling], 'currency' => $settings[defaultrate]));
							$cart_data[ship_methods] .= xml_doc('include/plugins/checkout_by_amazon/amazon_cart_item_shipping.xml', array('ship_method' => 'item-per-pound'));
							break;
						case 'peritem':
							$cart_data[shipping] = xml_doc('include/plugins/checkout_by_amazon/amazon_cart_shipping_quantitybased.xml', array('name' => 'item-per-item', 'price' => $settings[rate], 'handling' => $settings[handling], 'currency' => $settings[defaultrate]));
							$cart_data[ship_methods] .= xml_doc('include/plugins/checkout_by_amazon/amazon_cart_item_shipping.xml', array('ship_method' => 'item-per-item'));
							break;
						case 'percentage';
							$rate = ($subtotal * ($settings[rate] / 100));
							$shipping[rates] = $rate + $settings[handling];
							$cart_data[shipping] = xml_doc('include/plugins/checkout_by_amazon/amazon_cart_shipping_shipmentbased.xml', array('name' => 'item-percentage', 'price' => $shipping[rates], 'currency' => $settings[defaultrate]));
							$cart_data[ship_methods] .= xml_doc('include/plugins/checkout_by_amazon/amazon_cart_item_shipping.xml', array('ship_method' => 'item-percentage'));
							break;
					}
					break;
				
				case 'set':
					foreach ($this->cart_info as $i => $v) {
						$iteminfo = get('products', $v[items]);
						if ($iteminfo[charge_shipping] == "y") $total += ($iteminfo[flat_rate_shipping] * $v[quantity]);
					}
					$shipping[rates] = $total + $settings[handling];
					$cart_data[shipping] = xml_doc('include/plugins/checkout_by_amazon/amazon_cart_shipping_shipmentbased.xml', array('name' => 'item-based', 'price' => $shipping[rates], 'currency' => $settings[defaultrate]));
					$cart_data[ship_methods] .= xml_doc('include/plugins/checkout_by_amazon/amazon_cart_item_shipping.xml', array('ship_method' => 'item-based'));
					break;
				
				default:
					$cart_data[ship_methods] = '';
					break;
			}
			if ($discounts[free_shipping] == 1 || $coupon[free_shipping] == 1) {
				$cart_data[ship_methods] = xml_doc('include/plugins/checkout_by_amazon/amazon_cart_item_shipping.xml', array('ship_method' => 'item-non-shippable'));
				$cart_data[shipping] = '';
			}
			$cart_data[items] = str_replace('{ShippingMethods}', $cart_data[ship_methods], $cart_data[items]);
		}
		
		$cart_entry = $DB_site->query_first("SELECT * FROM ".$dbprefix."users_saved_carts WHERE sessid='".$sess->id()."'");
		$cart_data[requestid] = urlencode(base64_encode($cart_entry[id]));
		
		$cart_data[shopurl] = $settings[shopurl];
		$cart_data[secureurl] = $settings[secureurl];
		$button = explode('_', $this->class_vars[bg]);
		$data = '<?xml version="1.0" encoding="UTF-8"?>'.xml_doc('include/plugins/checkout_by_amazon/amazon_cart.xml', $cart_data);
		
		$plugin_data = '
			<script type="text/javascript" src="https://images-na.ssl-imagesamazon.com/images/G/01/cba/js/jquery.js"></script>
			<script type="text/javascript" src="https://images-na.ssl-imagesamazon.com/images/G/01/cba/js/widget/widget.js"></script>
			<form method="POST" action="'.(($this->class_vars[sandbox]=='true')?'https://payments-sandbox.amazon.com/checkout/':'https://payments.amazon.com/checkout/').trim($this->class_vars[merchant_id]).'?debug=true">
				<input type="hidden" name="order-input" value="type:merchant-signed-order/aws-accesskey/1;order:'.base64_encode($data).';signature:'.$this->sign_n_pack($data, trim($this->class_vars[merchant_key_secret])).';aws-access-key-id:'.trim($this->class_vars[merchant_key_id]).'" />
				<input alt="Checkout with Amazon Payments" src="https://payments.amazon.com/gp/cba/button?ie=UTF8&color='.$button[0].'&background='.$button[1].'&size='.$this->class_vars[size].'" type="image">
			</form>
		';
		
		return template('plugin_checkout_by_amazon.html', array('out' => array('button_output' => $plugin_data), 'lang' => $lang['plugin']));
	}
	
	function install () {
		global $DB_site, $dbprefix, $settings;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='merchant_id', `name`='Your Merchant ID', `options`='', `value`='', `help`='Your Merchant ID', `size`='30', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='merchant_key_id', `name`='Access Key ID', `options`='', `value`='', `help`='Your Access Key ID', `size`='30', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='merchant_key_secret', `name`='Secret Access Key', `options`='', `value`='', `help`='Your Secret Access Key', `size`='30', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='bg', `name`='Image Style', `moptions`='', `options`='orange_white::tan_white::orange_other::tan_other->Light Backgound Orange Button::Light Backgound Tan Button::Dark Backgound Orange Button::Dark Backgound Tan Button', `value`='light_orange', `help`='Image and background type that will be used to display your checkout button.', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='size', `name`='Image Size', `moptions`='', `options`='medium::large->Medium::Large', `value`='medium', `help`='Image size that will be used to display your checkout button.', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='sandbox', `name`='Sandbox Mode', `options`='true::false->Yes::No', `value`='false', `help`='Set to this value for testing mode. Set to \"No\" for LIVE.', `size`='0', `dorder`='7', `field_type`='dropdown'");
		
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='enabled', `name`='', `moptions`='', `options`='', `value`='0', `help`='', `size`='', `dorder`='', `field_type`='hidden'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='seller_email', `name`='Seller Central Email', `options`='', `value`='', `help`='Your seller central email address.', `size`='40', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='seller_pass', `name`='Seller Central Password', `options`='', `value`='', `help`='Your seller central password.', `size`='30', `dorder`='2', `field_type`='password'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='merchant_token', `name`='Merchant Token', `options`='', `value`='', `help`='Your Merchant Token', `size`='30', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='merchant_name', `name`='Merchant Name', `options`='', `value`='', `help`='Your Merchant Name', `size`='30', `dorder`='4', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_plugins where `module`='checkout_by_amazon'");
		$DB_site->query("DELETE FROM ".$dbprefix."modules_methods where `module`='checkout_by_amazon'");
	}
}

$OUT_DATA = 'PHRhYmxlIGJvcmRlcj0iMCIgY2VsbHNwYWNpbmc9IjAiIGNlbGxwYWRkaW5nPSIzIj4NCgk8dHI+DQoJCTx0ZCB2YWxpZ249Im1pZGRsZSI+PGltZ
	yBzcmM9ImltYWdlcy9hbWF6b25fcGF5bWVudHMucG5nIiBhbHQ9IkFtYXpvbiBQYXltZW50cyIgd2lkdGg9IjEzNCIgaGVpZ2h0PSI4NCIgYm9yZGVyPSIwIiB
	zdHlsZT0iYm9yZGVyOiAwcHggc29saWQgIzAwMDAwMDsiPjwvdGQ+DQoJCTx0ZD48aW1nIHNyYz0iJHNldHRpbmdzW3RoZW1lX3BhdGhdL2ltYWdlcy9zcGFjZ
	S5naWYiIHdpZHRoPSIxMCIgaGVpZ2h0PSIxIiBib3JkZXI9IjAiPjwvdGQ+DQoJCTx0ZCB2YWxpZ249Im1pZGRsZSI+DQoJCQlBbWF6b24gUGF5bWVudHMgb2Z
	mZXJzIG1lcmNoYW50cyBhIHNldCBvZiBwYXltZW50IGFuZCBjaGVja291dCBzb2x1dGlvbnMgdGhhdCB0aGV5IGNhbiBpbnRlZ3JhdGUgDQoJCQlvbiB0aGVpc
	iBzaXRlLiBUaGVzZSBzb2x1dGlvbnMgZW5hYmxlIHRoZSB0ZW5zIG9mIG1pbGxpb25zIG9mIEFtYXpvbiBjdXN0b21lcnMgdG8gY29tcGxldGUgcHVyY2hhc2V
	zIG9uIHlvdXIgDQoJCQl3ZWJzaXRlIHVzaW5nIHRoZSBzYW1lIGluZm9ybWF0aW9uIGluIHRoZWlyIEFtYXpvbi5jb20gYWNjb3VudC48YnI+PGJyPg0KCQkJP
	GlucHV0IHR5cGU9ImJ1dHRvbiIgdmFsdWU9IkxlYXJuIE1vcmUiIG9uQ2xpY2s9IndpbmRvdy5vcGVuKCdodHRwOi8vd3d3LnR1cm5rZXl3ZWJ0b29scy5jb20
	vc3Vuc2hvcC9hbWF6b24uaHRtbCcsJ0FtYXpvbicsJ3dpZHRoPTYwMCxoZWlnaHQ9NTAwLHJlc2l6YWJsZT0xLHNjcm9sbGJhcnM9MSx0aXRsZWJhcj0xLG1lb
	nViYXI9MSx0b29sYmFyPTEsbG9jYXRpb249MSxzdGF0dXM9MSxkaXJlY3Rvcmllcz0xLGNoYW5uZWxtb2RlPTAsZnVsbHNjcmVlbj0wJyk7IHJldHVybiBmYWx
	zZTsiPg0KCQk8L3RkPg0KDQoJPC90cj4NCjwvdGFibGU+';
?>