<?PHP
/*
  include/payment/usight.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "uSight";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "usight";

class usight {
	var $class_vars;
	
	function usight ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $settings, $userinfo, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		/**** Login Information ****/
		$data  = "GWUsername=".$this->class_vars[GWUsername]."&";
		
		/**** Contact Information ****/
		$data .= "GWBillingFirstName=".$userinfo[bill_first_name]."&";
		$data .= "GWBillingLastName=".$userinfo[bill_last_name]."&";
		$data .= "Phone=".$userinfo[phone]."&";
		$data .= "GWBillingAddress=".urlencode($userinfo[bill_address1])."&";
		$data .= "GWBillingCity=".urlencode($userinfo[bill_city])."&";
		$data .= "GWBillingState=".(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2))."&";
		$data .= "GWBillingZip=".$userinfo[bill_zip]."&";
		$data .= "GWBillingCountry=".$userinfo[bill_country]."&";
		$data .= "Email=".$userinfo[email]."&";
		
		/**** Credit Card Information ****/ 
		$data .= "GWNameOnCard=".urlencode($orderinfo[cc_name_on_card])."&";
		$data .= "GWCardNumber=".tempdecryptit($orderinfo[cc_card_no])."&";
		$data .= "CVV2=".$orderinfo[cc_cvv2]."&";
		$data .= "GWCardExpMonth=".$orderinfo[cc_expir_month]."&";
		$data .= "GWCardExpYear=".$orderinfo[cc_expir_year]."&";
		
		/**** Transaction Information ****/ 
		$data .= "InvoiceNo=".$oid."&";
		$data .= "Description=".urlencode($settings[title])."%20Order%20Payment&";
		$data .= "GWAmount=".p($orderinfo[total], false)."";
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		$result["addon_message"] 	= $auth["ResponseMessage"];
		$result["addon_code"]		= $auth["ResponseCode"];
		$result["addon_oid"] 		= $auth["TransactionID"];
		
		if ($auth["ResponseCode"] == "0") {
			$result["approved"] = "Approved";
		} else {
			$result["approved"] = "Error";
		}
		
		return $result;
	}
	
	function parse_return ($in) {
		$vars = explode("&", $in);
		for ($i=0; $i<count($vars); $i++) {
			$set = explode("=",$vars[$i]);
			$temp1 = $set[0]; $temp2 = $set[1];
			$results[$temp1] = urldecode($temp2);
		}
		return $results;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='usight', `internalname`='GWUsername', `name`='Merchant Username', `options`='', `value`='', `help`='Your assigned merchant username.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='usight', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://gateway.usight.com/postauth.secure', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='2', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='usight'");
	}
}
?>
