<?PHP
/*
  include/payment/quantum_gateway_trans.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Quantum Transparent Gateway (CDGCommerce)";
$ADDON_VERSION 	= "1.2";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "quantum_trans";

class quantum_trans {
	var $class_vars;
	
	function quantum_trans ($class_vars) {
		$this->class_vars = $class_vars;
	}
        
        function process () {
		global $settings, $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$data = array (
			'gwlogin'				=> $this->class_vars[plid],
			'RestrictKey'			=> $this->class_vars[rkey],
			
			'FNAME'					=> $userinfo[bill_first_name],
			'LNAME'					=> $userinfo[bill_last_name],
			'phone'					=> $userinfo[phone],
			'BADDR1'				=> $userinfo[bill_address1],
			'BCITY'					=> $userinfo[bill_city],
			'BSTATE'				=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'BZIP1'					=> $userinfo[bill_zip],
			'BCOUNTRY'				=> $userinfo[bill_country],
			'company'				=> $userinfo[bill_company_name],
			'BCUST_EMAIL'			=> $userinfo[email],
			
			'ccnum'					=> tempdecryptit($orderinfo[cc_card_no]),
			'CVV2'					=> $orderinfo[cc_cvv2],
			'ccmo'					=> $orderinfo[cc_expir_month],
			'ccyr'					=> $orderinfo[cc_expir_year],
			
			'amount'				=> p($orderinfo[total], false),
			'cust_id'				=> $sess->gvar('userid'),
			'invoice_num'			=> $oid,
			'invoice_description'	=> $settings[title]."%20Order%20Payment",
			'customer_ip'			=> $_SERVER['REMOTE_ADDR'],
			
			'SFNAME'				=> $userinfo[ship_first_name],
			'SLNAME'				=> $userinfo[ship_last_name],
			'SADDR1'				=> $userinfo[ship_address1],
			'SCITY'					=> $userinfo[ship_city],
			'SSTATE'				=> (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)),
			'SZIP1'					=> $userinfo[ship_zip],
			'SCOUNTRY'				=> $userinfo[ship_country],
			
			'Dsep'					=> ',',
			'trans_method'			=> 'CC',
			'trans_type'			=> 'CREDIT',
			'MAXMIND'				=> $this->class_vars[umax]
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$results = $cconnect->connect($data_string, $header, array(), $this->class_vars[checkoutlink]);
		$auth = $this->parse_return($results);
		
		$auth["addon_message"] 	= ($auth["decl_reas"]=="")?'This transaction has been declined.':$auth["decl_reas"];
		$auth["addon_code"]		= $auth["decl_error"];
		$auth["addon_oid"] 		= $auth["trans_id"];
		$auth["addon_avs"]		= $auth["avs_resp"];
		$auth["addon_cvn"]		= $auth["cvv2_resp"];
		$auth["addon_notes"]	= ($auth["maxmind"]!="")?'MaxMind Score: '.$auth["maxmind"]:"";
		
		if ($auth["status"] == "APPROVED") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
        function parse_return ($in) {
		$auth_array = explode(",", str_replace("\"", "", $in));
		$out = array(
			"status"	=> "$auth_array[0]",
			"auth_code"	=> "$auth_array[1]",
			"trans_id"	=> "$auth_array[2]",
			"avs_resp"	=> "$auth_array[3]",
			"cvv2_resp"	=> "$auth_array[4]",
			"maxmind"	=> "$auth_array[5]",
			"decl_reas"	=> "$auth_array[6]",
			"decl_error"=> "$auth_array[7]"
		);
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='quantum_trans', `internalname`='plid', `name`='Gateway Login', `options`='', `value`='', `help`='Set this to your assigned gateway login.', `size`='15', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='quantum_trans', `internalname`='rkey', `name`='Restrict Key', `options`='', `value`='', `help`='Set this to your configured key from the Processing Settings.', `size`='15', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='quantum_trans', `internalname`='checkoutlink', `name`='Checkout Link', `options`='', `value`='https://secure.quantumgateway.com/cgi/tqgwdbe.php', `help`='Transaction URL. Change from default if necessary.', `size`='60', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='quantum_trans', `internalname`='umax', `name`='Max Mind Status', `options`='1::2->On::Off', `value`='', `help`='Max Mind fraud control status.', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='quantum_trans', `internalname`='pass_type', `name`='', `options`='', `value`='post', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='quantum_trans'");
	}
}

$OUT_DATA = 'PHRhYmxlIGJvcmRlcj0iMCIgY2VsbHNwYWNpbmc9IjAiIGNlbGxwYWRkaW5nPSIzIj4NCgk8dHI+DQoJCTx0ZCB2YWxpZ249Im1pZGRsZSI+PGltZyBzcmM9ImltYWdl
	cy9jZGdfbG9nby5naWYiIGFsdD0iQ0RHY29tbWVyY2UiIHdpZHRoPSIxNTYiIGhlaWdodD0iMTA0IiBib3JkZXI9IjAiPjwvdGQ+DQoJCTx0ZD48aW1nIHNyYz0iJHNldHRpbmdzW
	3RoZW1lX3BhdGhdL2ltYWdlcy9zcGFjZS5naWYiIHdpZHRoPSIxMCIgaGVpZ2h0PSIxIiBib3JkZXI9IjAiPjwvdGQ+DQoJCTx0ZCB2YWxpZ249Im1pZGRsZSI+DQoJCQlGUkVFIE
	1lcmNoYW50IEFjY291bnQgUHJvbW90aW9uIGZyb20gVHVybmtleSBXZWIgVG9vbHMsIEluYy4gJiBDREdjb21tZXJjZTxicj48YnI+DQoJCQk8aW5wdXQgdHlwZT0iYnV0dG9uIiB
	2YWx1ZT0iTGVhcm4gTW9yZSIgb25DbGljaz0id2luZG93Lm9wZW4oJ2h0dHA6Ly93d3cudHVybmtleXdlYnRvb2xzLmNvbS9pbmRleC5waHA/bD1jZGdjb21tZXJjZScsJ2NkZ2lu
	Zm8nLCd3aWR0aD02MDAsaGVpZ2h0PTUwMCxyZXNpemFibGU9MSxzY3JvbGxiYXJzPTEsdGl0bGViYXI9MSxtZW51YmFyPTEsdG9vbGJhcj0xLGxvY2F0aW9uPTEsc3RhdHVzPTEsZ
	GlyZWN0b3JpZXM9MSxjaGFubmVsbW9kZT0wLGZ1bGxzY3JlZW49MCcpOyByZXR1cm4gZmFsc2U7Ij4NCgkJPC90ZD4NCg0KCTwvdHI+DQo8L3RhYmxlPg==';

?>