<?PHP
/*
  include/payment/paypal_pro.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "PayPal Web Payments Pro";
$ADDON_VERSION 	= "1.2";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "paypal_pro";

class paypal_pro {
	var $class_vars;
	
	function paypal_pro ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $cconnect, $abs_path, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		if ($orderinfo[ship_other] != "") $orderinfo[ship_state] = $orderinfo[ship_other];
		if ($orderinfo[bill_other] != "") $orderinfo[bill_state] = $orderinfo[bill_other];
		if ($userinfo[ship_other] != "") $userinfo[ship_state] = $userinfo[ship_other];
		if ($userinfo[bill_other] != "") $userinfo[bill_state] = $userinfo[bill_other];
		
		$url = ($this->class_vars[sandbox]=='true')?'https://api.sandbox.paypal.com/2.0/':'https://api-3t.paypal.com/2.0/';
		
		switch ($orderinfo[cc_card_type]) {
			case 'Mastercard':
				$pp_type = 'MasterCard';
				break;
			case 'American Express':
				$pp_type = 'Amex';
				break;
			default:
				$pp_type = $orderinfo[cc_card_type];
				break;
		}
		
		$vars = array_merge (
			$userinfo,
			$orderinfo,
			$this->class_vars,
			array (
				'action'			=> $this->class_vars[action],
				'currency'			=> $settings[defaultrate],
				'total'				=> p($orderinfo[total], false),
				'cc_card_no'		=> tempdecryptit($orderinfo[cc_card_no]),
				'ip_address' 		=> $_SERVER['REMOTE_ADDR'],
				'cc_card_type'		=> $pp_type
			)
		);
		
		$xml_data	= xml_doc('include/payment/paypal_pro/paypal_pro_direct.xml', $vars);
		
		$results	= $cconnect->connect($xml_data, $header, array(), $url);
		$paypal		= $this->parse_return($results);
		
		$this->set_codes();
		
		$paypal["addon_message"]	= $paypal['faultstring']?$paypal['faultstring']:$paypal['Errors']['LongMessage'];
		$paypal["addon_code"]		= $paypal['faultcode']?$paypal['faultcode']:$paypal['Errors']['ErrorCode'];
		$paypal["addon_oid"]		= $paypal['TransactionID'];
		$paypal["addon_avs"]		= $this->avs[$paypal['AVSCode']];
		$paypal["addon_cvn"]		= $this->cvn[$paypal['CVV2Code']];
		
		if ($paypal['Ack'] == "Success") {
			$paypal["approved"] = "Approved";
			$paypal["notes"] = 'Payment reference id: '.$paypal['TransactionID'];
		} else {
			$paypal["approved"] = "Error";
		}
		return $paypal;
	}
	
	function parse_return ($in) {
		global $abs_path;
		include_once $abs_path.'/include/soap/nusoap.php';
		$parser = new soap_parser($in, 'UTF-8');
		$out = $parser->get_response();
		return $out;
	}
	
	function set_codes () {
		$this->avs = array(
			"A" => "Address only match (no zip)",
			"B" => "Int. address only match (no zip)",
			"C" => "Int. nothing matched",
			"D" => "Int. exact match. Address and five-digit zip code",
			"E" => "Not allowed for MOTO (Internet/Phone) transactions",
			"F" => "UK exact match. Address and postal code",
			"G" => "Global unavailable",
			"I" => "International unavailable",
			"N" => "None",
			"P" => "Postal code only match (no address)",
			"R" => "Retry",
			"S" => "Service not supported",
			"U" => "Unavailable",
			"W" => "Nine-digit zip code match (no address)",
			"X" => "Exact match. Address and five-digit zip code",
			"Y" => "Address and five-digit zip",
			"Z" => "Five-digit zip code match (no address)"
		);
		
		$this->cvn = array(
			"M" => "Match",
			"N" => "No match",
			"P" => "Not processed",
			"S" => "Service not supported",
			"U" => "Unavailable",
			"X" => "No response"
		);
	}
	
	function install () {
		global $DB_site, $dbprefix;
		// Delete Before Installing
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='paypal_pro'");
		$DB_site->query("DELETE FROM ".$dbprefix."modules_methods where `module`='paypal_express_checkout'");
		$DB_site->query("DELETE FROM ".$dbprefix."modules_plugins where `module`='paypal_express'");
		// Installing PayPal Pro
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paypal_pro', `internalname`='username', `name`='API Access User ID', `moptions`='', `options`='', `value`='', `help`='.', `size`='40', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paypal_pro', `internalname`='password', `name`='API Access Password', `moptions`='', `options`='', `value`='', `help`='', `size`='40', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paypal_pro', `internalname`='signature', `name`='API Access Signature', `moptions`='', `options`='', `value`='', `help`='', `size`='60', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paypal_pro', `internalname`='action', `name`='Authorize & Capture', `moptions`='', `options`='Sale::Authorization->Authorization & Capture::Authorization Only', `value`='Sale', `help`='', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paypal_pro', `internalname`='sandbox', `name`='Sandbox Mode', `moptions`='', `options`='true::false->Yes::No', `value`='false', `help`='Set to this value for testing mode. Set to \"No\" for LIVE.', `size`='0', `dorder`='5', `field_type`='dropdown'");
		// Install Express Checkout Plugin & Method
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_express_checkout', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='If enabaled, PayPal Web Payments Pro payment module must be installed and the credentials set in that module.', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_express_checkout', `internalname`='display_name', `name`='Display Name', `moptions`='', `options`='', `value`='<img src=\"https://www.paypal.com/en_US/i/logo/PayPal_mark_37x23.gif\" alt=\"\" width=\"37\" height=\"23\" border=\"0\"> Save time. Check out securely. Pay without sharing your financial information.', `help`='', `size`='36', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='paypal_express', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='If enabaled, PayPal Web Payments Pro payment module must be installed and the credentials set in that module.', `size`='0', `dorder`='1', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='paypal_pro'");
		$DB_site->query("DELETE FROM ".$dbprefix."modules_methods where `module`='paypal_express_checkout'");
		$DB_site->query("DELETE FROM ".$dbprefix."modules_plugins where `module`='paypal_express'");
	}
}



