<?PHP
/*
  include/payment/paymenow.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Pay-Me-Now";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "paymenow";

class paymenow {
	var $class_vars;
	
	function paymenow ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $settings, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		/**** Login Information ****/
		$data   = "acctid=".$this->class_vars[merchant_id]."&";
		$data  .= "merchantPIN=".$this->class_vars[merchant_pin]."&";
		
		/**** Billing Information ****/
		$data .= "ci_billaddr1=".urlencode($userinfo[bill_address1])."&";
		$data .= "ci_billaddr2=".urlencode($userinfo[bill_address2])."&";
		$data .= "ci_billcity=".$userinfo[bill_city]."&";
		$data .= "ci_billstate=".(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2))."&";
		$data .= "ci_billzip=".$userinfo[bill_zip]."&";
		$data .= "ci_billcountry=".$userinfo[bill_country]."&";
		$data .= "ci_email=".$userinfo[email]."&";
		$data .= "ci_phone=".$userinfo[phone]."&";
		
		/**** Shipping Information ****/
		$data .= "ci_shipaddr1=".urlencode($userinfo[ship_address1])."&";
		$data .= "ci_shipaddr2=".urlencode($userinfo[ship_address2])."&";
		$data .= "ci_shipcity=".$userinfo[ship_city]."&";
		$data .= "ci_shipstate=".(($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2))."&";
		$data .= "ci_shipzip=".$userinfo[ship_zip]."&";
		$data .= "ci_shipcountry=".$userinfo[ship_country]."&";
		
		/**** Credit Card Information ****/ 
		$data .= "ccname=".$orderinfo[noc]."&";
		$data .= "ccnum=".tempdecryptit($orderinfo[cc_card_no])."&";
		$data .= "cvv2=".$orderinfo[cc_cvv2]."&";
		$data .= "expmon=".$orderinfo[cc_expir_month]."&";
		$data .= "expyear=".$orderinfo[cc_expir_year]."&";
		
		/**** Transaction Information ****/ 
		$data .= "action=ns_quicksale_cc&";
		$data .= "emailfrom=".$settings[contactemail]."&";
		$data .= "amount=".p($orderinfo[total], false)."&";
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$result	 = $this->parse_return($results);
		
		
		$auth["addon_message"] 	= $result["Reason"];
		$auth["addon_code"]		= "";
		$auth["addon_oid"] 		= $result["orderid"];
		
		if ($result["result"] == "1") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$in = str_replace("<html><body><plaintext>", "", $in);
		$results = explode("\n", $in);
		for ($i=0; $i<count($results); $i++) {
			$split = explode("=", $results[$i]);
			$out[trim($split[0])] = trim($split[1]);
		}
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paymenow', `internalname`='merchant_id', `name`='Merchant ID', `options`='', `value`='', `help`='Your assigned Pay-Me-Now merchant id.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paymenow', `internalname`='merchant_pin', `name`='Merchant Pin', `options`='', `value`='', `help`='Your assigned Pay-Me-Now merchant pin. (if needed)', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paymenow', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://trans.merchantpartners.com/cgi-bin/process.cgi', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='3', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='paymenow'");
	}
}
?>
