<?PHP
/*
  include/payment/moneris_eselect.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Moneris e-Select Plus (cURL)";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "moneris_eselect";

class moneris_eselect {
	var $class_vars;
	
	function moneris_eselect ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $abs_path, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		include $abs_path."/include/payment/moneris_eselect/eselect.php";
		
		$mpgCustInfo = new mpgCustInfo();
		
		$mpgCustInfo->setEmail($userinfo[email]);
		
		$billing = array( 
			first_name 		=> $userinfo[bill_first_name], 
			last_name 		=> $userinfo[bill_last_name], 
			company_name 	=> $userinfo[company], 
			address 		=> $userinfo[bill_address1], 
			city 			=> $userinfo[bill_city], 
			province 		=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)), 
			postal_code 	=> $userinfo[bill_zip], 
			country 		=> $userinfo[bill_country], 
			phone_number	=> $userinfo[phone], 
			fax 			=> 'N/A', 
			tax1 			=> $orderinfo[tax], 
			tax2 			=> '', 
			tax3 			=> '', 
			shipping_cost 	=> $orderinfo[ship_price]
		);
		
		$mpgCustInfo->setBilling($billing);
		
		$shipping = array( 
			first_name 		=> $userinfo[ship_first_name], 
			last_name 		=> $userinfo[ship_last_name], 
			company_name 	=> $userinfo[company], 
			address 		=> $userinfo[ship_address1], 
			city 			=> $userinfo[ship_city], 
			province 		=> (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)), 
			postal_code 	=> $userinfo[ship_zip], 
			country 		=> $userinfo[ship_country], 
			phone_number 	=> $userinfo[phone], 
			fax 			=> 'N/A', 
			tax1 			=> '', 
			tax2 			=> '', 
			tax3 			=> '', 
			shipping_cost 	=> ''
		);
		
		$mpgCustInfo->setShipping($shipping);
		
		$txnArray = array(
			type 		=> 'purchase', 
			order_id 	=> $sess->gvar('userid')."-".date("mdyHis"), 
			cust_id 	=> $sess->gvar('userid'), 
			amount 		=> p($orderinfo[total], false), 
			pan 		=> tempdecryptit($orderinfo[cc_card_no]), 
			expdate 	=> substr($orderinfo[cc_expir_year], 2, 2).$orderinfo[cc_expir_month], 
			crypt_type	=> '7' 
		);
		
		$mpgTxn = new mpgTransaction($txnArray);
		$mpgTxn->setCustInfo($mpgCustInfo);
		$mpgRequest  = new mpgRequest($mpgTxn);
		$mpgHttpPost = new mpgHttpsPost($this->class_vars[storeid], $this->class_vars[apitoken], $mpgRequest);
		$mpgResponse = $mpgHttpPost->getMpgResponse();
		
		$return["addon_message"] 	= $mpgResponse->getMessage();
		$return["addon_code"]		= $mpgResponse->getResponseCode();
		$return["addon_oid"] 		= $mpgResponse->getTxnNumber();
		
		if ($return[addon_code] < 50 && is_numeric($return[addon_code])) {
			$return["approved"] = "Approved";
		} else {
			$return["approved"] = "Error";
		}
		
		return $return;
	}
	
	function parse_return ($in) {
		return;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='moneris_eselect', `internalname`='storeid', `name`='Store ID', `options`='', `value`='', `help`='Your Moneris e-Select Store ID.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='moneris_eselect', `internalname`='apitoken', `name`='API Token', `options`='', `value`='', `help`='Your Moneris e-Select API Token.', `size`='20', `dorder`='2', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='moneris_eselect'");
	}
}
?>