<?PHP
/*
  include/payment/internet_secure.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Internet Secure";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "internet_secure";

class internet_secure {
	var $class_vars;
	
	function internet_secure ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function pass_cart ($cartinfo) {
		for ($i=0; $i<count($cartinfo[items]); $i++) {
			$this->cartinfo .= $cartinfo[$i][price]."::".$cartinfo[$i][quantity]."::".$cartinfo[$i][items]."::".trim($cartinfo[$i][description])."::|";
		}
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$data = '<?xml version="1.0" encoding="UTF-8"?>
		<TranxRequest>
			<MerchantNumber>'.$this->class_vars[merchid].'</MerchantNumber>
			<Products>'.$this->cartinfo.'</Products>
			<xxxName>'.$orderinfo[cc_name_on_card].'</xxxName>
			<xxxCompany>'.$userinfo[bill_company_name].'</xxxCompany>
			<xxxAddress>'.$userinfo[bill_address1].'</xxxAddress>
			<xxxCity>'.$userinfo[bill_city].'</xxxCity>
			<xxxProvince>'.(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)).'</xxxProvince>
			<xxxPostal>'.$userinfo[bill_zip].'</xxxPostal>
			<xxxCountry>'.$userinfo[bill_country].'</xxxCountry>
			<xxxPhone>'.$userinfo[phone].'</xxxPhone>
			<xxxEmail>'.$userinfo[email].'</xxxEmail>
			
			<xxxShippingName>'.$userinfo[ship_first_name].' '.$userinfo[ship_last_name].'</xxxShippingName>
			<xxxShippingCompany>'.$userinfo[bill_company_name].'</xxxShippingCompany>
			<xxxShippingAddress>'.$userinfo[bill_address1].'</xxxShippingAddress>
			<xxxShippingCity>'.$userinfo[ship_city].'</xxxShippingCity>
			<xxxShippingProvince>'.(($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)).'</xxxShippingProvince>
			<xxxShippingPostal>'.$userinfo[ship_zip].'</xxxShippingPostal>
			<xxxShippingCountry>'.$userinfo[ship_country].'</xxxShippingCountry>
			<xxxShippingPhone>'.$userinfo[phone].'</xxxShippingPhone>
			<xxxShippingEmail>'.$userinfo[email].'</xxxShippingEmail>
			
			<xxxCard_Number>'.tempdecryptit($orderinfo[cc_card_no]).'</xxxCard_Number>
			<xxxCCMonth>'.$orderinfo[cc_expir_month].'</xxxCCMonth>
			<xxxCCYear>'.$orderinfo[cc_expir_year].'</xxxCCYear>
			<CVV2>'.$orderinfo[cc_cvv2].'</CVV2>
			<CVV2Indicator>1</CVV2Indicator>
			
			<xxxTransType>00</xxxTransType>
			
		</TranxRequest>';
		
		$data = "xxxRequestMode=X&xxxRequestData=".$data;
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: " . strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		$auth["addon_message"] 	= ($auth["Error"]!="")?$auth["Error"]:$auth["Verbiage"];
		$auth["addon_code"]		= $auth["Page"];
		$auth["addon_oid"] 		= $auth["ReceiptNumber"];
		
		if ($auth["addon_code"] == "02000" || $auth["addon_code"] == "2000") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$attributes = array();
		$attributes = XMLParser($in);
		
		reset($attributes);
		while (list ($key, $val) = each ($attributes)) {
			$name = $val['tag']; $value = $val['value'];
			$out[$name] = $value;
		}
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='internet_secure', `internalname`='merchid', `name`='Merchant ID', `options`='', `value`='', `help`='Your Internet Secure merchant ID', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='internet_secure', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://secure.internetsecure.com/process.cgi', `help`='Internet Secure transaction URL', `size`='60', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='internet_secure', `internalname`='pass_cart', `name`='', `options`='', `value`='1', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='internet_secure'");
	}
}
?>
