<?PHP
/*
  include/payment/innovative.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Innovative Solutions";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "innovative";

class innovative {
	var $class_vars;
	
	function innovative ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$transaction = array();
		$transaction["target_app"] 						= "WebCharge_v5.06";
		$transaction["response_mode"] 					= "simple";
		$transaction["response_fmt"] 					= "delimited";
		$transaction["upg_auth"] 						= "zxcvlkjh";
		$transaction["delimited_fmt_field_delimiter"] 	= "=";
		$transaction["delimited_fmt_include_fields"] 	= "true";
		$transaction["delimited_fmt_value_delimiter"] 	= "|";
		$transaction["username"] 						= $this->class_vars[innouser];
		$transaction["pw"] 								= $this->class_vars[innopass];
        $transaction["trantype"] 						= "sale";
        $transaction["reference"] 						= "";
        $transaction["trans_id"] 						= "";
        $transaction["authamount"] 						= "";
        $transaction["cardtype"] 						= str_replace("master", "mc", str_replace("card", "", strtolower($orderinfo[card_type])));
        $transaction["ccnumber"] 						= tempdecryptit($orderinfo[cc_card_no]); 
        $transaction["month"] 							= $orderinfo[cc_expir_month];
        $transaction["year"] 							= $orderinfo[cc_expir_year];
        $transaction["fulltotal"] 						= p($orderinfo[total], false);
        $transaction["ccname"] 							= $orderinfo[cc_name_on_card];
		$transaction["baddress"] 						= $userinfo[bill_address1];
		$transaction["baddress1"] 						= "";
		$transaction["bcity"] 							= $userinfo[bill_city];
		$transaction["bstate"] 							= (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2));
		$transaction["bzip"] 							= $userinfo[bill_zip];
		$transaction["bcountry"] 						= $userinfo[bill_country];
		$transaction["bphone"] 							= $userinfo[phone];
		$transaction["email"] 							= $userinfo[email];
		$transaction["test_override_errors"] 			= $this->class_vars[test_mode];
		
		$data = "";
		foreach ($transaction as $name => $value) {
		    $data .= $name . "=" . urlencode($value). "&";
		}
		
		$header = "";
		$header_array = array();
		
		$results  = $cconnect->connect($data, $header, $header_array, $this->class_vars[innourl]);
		$response = $this->parse_return($results);
		
		$response_back = array();
		$response_back[approved] = ($response[approval]!="")?"Approved":"Error";
		$response_back[addon_message] = $response[error];
		$response_back[addon_oid] = $response[ordernumber];
		
		return $response_back;
	}
	
	function parse_return ($in) {
		$return_arr = explode("|", $in);
		$out = array();
		foreach ($return_arr as $k => $v) {
			$tmp = explode("=",$v);
			if ($tmp[0] != "") $out[strtolower($tmp[0])] = strip_tags($tmp[1]);
		}
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='innovative', `internalname`='innouser', `name`='Username', `options`='', `value`='', `help`='Your Innovative Solutions username.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='innovative', `internalname`='innopass', `name`='Password', `options`='', `value`='', `help`='Your Innovative Solutions password.', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='innovative', `internalname`='innourl', `name`='Transaction URL', `options`='', `value`='https://transactions.innovativegateway.com/servlet/com.gateway.aai.Aai', `help`='Innovative Solutions transaction url. Leave default if you are unsure.', `size`='60', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='innovative', `internalname`='test_mode', `name`='Test Mode', `options`='True::->True::False', `value`='True', `help`='Set to this value for testing mode. Set to \"False\" for LIVE.', `size`='0', `dorder`='4', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='innovative'");
	}
}
?>