<?PHP
/*
  include/payment/hsbc.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

include_once $abs_path.'/include/payment/hsbc/key_functions.php';

$ADDON_NAME 	= "HSBC Bank";
$ADDON_VERSION 	= "2.5";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "hsbc";

$ADDON_SHOPOID	= "OrderId";
$ADDON_TOTAL	= "PurchaseAmount";
$ADDON_ORDERID	= "OrderId";

class hsbc {
	var $class_vars;
	var $codes;
	
	function hsbc ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function skip_form () {
		global $settings, $orderinfo, $sess;
		$sess->dvar('orderinfo'); 
		$sess->svar('orderinfo', $orderinfo);
		header('location: '.$settings[secureurl].'checkout.php?l=review');
		exit;
	}
	
	function hold_forward () {
		global $settings, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$append = array('status' => 'Pending', 'cc_status' => 'Awaiting Payment', 'pm_name' => 'HSBC Bank');
		$orderid = store_order($append, '', false);	
		
		$post_data = array(
			"CpiDirectResultUrl"	=> $settings[secureurl]."checkout.php?return=credit_card",
			"CpiReturnUrl"			=> $settings[secureurl]."checkout.php?return=credit_card",
			"MerchantData"			=> "",
			"Mode"					=> $this->class_vars[test_mode],
			"OrderDesc"				=> 'Payment for transaction #'.$orderid,
			"OrderId"				=> $orderid,
			"PurchaseAmount"		=> p($orderinfo[total], false) * (($this->class_vars[currency]!="392")? 100 : 1),
			"PurchaseCurrency"		=> $this->class_vars[currency],
			"StorefrontId"			=> $this->class_vars[storefrontid],
			"TimeStamp"				=> (time())."000",
			"TransactionType"		=> "Capture",
			"UserId"				=> $sess->gvar('userid')
		);
		
		$billing_info = array(
			"BillingAddress1" 		=> $userinfo[bill_address1],
			"BillingCity" 			=> $userinfo[bill_city],
			"BillingCountry" 		=> $this->codes($userinfo[bill_country]),
			"BillingCounty" 		=> ((($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)) && (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)) != "No") ? (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)): "n/a",
			"BillingFirstName" 		=> $userinfo[bill_first_name],
			"BillingLastName" 		=> $userinfo[bill_last_name],
			"BillingPostal" 		=> $userinfo[bill_zip],
			"ShopperEmail" 			=> $userinfo[email]
		);
		
		$shipping_info = array (
			"ShippingAddress1" 		=> $userinfo[ship_address1],
			"ShippingCity"			=> $userinfo[ship_city],
			"ShippingCountry" 		=> $this->codes($userinfo[ship_country]),
			"ShippingCounty" 		=> ((($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)) && (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)) != "No") ? (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)): "n/a",
			"ShippingFirstName" 	=> $userinfo[ship_first_name],
			"ShippingLastName" 		=> $userinfo[ship_last_name],
			"ShippingPostal" 		=> $userinfo[ship_zip]
		);
		
		$post = array_merge($post_data, $billing_info, $shipping_info);
		
		switch ($this->class_vars[hash]) {
			case 'PHP':
				$hash = generateHash(array_values($post), $this->class_vars[hashkey]);
				break;
			default:
				$order_line = join("\" \"", $post);
				
				$genhash_str = "cd include/payment/hsbc/;LD_LIBRARY_PATH=`pwd`;export LD_LIBRARY_PATH;./TestHash.e";
				@exec($genhash_str." ".$this->class_vars[hashkey]." \"".$order_line."\" 2>&1", $data);
				$data = $data[0];
				
				if (!preg_match("/^Hash value:  (.*)$/", $data, $a)) {
					echo "Error generating OrderHash. Make sure hsbc/TestHash.e is allowed execute permissions.<br><br>Output: ".$data; 
					exit;
				}
				$hash = $a[1];
				break;
		}
		
		$post["OrderHash"] = $hash;
		
		if ($post) {
			foreach($post as $k => $v) $out[payment_tags] .= '<input type="hidden" name="'.$k.'" value="'.$v.'">'."\n";
		}
		
		$out[url] = $this->class_vars[checkoutlink];
		$out[method] = "POST";
		
		return $out;
	}
	
	function catch_return () {
		global $userinfo, $orderinfo;
		
		$errarr = array(
			"1"		=> "The user cancelled the transaction.",
			"2"		=> "The processor declined the transaction for an unknown reason.",
			"3"		=> "The transaction was declined because of a problem with the card. For example, an invalid card number or expiration date was specified.",
			"4"		=> "The processor did not return a response.",
			"5"		=> "The amount specified in the transaction was either too high or too low for the processor.",
			"6"		=> "The specified currency is not supported by either the processor or the card.",
			"7"		=> "The order is invalid because the order ID is a duplicate.",
			"8"		=> "The transaction was rejected by FraudShield.",
			"9"		=> "The transaction was placed in Review state by FraudShield.",
			"10"	=> "The transaction failed because of invalid input data.",
			"11"	=> "The transaction failed because the CPI was configured incorrectly.",
			"12"	=> "The transaction failed because the Storefront was configured incorrectly.",
			"13"	=> "The connection timed out.",
			"14"	=> "The transaction failed because the cardholders browser refused a cookie.",
			"15"	=> "The customers browser does not support 128-bit encryption.",
			"16"	=> "The CPI cannot communicate with the Secure ePayment engine."
		);
		
		if ($_POST['CpiResultsCode'] == "9") {
			$auth["approved"] = "Review";
			$auth["a_notes"] = 'The transaction was placed in Review state by FraudShield.';
		} elseif ($_POST['CpiResultsCode']) {
			$results['approved'] = "Error";
			$results[error] = $_POST['CpiResultsCode']." - ".$errarr[$_POST['CpiResultsCode']];
		} else {
			$results['approved'] = "Approved";
		}
		return $results;
	}
	
	function codes ($in) {
		$codes = array(
			'AF' => '004', 'AL' => '008', 'DZ' => '012', 'AS' => '016', 'AD' => '020', 'AO' => '024', 'AI' => '660', 'AG' => '028',
			'AR' => '032', 'AM' => '051', 'AW' => '533', 'AU' => '036', 'AT' => '040', 'AZ' => '031', 'BS' => '044', 'BH' => '048',
			'BD' => '050', 'BB' => '052', 'BY' => '112', 'BE' => '056',	'BZ' => '084', 'BJ' => '204', 'BM' => '060', 'BT' => '064',
			'BO' => '068', 'BA' => '070', 'BW' => '072', 'BR' => '076', 'BN' => '096', 'BG' => '100', 'BF' => '854', 'BI' => '108',
			'KH' => '116', 'CM' => '120', 'CA' => '124', 'CV' => '132', 'KY' => '136', 'CF' => '140', 'TD' => '148', 'CL' => '152',
			'CN' => '156', 'CO' => '170', 'KM' => '174', 'CG' => '178', 'CD' => '180', 'CK' => '184', 'CR' => '188', 'CI' => '384',
			'HR' => '191', 'CU' => '192', 'CY' => '196', 'CZ' => '203', 'DK' => '208', 'DJ' => '262', 'DM' => '212', 'DO' => '214',
			'EC' => '218', 'EG' => '818', 'SV' => '222', 'GQ' => '226', 'ER' => '232', 'EE' => '233', 'ET' => '231', 'FK' => '238',
			'FO' => '234', 'FJ' => '242', 'FI' => '246', 'FR' => '250', 'GF' => '254', 'PF' => '258', 'GA' => '266', 'GM' => '270',
			'GE' => '268', 'DE' => '276', 'GH' => '288', 'GI' => '292', 'GR' => '300', 'GL' => '304', 'GD' => '308', 'GP' => '312',
			'GU' => '316', 'GT' => '320', 'GN' => '324', 'GW' => '624', 'GY' => '328', 'HT' => '332', 'VA' => '336', 'HN' => '340',
			'HK' => '344', 'HU' => '348', 'IS' => '352', 'IN' => '356', 'ID' => '360', 'IR' => '364', 'IQ' => '368', 'IE' => '372',
			'IL' => '376', 'IT' => '380', 'JM' => '388', 'JP' => '392', 'JO' => '400', 'KZ' => '398', 'KE' => '404', 'KI' => '296',
			'KP' => '408', 'KR' => '410', 'KW' => '414', 'KG' => '417', 'LA' => '418', 'LV' => '428', 'LB' => '422', 'LS' => '426',
			'LR' => '430', 'LY' => '434', 'LI' => '438', 'LT' => '440', 'LU' => '442', 'MO' => '446', 'MK' => '807', 'MG' => '450',
			'MW' => '454', 'MY' => '458', 'MV' => '462', 'ML' => '466', 'MT' => '470', 'MH' => '584', 'MQ' => '474', 'MR' => '478',
			'MU' => '480', 'MX' => '484', 'FM' => '583', 'MD' => '498', 'MC' => '492', 'MN' => '496', 'MS' => '500', 'MA' => '504',
			'MZ' => '508', 'MM' => '104', 'NA' => '516', 'NR' => '520', 'NP' => '524', 'NL' => '528', 'AN' => '530', 'NC' => '540',
			'NZ' => '554', 'NI' => '558', 'NE' => '562', 'NG' => '566', 'NU' => '570', 'NF' => '574', 'MP' => '580', 'NO' => '578',
			'OM' => '512', 'PK' => '586', 'PW' => '585', 'PA' => '591', 'PG' => '598', 'PY' => '600', 'PE' => '604', 'PH' => '608',
			'PN' => '612', 'PL' => '616', 'PT' => '620', 'PR' => '630', 'QA' => '634', 'RE' => '638', 'RO' => '642', 'RU' => '643',
			'RW' => '646', 'SH' => '654', 'KN' => '659', 'LC' => '662', 'PM' => '666', 'VC' => '670', 'WS' => '882', 'SM' => '674',
			'ST' => '678', 'SA' => '682', 'SN' => '686', 'SC' => '690', 'SL' => '694', 'SG' => '702', 'SK' => '703', 'SI' => '705',
			'SB' => '090', 'SO' => '706', 'ZA' => '710', 'ES' => '724', 'LK' => '144', 'SD' => '736', 'SR' => '740', 'SJ' => '744',
			'SZ' => '748', 'SE' => '752', 'CH' => '756', 'SY' => '760', 'TW' => '158', 'TJ' => '762', 'TZ' => '834', 'TH' => '764',
			'TG' => '768', 'TK' => '772', 'TO' => '776', 'TT' => '780', 'TN' => '788', 'TR' => '792', 'TM' => '795', 'TC' => '796',
			'TV' => '798', 'UG' => '800', 'UA' => '804', 'AE' => '784', 'GB' => '826', 'US' => '840', 'UY' => '858', 'UZ' => '860',
			'VU' => '548', 'VE' => '862', 'VN' => '704', 'VG' => '092', 'VI' => '850', 'WF' => '876', 'EH' => '732', 'YE' => '887',
			'ZM' => '894', 'ZW' => '716'
		);
		return $codes[$in];
	}
 	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='hsbc', `internalname`='storefrontid', `name`='Storefront ID', `options`='', `value`='', `help`='Set this to your assigned Verisign id.', `size`='15', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='hsbc', `internalname`='hashkey', `name`='Hash Key', `options`='', `value`='', `help`='Set this to your hash key.', `size`='30', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='hsbc', `internalname`='checkoutlink', `name`='Checkout Link', `options`='', `value`='https://www.cpi.hsbc.com/servlet', `help`='Transaction URL. Change from default if necessary.', `size`='60', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='hsbc', `internalname`='test_mode', `name`='Test Mode', `options`='T::P->True::False', `value`='true', `help`='Set to this value for testing mode. Set to \"False\" for LIVE.', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='hsbc', `internalname`='currency', `name`='Currency', `options`='978::344::392::826::840->Euro::Hong Kong Dollar::Japanese Yen::Pound Sterling::US Dollar', `value`='840', `help`='Set to this value for testing mode. Set to \"False\" for LIVE.', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='hsbc', `internalname`='hash', `name`='Hash Genertion', `options`='PHP::Shell->PHP (Requires Mhash & Mcrypt)::Linux Script', `value`='PHP', `help`='Hash generation method.', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='hsbc', `internalname`='pass_type', `name`='', `options`='', `value`='post', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='hsbc'");
	}
}
?>