<?PHP
/*
  include/payment/fast_charge_socket.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Fast Charge";
$ADDON_VERSION 	= "1.0";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "fast_charge";

class fast_charge {
	var $class_vars;
	
	function fast_charge ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$data = array (
			'acctid'				=> ($this->class_vars[testmode]=='True')?'TEST0':$this->class_vars[acctid],
			'subid'					=> $this->class_vars[subid],
			'merchantPIN'			=> $this->class_vars[pin],
			'action'				=> 'ns_quicksale_cc',
			
			'ci_phone'				=> $userinfo[phone],
			'ci_billaddr1'			=> $userinfo[bill_address1],
			'ci_billcity'			=> $userinfo[bill_city],
			'ci_billstate'			=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'ci_billzip'			=> $userinfo[bill_zip],
			'ci_billcountry'		=> $userinfo[bill_country],
			'ci_email'				=> $userinfo[email],
			
			'ccname'				=> $orderinfo[cc_name_on_card],
			'ccnum'					=> tempdecryptit($orderinfo[cc_card_no]),
			'cvv2'					=> $orderinfo[cc_cvv2],
			'expmon'				=> $orderinfo[cc_expir_month],
			'expyear'				=> $orderinfo[cc_expir_year],
			
			'amount'				=> p($orderinfo[total], false),
			'merchantordernumber'	=> $oid,
			'ci_ipaddress'			=> $_SERVER['REMOTE_ADDR'],
			
			'ci_shipaddr1'			=> $userinfo[ship_address1],
			'ci_shipcity'			=> $userinfo[ship_city],
			'ci_shipstate'			=> (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)),
			'ci_shipzip'			=> $userinfo[ship_zip],
			'ci_shipcountry'		=> $userinfo[ship_country],
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$results = $cconnect->connect($data_string, $header, array(), $this->class_vars[url]);
		$auth = $this->parse_return($results);
		
		$auth["addon_message"] 	= $auth["Reason"][2];
		$auth["addon_code"]		= $auth["x_response_reason_code"];
		$auth["addon_oid"] 		= $auth["orderid"];
		$auth["addon_avs"]		= $auth["Accepted"][5];
		$auth["addon_cvn"]		= $auth["Accepted"][7];
		
		if ($auth["Status"] == 'Accepted' && $auth["result"] == '1') {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$results = explode("\n", strip_tags($in));
		foreach ($results as $v) {
			$parse = explode('=', $v);
			$sub_parse = explode(':', trim($parse[1]));
			if (count($sub_parse) > 1) {
				$return[trim($parse[0])] = array();
				foreach ($sub_parse as $v2) array_push($return[trim($parse[0])], trim($v2));
			} else {
				$return[trim($parse[0])] = trim($parse[1]);
			}
		}
		return $return;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='fast_charge', `internalname`='acctid', `name`='Acct ID', `options`='', `value`='', `help`='Five character alphanumeric Account ID assigned to the merchant.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='fast_charge', `internalname`='subid', `name`='Sub Acct ID', `options`='', `value`='', `help`='Merchant Sub ID. If unsure whether you have one, leave blank.', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='fast_charge', `internalname`='pin', `name`='Merchant Pin', `options`='', `value`='', `help`='The 32 character Merchant PIN code generated from the Online Merchant Center.', `size`='20', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='fast_charge', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://trans.secure-fastcharge.com/cgi-bin/process.cgi', `help`='Transaction url. Leave default if you are unsure.', `size`='60', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='fast_charge', `internalname`='testmode', `name`='Test Mode', `options`='True::False->True::False', `value`='False', `help`='Test mode status. Set to false to go live.', `size`='0', `dorder`='5', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='fast_charge'");
	}
}
?>