<?PHP
/*
  include/payment/dibs_gateway.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "DIBS Gateway";
$ADDON_VERSION 	= "1.0";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "dibs_gateway";

class dibs_gateway {
	var $class_vars;
	
	function dibs_gateway ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$data = array (
			'merchant'						=> $this->class_vars[authuser],
			'cardno'						=> tempdecryptit($orderinfo[cc_card_no]),
			'cvc'							=> $orderinfo[cc_cvv2],
			'expmon'						=> str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT),
			'expyear'						=> $orderinfo[cc_expir_year],
			
			'amount'						=> p($orderinfo[total], false),
			'orderid'						=> $oid,
			'ip'							=> $_SERVER['REMOTE_ADDR'],
			'textreply'						=> 'yes',
			'fullreply'						=> 'yes',
			'test'							=> 'yes',
			'uniqueoid'						=> 'yes',
			'capturenow'					=> ($this->class_vars[paymode]=="AUTH_ONLY")?'no':'yes',
			'postype'						=> 'ssl',
			'account_type'					=> 'credit',
			'currency'						=> $this->currency_codes($settings[defaultrate])
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$results = $cconnect->connect($data_string, $header, array(), 'https://payment.architrade.com/cgi-ssl/auth.cgi');
		$response = $this->parse_return($results);
	
		$response["addon_message"] 	= $response[status].': '.(($response[message]!="")?$response[message]:$this->error_codes($response[reason]));
		$response["addon_code"]		= $response[reason];
		$response["addon_oid"] 		= $oid;
		$response["addon_avs"]		= 'N/A';
		$response["addon_cvn"]		= 'N/A';
		$response["addon_auth"]		= ($this->class_vars[paymode]=="AUTH_ONLY")?$response[transact]:"";
		
		if ($response[status] == "ACCEPTED") {
			$response["approved"] = "Approved";
		} else {
			$response["approved"] = "Error";
		}
		
		return $response;
	}
	
	function capture ($order) {
		global $DB_site, $dbprefix, $settings, $cconnect;
		
		$data = array (
			'merchant'			=> $this->class_vars[authuser],
			'amount'			=> p($order[total], false),
			'orderid'			=> $order[pm_orderid],
			'textreply'			=> 'yes',
			'fullreply'			=> 'yes',
			'test'				=> 'yes',
			'force'				=> 'yes'
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$results = $cconnect->connect($data_string, $header, array(), 'https://payment.architrade.com/cgi-bin/capture.cgi');
		$response = $this->parse_return($results);
		
		$response["addon_message"] 	= $response[status].': '.(($response[message]!="")?$response[message]:$this->error_codes($response[reason]));
		$response["addon_code"]		= $response[reason];
		$response["addon_oid"] 		= $oid;
		$response["addon_avs"]		= 'N/A';
		$response["addon_cvn"]		= 'N/A';
		
		if ($reponse[status] == "ACCEPTED") {
			$DB_site->query("UPDATE `".$dbprefix."orders` set `cc_status`='Payment Received' where `id`='".$order[id]."'");
			return 'Result: Transaction was approved and the payment status has been updated';
		} else {
			return 'Result: Error processing request: '.$reponse["addon_code"].' - '.$reponse["addon_message"];
		}
	}
	
	function parse_return ($in) {
		$return = array();
		$array = explode("&", str_replace("\"", "", $in));
		foreach ($array as $k => $v) {
			$split = explode("=", trim($v));
			$return[$split[0]] = $split[1];
		}
		return $return;
	}
	
	function load_actions () {
		$map_actions = array (
			'DIBS: Capture Funds' => 'capture'
		);
		return $map_actions;
	}
	
	function currency_codes  ($code) {
		$codes_array = array(
			'DKK' => '208',
			'EUR' => '978',
			'USD' => '840',
			'GBP' => '826',
			'SEK' => '752',
			'AUD' => '036',
			'CAD' => '124',
			'ISK' => '352',
			'JPY' => '392',
			'NZD' => '554',
			'NOK' => '578',
			'CHF' => '756',
			'TRY' => '949'
		);
		return $codes_array[$code];
	}
	
	function error_codes ($code) {
		$codes_array = array (
			'0'  => 'Rejected by acquirer.',
			'1'  => 'Communication problems.',
			'2'  => 'Error in the parameters sent to the DIBS server. An additional parameter called "message" is returned, with a value that may help identifying the error.',
			'3'  => 'Error at the acquirer.',
			'4'  => 'Credit card expired.',
			'5'  => 'Your shop does not support this credit card type, the credit card type could not be identified, or the credit card number was not modulus correct.',
			'6'  => 'Instant capture failed.',
			'7'  => 'The order number (orderid) is not unique.',
			'8'  => 'There number of amount parameters does not correspond to the number given in the split parameter.',
			'9'  => 'Control numbers (cvc) are missing.',
			'10' => 'The credit card does not comply with the credit card type.',
			'11' => 'Declined by DIBS Defender.'
		);
		return $codes_array[$code];
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='dibs_gateway', `internalname`='authuser', `name`='Merchant ID', `options`='', `value`='1234567', `help`='Your DIBS Merchant ID.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='dibs_gateway', `internalname`='paymode', `name`='Payment Mode', `options`='AUTH_CAPTURE::AUTH_ONLY->AUTH CAPTURE::AUTH ONLY', `value`='AUTH_CAPTURE', `help`='If you would like to authorize the card initially and then charge upon shipment change the value of \"Payment Mode\" from \"AUTH CAPTURE\" to \"AUTH ONLY\" otherwise leave it as it is. You will be able to capture the payment later on the transaction view page', `size`='0', `dorder`='2', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='dibs_gateway'");
	}
}
?>