<?PHP
/*
  include/payment/bankofamerica.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Bank Of America";
$ADDON_VERSION 	= "2.2";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "bankofamerica";

class bankofamerica {
	var $class_vars;
	
	function bankofamerica ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$data = "<?xml version=\"1.0\" standalone=\"no\"?>
		<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">
		 <SOAP-ENV:Header xmlns:hdr=\"urn:header\">
		       <hdr:verify_info>
		         <merchant_id>".$this->class_vars[bofa_merchid]."</merchant_id>
		         <user_id>".$this->class_vars[bofa_user]."</user_id>
		         <password>".$this->class_vars[bofa_pass]."</password>
		       </hdr:verify_info>
		 </SOAP-ENV:Header>
		 <SOAP-ENV:Body>
		   <auth_req > 
		   <auth_info id=\"A1\"  >
		     <order_info>
		       <order_id>".$orderinfo[invoiceid]."</order_id>
		       <shopper_id>".$sess->gvar('userid')."</shopper_id>
		       <auto_settle_flag>1</auto_settle_flag>
		       <price_amount>".$orderinfo[subtotal]."</price_amount>
		       <tax_amount>".$orderinfo[tax]."</tax_amount>
		       <freight_amount>0.00</freight_amount>
		       <handling_amount>".$orderinfo[ship_price]."</handling_amount>
		       <duty_amount>0.00</duty_amount>
		       <other_amount>0.00</other_amount>
		       <total_amount>".p($orderinfo[total], false)."</total_amount>
		     </order_info>
		     <bill_to>
		       <address>
		         <first_name>".$userinfo[bill_first_name]."</first_name>
		         <last_name>".$userinfo[bill_last_name]."</last_name>
		         <bus_name>".$userinfo[bill_company_name]."</bus_name>
		         <street_1>".$userinfo[bill_address1]."</street_1>
		         <street_2>".$userinfo[bill_address2]."</street_2>
		         <city>".$userinfo[bill_city]."</city>
		         <state>".(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2))."</state>
		         <zip>".$userinfo[bill_zip]."</zip>
		         <country>".$userinfo[bill_country]."</country>
		       </address>
		       <phone>".$userinfo[phone]."</phone>
		       <email>".$userinfo[email]."</email>
		       <same_as_flag>0</same_as_flag>
		     </bill_to>
		     <payment_info>
		        <credit_card>
		          <exp_month>".$orderinfo[cc_expir_month]."</exp_month>
		          <exp_year>".$orderinfo[cc_expir_year]."</exp_year>
		          <cardholder_name>".$orderinfo[cc_name_on_card]."</cardholder_name>
		          <card_number>".tempdecryptit($orderinfo[cc_card_no])."</card_number>
		          <cvv_flag>1</cvv_flag>
		          <cvv_value>".$orderinfo[cc_cvv2]."</cvv_value>
		        </credit_card>
		     </payment_info>
		     <ship_to>
		       <address>
		         <first_name>".$userinfo[ship_first_name]."</first_name>
		         <last_name>".$userinfo[ship_last_name]."</last_name>
		         <bus_name>".$userinfo[bill_company_name]."</bus_name>
		         <street_1>".$userinfo[ship_address1]."</street_1>
		         <street_2>".$userinfo[ship_address2]."</street_2>
		         <city>".$userinfo[ship_city]."</city>
		         <state>".(($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2))."</state>
		         <zip>".$userinfo[ship_zip]."</zip>
		         <country>".$userinfo[ship_country]."</country>
		       </address>
		       <phone>".$userinfo[phone]."</phone>
		     </ship_to>
		   </auth_info>
		   </auth_req>
		 </SOAP-ENV:Body>
		</SOAP-ENV:Envelope>";
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[bofaurl]);
		$auth	 = $this->parse_return($results);
		
		$auth["addon_message"] 	= $auth["response_desc"];
		$auth["addon_code"]		= "";
		$auth["addon_oid"] 		= $auth["order_number"];
		
		if (isset($auth[faultcode]) && $auth[faultcode] != "") {
			$auth["addon_message"] = $auth[detail];
			$auth["addon_code"] = $auth[faultcode];
			$auth["approved"] = "Error";
		}elseif ($auth["response_code"] == 0) {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$attributes = array();
		$attributes = XMLParser($in);
		
		reset($attributes);
		while (list ($key, $val) = each ($attributes)) {
			$name = $val['tag']; $value = $val['value'];
			$out[$name] = $value;
		}
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bankofamerica', `internalname`='bofa_merchid', `name`='Merchant ID', `options`='', `value`='', `help`='Your Bank of America merchant ID', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bankofamerica', `internalname`='bofa_user', `name`='Merchant Username', `options`='', `value`='', `help`='Your Bank of America username', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bankofamerica', `internalname`='bofa_pass', `name`='Merchant Password', `options`='', `value`='', `help`='Your Bank of America password', `size`='0', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bankofamerica', `internalname`='bofaurl', `name`='Transaction URL', `options`='', `value`='https://cart.bamart.com/soap/listener.mart', `help`='Bank of America transaction ID', `size`='60', `dorder`='4', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='bankofamerica'");
	}
}
?>
