<?PHP
/*
  include/methods/paypal_express_checkout.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Paypal Express Checkout";
$ADDON_VERSION 	= "1.3";
$ADDON_TYPE 	= "Pay Method";
$CLASS_NAME 	= "paypal_express_checkout";

class paypal_express_checkout {
	var $class_vars;
	var $required;
	var $remove;
	
	function paypal_express_checkout ($class_vars) {
		$this->class_vars	= $class_vars;
		$this->required		= array();
		$this->req_names	= array();
	}
	
	function render () {
		global $DB_site, $dbprefix, $orderinfo, $settings, $abs_path, $lang, $sess, $cart, $ae;
		
		if ($orderinfo[token] != "" || p($orderinfo[total]) == p(0)) {
			$sess->dvar('orderinfo'); 
			$sess->svar('orderinfo', $orderinfo);
			header('location: '.$settings[secureurl].'checkout.php?l=review');
			exit;
		}
		
		include_once $abs_path.'/include/classes/class.connect.php';
		$cconnect = new curl_connect();
		
		$this->class_vars = module_vars('paypal_pro', 'payment');
		
		$url	= ($this->class_vars[sandbox]=='true')?'https://api.sandbox.paypal.com/2.0/':'https://api-3t.paypal.com/2.0/';
		$url2	= ($this->class_vars[sandbox]=='true')?'https://www.sandbox.paypal.com/':'https://www.paypal.com/';
		
		$cart_entry = $DB_site->query_first("SELECT * FROM ".$dbprefix."users_saved_carts WHERE sessid='".$_COOKIE['cartid']."'");
		
		$userinfo	= $sess->gvar('userinfo');
		if ($userinfo[ship_other] != "") $userinfo[ship_state] = $userinfo[ship_other];
		if ($userinfo[bill_other] != "") $userinfo[bill_state] = $userinfo[bill_other];
		
		$vars = array_merge (
			$userinfo,
			$this->class_vars,
			array (
				'currency'		=> $settings[defaultrate],
				'total'			=> p($cart->subtotal(), false),
				'return_url'	=> $settings[secureurl].'checkout.php?return=paypal_express_checkout',
				'cancel_url'	=> $settings[shopurl].'index.php?l=cart_view',
				'token'			=> $paypal_token,
				'local_code' 	=> $settings[country],
				'extra'			=> $cart_entry[id],
				'overide'		=> '1'
			)
		);
		
		$xml_data	= xml_doc('include/plugins/paypal_express/paypal_express.xml', $vars);
		
		$results	= $cconnect->connect($xml_data, $header, array(), $url);
		$paypal		= $this->parse_return($results);
		
		if ($paypal['Ack'] == "Success")
			header('location: '.$url2.'webscr?cmd=_express-checkout&token='.$paypal['Token']);
		else {
			$ae->new_error($paypal['Errors']['LongMessage']);
			header('location: '.$settings[secureurl].'checkout.php?l=details');
		}
		exit;
	}
	
	function check_required () {
		return true;
	}
	
	function pre_process () { 
		global $settings, $lang;
		$lango = $lang['order'];
		
		$display = array($lango['pay_method'] => 'PayPal Express Checkout');
		foreach ($display as $k => $v) {
			$data[payment_details] .= ($v != "")?template('order_overall_review_payment_item.html', array('item' => array('name' => $k, 'value' => $v))):"";
		}
		
		$data[form_action] = $settings[secureurl].'checkout.php?l=process';
		return $data;
	}
	
	function catch_return () {
		global $DB_site, $dbprefix, $settings, $abs_path, $lang, $sess, $ae;
		
		include_once $abs_path.'/include/classes/class.connect.php';
		$cconnect = new curl_connect();
		
		$this->class_vars = module_vars('paypal_pro', 'payment');
		$url = ($this->class_vars[sandbox]=='true')?'https://api.sandbox.paypal.com/2.0/':'https://api-3t.paypal.com/2.0/';
		
		$vars = array_merge (
			$this->class_vars,
			array ('token' => $_GET['token'])
		);
		
		$xml_data	= xml_doc('include/methods/paypal_express_checkout/paypal_express.xml', $vars);
		$results	= $cconnect->connect($xml_data, $header, array(), $url);
		$paypal		= $this->parse_return($results);
		
		if ($paypal['Ack'] != "Failure") {
			$data = $paypal['GetExpressCheckoutDetailsResponseDetails'];
			
			$cart_entry = $DB_site->query_first("SELECT * FROM ".$dbprefix."users_saved_carts WHERE id='".$data['Custom']."'");
			
			if ($cart_entry[id] == "" || $data['Custom'] == "") {
				$ae->new_error('Failure retrieving your stored cart upon return from PayPal. Please try again.');
				header('location: '.$settings[secureurl].'checkout.php'); exit;
			}
			
			$cart = unserialize(base64_decode($cart_entry[cart]));
			$cart = checkcart($cart);
			$sess->svar('cart', $cart);
			
			$userinfo = array(
				'ship_first_name' 	=> $data[PayerInfo][PayerName][FirstName],
				'ship_last_name' 	=> $data[PayerInfo][PayerName][LastName],
				'ship_company_name' => $data[PayerInfo][PayerBusiness],
				'ship_address1' 	=> $data[PayerInfo][Address][Street1],
				'ship_address2' 	=> $data[PayerInfo][Address][Street2],
				'ship_city' 		=> $data[PayerInfo][Address][CityName],
				'ship_state' 		=> $data[PayerInfo][Address][StateOrProvince],
				'ship_zip' 			=> $data[PayerInfo][Address][PostalCode],
				'ship_country' 		=> $data[PayerInfo][Address][Country],
				'bill_first_name' 	=> $data[PayerInfo][PayerName][FirstName],
				'bill_last_name' 	=> $data[PayerInfo][PayerName][LastName],
				'bill_company_name' => $data[PayerInfo][PayerBusiness],
				'bill_address1' 	=> $data[PayerInfo][Address][Street1],
				'bill_address2'		=> $data[PayerInfo][Address][Street2],
				'bill_city'			=> $data[PayerInfo][Address][CityName],
				'bill_state'		=> $data[PayerInfo][Address][StateOrProvince],
				'bill_zip'			=> $data[PayerInfo][Address][PostalCode],
				'bill_country'		=> $data[PayerInfo][Address][Country],
				'email'				=> $data[PayerInfo][Payer],
				'phone'				=> $data[PayerInfo][ContactPhone],
			);
			$sess->svar('userinfo', $userinfo);
			
			$orderinfo = array (
				'pay_method'	=> 'paypal_express_checkout',
				'token'			=>  $_GET['token'],
				'payerid'		=>  $_GET['PayerID'],
				'hide_method'	=> '1'
			);
			$sess->svar('orderinfo', $orderinfo);
			
			header('location: '.$settings[secureurl].'checkout.php?l=details');
			exit;
		} else {
			$ae->new_error('Failure communicating with PayPal. Please try again.');
			header('location: '.$settings[secureurl].'checkout.php');
			exit;
		}
	}
	
	function process () {
		global $DB_site, $dbprefix, $cconnect, $settings, $abs_path, $lang, $sess, $ae;
		
		$lango = $lang['order'];
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$this->class_vars = module_vars('paypal_pro', 'payment');
		$url = ($this->class_vars[sandbox]=='true')?'https://api.sandbox.paypal.com/2.0/':'https://api-3t.paypal.com/2.0/';
		
		$vars = array_merge (
			$userinfo,
			$orderinfo,
			$this->class_vars,
			array (
				'action'	=> $this->class_vars[action],
				'currency'	=> $settings[defaultrate],
				'total'		=> p($orderinfo[total], false)
			)
		);
		
		$xml_data	= xml_doc('include/methods/paypal_express_checkout/paypal_express_complete.xml', $vars);
		$results	= $cconnect->connect($xml_data, $header, array(), $url);
		$paypal		= $this->parse_return($results);
		
		$data = $paypal['DoExpressCheckoutPaymentResponseDetails'];
		
		$append = array(
			'pm_name'		=> 'Paypal',
			'pm_orderid'	=> $data['PaymentInfo']['TransactionID'],
		);
		
		switch ($data['PaymentInfo']['PaymentStatus']) {
			case 'Completed':
			case 'Processed':
				$append2 = array('status' => 'Awaiting Shipment', 'cc_status' => 'Payment Received');
				$data[orderid]	= store_order(array_merge($append, $append2), 'Paypal Express Checkout');
				$data[result]	= $lango['order_success'];
				$data[notes]	= 'Your PayPal express checkout transaction id is: '.$data['PaymentInfo']['TransactionID'];
				break;
			case 'Pending':
				$append2 = array('status' => 'Pending', 'cc_status' => 'Payment Queued');
				$data[orderid]	= store_order(array_merge($append, $append2), 'Paypal Express Checkout');
				$data[result] 	= $lango['order_success'];
				$data[notes]	= $lango['order_pending'].'<div><div style="padding-top: 10px;">Your PayPal express checkout transaction id is: '.$data['PaymentInfo']['TransactionID'];
				break;
			default:
				$ae->new_error('<strong>'.$lango['pay_error'].'</strong>'.$paypal['Errors']['ErrorCode'].' '.$paypal['Errors']['LongMessage']);
				$data[result]	= $lango['order_error'];
				break;
		}
		
		return $data;
	}
	
	function parse_return ($in) {
		global $abs_path;
		include_once $abs_path.'/include/soap/nusoap.php';
		$parser = new soap_parser($in, 'UTF-8');
		$out = $parser->get_response();
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_express_checkout', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='If enabaled, PayPal Web Payments Pro payment module must be installed and the credentials set in that module.', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_express_checkout', `internalname`='display_name', `name`='Display Name', `moptions`='', `options`='', `value`='<img src=\"https://www.paypal.com/en_US/i/logo/PayPal_mark_37x23.gif\" alt=\"\" width=\"37\" height=\"23\" border=\"0\"> Save time. Check out securely. Pay without sharing your financial information.', `help`='', `size`='36', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_express_checkout', `internalname`='display_order', `name`='Display Order', `moptions`='', `options`='', `value`='1', `help`='', `size`='4', `dorder`='3', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_methods where `module`='paypal_express_checkout'");
	}
}

?>