<?PHP
/*
  include/class.hmac.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

class crypt_hmac {
    var $_func;
	var $_ipad;
	var $_opad;
	var $_pack;
	
	function crypt_hmac ($key, $func='md5') {
        $this->setFunction($func);
        $this->setKey($key);
    }
	
    function setFunction($func) {
        if (!$this->_pack = $this->_getPackFormat($func)) die('Unsupported hash function');
        $this->_func = $func;
    }
	
	function setKey($key) {
        $func = $this->_func;
        
        if (strlen($key) > 64) $key =  pack($this->_pack, $func($key));
        if (strlen($key) < 64) $key = str_pad($key, 64, chr(0));

        $this->_ipad = (substr($key, 0, 64) ^ str_repeat(chr(0x36), 64));
        $this->_opad = (substr($key, 0, 64) ^ str_repeat(chr(0x5C), 64));
    }
    
    function _getPackFormat($func) {
        $packs = array('md5' => 'H32', 'sha1' => 'H40');
        return isset($packs[$func]) ? $packs[$func] : false;
    }
	
    function hash($data) {
        $func = $this->_func;
        return $func($this->_opad . pack($this->_pack, $func($this->_ipad . $data)));
    }
}
?>
