<?PHP
/*
  include/shipping/fedex.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/
  
$ADDON_NAME 	= "FedEx";
$ADDON_FULLNAME	= "Federal Express";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Shipping";
$CLASS_NAME 	= "fedex";

class fedex {
	var $class_vars;
	var $xml_code;
	var $ship_date;
	
	var $shipv = array(
		"PRIORITYOVERNIGHT",
		"STANDARDOVERNIGHT",
		"FIRSTOVERNIGHT",
		"FEDEX2DAY",
		"FEDEXEXPRESSSAVER",
		"INTERNATIONALPRIORITY",
		"INTERNATIONALECONOMY",
		"INTERNATIONALFIRST",
		"FEDEX1DAYFREIGHT",
		"FEDEX3DAYFREIGHT",
		"FEDEXGROUND",
		"GROUNDHOMEDELIVERY",
		"INTERNATIONALPRIORITY FREIGHT",
		"INTERNATIONALECONOMY FREIGHT",
		"EUROPEFIRSTINTERNATIONALPRIORITY"
	);
	var $shipn = array(
		"Priority Overnight",
		"Standard Overnight",
		"First Overnight",
		"2nd Day",
		"Express Saver",
		"International Priority",
		"International Economy",
		"International First",
		"1 Day Freight",
		"3 Day Freight",
		"Ground",
		"Ground Home Delivery",
		"International Priority Freight",
		"International Economy Freight",
		"Europe First International Priority"
	);
	
	var $dropv = array("REGULARPICKUP", "REQUESTCOURIER", "DROPBOX", "BUSINESSSERVICE CENTER", "STATION");
	var $dropn = array("Regular Pickup", "Request Courier", "Dropbox", "Business Service Center", "Station");
	
	var $packv = array("FEDEXENVELOPE", "FEDEXPAK", "FEDEXBOX", "FEDEXTUBE", "FEDEX10KGBOX", "FEDEX25KGBOX", "YOURPACKAGING");
	var $packn = array("Fedex Envelope", "Fedex Pak", "Fedex Box", "Fedex Tube", "Fedex 10KG Box", "Fedex 25KG Box", "Your Packaging");
	
	function fedex ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function start () {
		$this->xml_code = '<?xml version="1.0" encoding="UTF-8" ?>
			<FDXRateAvailableServicesRequest xmlns:api="http://www.fedex.com/fsmapi" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="FDXRateRequest.xsd">
			<RequestHeader>
				<CustomerTransactionIdentifier>CTIString</CustomerTransactionIdentifier>
				<AccountNumber>'.$this->class_vars[acc_num].'</AccountNumber>
				<MeterNumber>'.$this->class_vars[meter_number].'</MeterNumber>
				<CarrierCode></CarrierCode>
			</RequestHeader>';
	}
	
	function setaddress ($from_city, $from_state, $from_zip, $from_country, $to_city, $to_state, $to_zip, $to_country) {
		$day = date("D");
		if ($day == "Sat") {
			$this->ship_date = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+2, date("Y")));
		} elseif ($day == "Sun") {
			$this->ship_date = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1, date("Y")));
		} else {
			$this->ship_date = date("Y-m-d");
		}
		$this->xml_code .= '
			<ShipDate>'.$this->ship_date.'</ShipDate>
			<DropoffType>'.$this->class_vars[pickup].'</DropoffType>
			<Packaging>'.$this->class_vars[package].'</Packaging>
			<ListRate>false</ListRate>
			<OriginAddress>
				<StateOrProvinceCode>'.$from_state.'</StateOrProvinceCode>
				<PostalCode>'.$from_zip.'</PostalCode>
				<CountryCode>'.$from_country.'</CountryCode>
			</OriginAddress>
			<DestinationAddress>
				'.(($to_country!="CA")?'<StateOrProvinceCode>'.$to_state.'</StateOrProvinceCode>':'').'
				<PostalCode>'.$to_zip.'</PostalCode>
				<CountryCode>'.$to_country.'</CountryCode>
			</DestinationAddress>';
    }
	
	function add_package($weight, $length="", $width="", $height="") {
		global $settings;
		$this->xml_code .= '
			<WeightUnits>'.(($settings[weight_units]!="")?$settings[weight_units]."S":"LBS").'</WeightUnits>
			<Weight>'.$weight.'</Weight>'.(($this->class_vars[package]=="YOURPACKAGING")?'
			<Dimensions>
				<Length>'.$length.'</Length>
				<Width>'.$width.'</Width>
				<Height>'.$height.'</Height>
				<Units>'.(($settings[dimension_units]!="")?$settings[dimension_units]:"IN").'</Units>
			</Dimensions>':'');
	}
	
	function end_all () {
		$this->xml_code .= '
			<Payment>
				<PayorType>SENDER</PayorType>
			</Payment>
			<PackageCount>1</PackageCount>
		</FDXRateAvailableServicesRequest>';
	}
	
	function process () {
		global $settings, $cconnect, $discounts, $coupon;
		$num = 0;
		
		$header_array = array(
			"POST / HTTP/1.0",
			"Content-type: application/x-www-form-urlencoded",
			"Content-length: ".strlen($this->xml_code)
		);
				
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($this->xml_code) . "\r\n\r\n";
		
		$results = $cconnect->connect($this->xml_code, $header, $header_array, $this->class_vars[url]);
		$result	= $this->parse_return($results);
		
		if ($result[FDXRateAvailableServicesReply][Error] != "") {
			$return[$num][status]		= "Failed";
			$return[$num][statuscode]	= 0;
			$return[$num][error]		= $result[FDXRateAvailableServicesReply][Error][Message];
			$return[$num][errorcode]	= $result[FDXRateAvailableServicesReply][Error][Code];
			$return[$num][rate]			= 0;
			$return[$num][method]		= 0;
		} else {
			$free = array();
			$temp = explode("::", $this->class_vars[free]);
			for ($i=0; $i<count($temp); $i++) {
				array_push($free, $temp[$i]);
			}
			
			for ($i=0; $i<count($result[FDXRateAvailableServicesReply][Entry]); $i++) {
				$name = $result[FDXRateAvailableServicesReply][Entry][$i][Service];
				$rates[$name][price] = $result[FDXRateAvailableServicesReply][Entry][$i][EstimatedCharges][DiscountedCharges][NetCharge];
			}
			
			$temp = explode("::", $this->class_vars[accepted]);
			for ($i=0; $i<count($temp); $i++) {
				$meth = $temp[$i];
				$methods[$meth] = 1;
			}
			
			for ($i=0; $i<count($this->shipv); $i++) {
				$temp = $this->shipv[$i];
				if ($methods[$temp] == 1 && $rates[$temp][price] != "") {
					$set_free = (($discounts[free_shipping]==1 || $coupon[free_shipping]==1) && in_array($temp, $free))?1:0;
					$return[$num][status]		= "OK";
					$return[$num][statuscode]	= 1;
					$return[$num][error]		= 0;
					$return[$num][errorcode]	= "";
					$return[$num][rate]			= ($set_free==1)?0:$rates[$temp][price];
					$return[$num][method]		= $this->shipn[$i];
					$num++;
				}
			}
		}
		
		return $return;
	}
	
	function parse_return ($in) {
		$rarray = parse_xml($in, array('Entry'));
		return $rarray;
	}
	
	function register () {
		global $DB_site, $dbprefix, $settings, $cconnect;
		if ($this->class_vars[meter_number] == "") {
			$this->xml_code = '<?xml version="1.0" encoding="UTF-8" ?>
			<FDXSubscriptionRequest xmlns:api="http://www.fedex.com/fsmapi" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="FDXSubscriptionRequest.xsd">
				<RequestHeader>
					<CustomerTransactionIdentifier>String</CustomerTransactionIdentifier>
					<AccountNumber>'.$this->class_vars[acc_num].'</AccountNumber>
				</RequestHeader>
				<Contact>
					<PersonName>'.$settings[companyname].'</PersonName>
					<CompanyName>'.$settings[companyname].'</CompanyName>
					<Department>Shipping</Department>
					<PhoneNumber>'.preg_replace("/[\. \(\)\-]/", "", $settings[phone]).'</PhoneNumber>
					'.(($settings[faxnumber]!="")?'<FaxNumber>'.preg_replace("/[\. \(\)\-]/", "", $settings[faxnumber]).'</FaxNumber>':'').'
					<E-MailAddress>'.$settings[contactemail].'</E-MailAddress>
				</Contact>
				<Address>
					<Line1>'.$settings[address].'</Line1>
					<City>'.$settings[city].'</City>
					<StateOrProvinceCode>'.$settings[state].'</StateOrProvinceCode>
					<PostalCode>'.$settings[zip].'</PostalCode>
					<CountryCode>'.$settings[country].'</CountryCode>
				</Address>
			</FDXSubscriptionRequest>';
			
			$header_array = array(
				"POST / HTTP/1.0",
			    "Content-type: application/x-www-form-urlencoded",
			    "Content-length: ".strlen($this->xml_code)
			);
			
			$header = "POST / HTTP/1.0\r\n".
				"Content-Type: application/x-www-form-urlencoded\r\n".
				"Content-Length: " . strlen ($this->xml_code) . "\r\n\r\n";
			
			$results = $cconnect->connect($this->xml_code, $header, $header_array, $this->class_vars[url]);
			$rarray = parse_xml($results, array('Entry'));
			
			if (!is_array($rarray)) {
				$error 	= "Connection Failed";
				$reason = "Could not connect to fedex to request a meter number. Please try again later.";
			} else {
				$error 		  = ($rarray[Error][Code]=="")?$rarray[FDXSubscriptionReply][Error][Code]:$rarray[Error][Code];
				$reason 	  = ($rarray[Error][Message]=="")?$rarray[FDXSubscriptionReply][Error][Message]:$rarray[Error][Message];
				$meter_number = $rarray[FDXSubscriptionReply][MeterNumber];
			}
			
			$result = ($error!="")?"<strong>Error:</strong> ".stripslashes($error." - ".$reason):"Successfully requested fedex meter number from federal Express.";
			$DB_site->query("UPDATE ".$dbprefix."modules_shipping set ".(($error!="")?"`value`='0' where `module`='fedex' and `internalname`='enabled'":"`value`='".addslashes($meter_number)."' where `module`='fedex' and `internalname`='meter_number'"));
		}
		return $result;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='0', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex', `internalname`='url', `name`='', `moptions`='', `options`='', `value`='https://gateway.fedex.com/GatewayDC', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex', `internalname`='acc_num', `name`='Account Number', `moptions`='', `options`='', `value`='', `help`='', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex', `internalname`='accepted', `name`='Shipping Methods', `moptions`='".implode("::", $this->shipv)."->".implode("::", $this->shipn)."', `options`='', `value`='STANDARDOVERNIGHT::FEDEX2DAY::FEDEXGROUND', `help`='', `size`='0', `dorder`='3', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex', `internalname`='free', `name`='Free Methods', `moptions`='".implode("::", $this->shipv)."->".implode("::", $this->shipn)."', `options`='', `value`='FEDEXGROUND', `help`='Please select any methods you wish to offer free when free shipping is provided using discounts or coupons.', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex', `internalname`='pickup', `name`='Drop Off Method', `moptions`='', `options`='".implode("::", $this->dropv)."->".implode("::", $this->dropn)."', `value`='BUSINESSSERVICECENTER', `help`='', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex', `internalname`='package', `name`='Typical Package', `moptions`='', `options`='".implode("::", $this->packv)."->".implode("::", $this->packn)."', `value`='YOURPACKAGING', `help`='', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex', `internalname`='meter_number', `name`='', `moptions`='', `options`='', `value`='', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='fedex', `internalname`='multi_support', `name`='', `moptions`='', `options`='', `value`='0', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_shipping where `module`='fedex'");
	}
}
?>
