<?PHP
/*
  include/plugins/plugin_cart_cross_sell.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "'View Cart' Cross Selling";
$ADDON_VERSION 	= "1.2";
$CLASS_NAME 	= "cart_cross_sell";

class cart_cross_sell {
	var $output;
	
	function cart_cross_sell ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function render () {
		global $DB_site, $dbprefix, $settings, $lang, $sess, $cart;
		
		$products = array();
		$orderids = array();
		$related = array();
		$count = 0;
		
		foreach ($cart->items as $k => $v) { if ($v->id != 'gs') { $count++; array_push($products, $v->id); } }
		
		if (!empty($products)) {
			$orders = $DB_site->query("SELECT `orderid` FROM `".$dbprefix."orders_products` where `productid` IN (".implode(",", $products).") LIMIT 100");
			while ($order = $DB_site->fetch_assoc($orders))
				if (!in_array($order[orderid], $orderids)) array_push($orderids, $order[orderid]);
		}
		
		if (!empty($orderids)) {
			$orders = $DB_site->query("SELECT DISTINCT op.`productid` FROM `".$dbprefix."orders_products` op 
				LEFT JOIN `".$dbprefix."products` p  ON op.`productid`=p.`id`  where `orderid` IN (".implode(",", $orderids).") 
				AND `productid` NOT IN (".implode(",", $products).") 
				AND p.`title`<>'' AND p.`viewable`='y'".restrict('p')." order by RAND() LIMIT ".$this->class_vars[number]
			);
			while ($order = $DB_site->fetch_assoc($orders)) 
				if (!in_array($order[productid], $related)) array_push($related, $order[productid]);
		}
		
		if (!empty($related)) {
			$format = ($this->class_vars[display] == 'default')?$settings[showitem]:$this->class_vars[display];
			foreach ($related as $v) $list[products] .= outputitem($v, $format);
			$tile[products] = close_cleanly($list);
			$cross_items = template('list_products_'.$format.'.html', array($format => ${$format}));
			if ($count == 1) $lang['plugin']['cross_sell'] = $lang['plugin']['cross_sell1'];
			else $lang['plugin']['cross_sell'] = $lang['plugin']['cross_sell2'];
			$template = template('plugin_cart_cross_sell.html', array('items' => array('list' => $cross_items), 'lang' => $lang['plugin'], 'hide' => $hide));
		} else {
			$template = '';
		}
		return $template;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='cart_cross_sell', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='cart_cross_sell', `internalname`='display', `name`='Item List Method', `moptions`='', `options`='default::list::tile->Shop Default::List Top To Bottom::Tile Right To Left', `value`='tile', `help`='Choose a display method for cross sell products.', `size`='0', `dorder`='2', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='cart_cross_sell', `internalname`='number', `name`='Product Quantity', `moptions`='', `options`='', `value`='3', `help`='Choose the number of cross sell products to display.', `size`='3', `dorder`='3', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_plugins where `module`='cart_cross_sell'");
	}
}
?>