<?PHP
/*
  include/payment/transfirst_elink.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "TransFirst eLink (Epay)";
$ADDON_VERSION 	= "1.0";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "transfirst_elink";

class transfirst_elink {
	var $class_vars;
	
	function transfirst_elink ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$data = array (
			'ePayAccountNum'				=> $this->class_vars[account],
			'password'						=> $this->class_vars[password],
			
			'CardHolderName'				=> $orderinfo[cc_name_on_card],
			'CardHolderPhone'				=> $userinfo[phone],
			'CardHolderAddress'				=> $userinfo[bill_address1],
			'CardHolderCity'				=> $userinfo[bill_city],
			'CardHolderState'				=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'CardHolderZip'					=> $userinfo[bill_zip],
			'CardHolderCountry'				=> $userinfo[bill_country],
			'CardHolderEmail'				=> $userinfo[email],
			
			'CardAccountNum'				=> tempdecryptit($orderinfo[cc_card_no]),
			'CVV2'							=> $orderinfo[cc_cvv2],
			'ExpirationDate'				=> (($orderinfo[cc_expir_month]<10)?'0':'').$orderinfo[cc_expir_month].substr($orderinfo[cc_expir_year], 2, 2),
			
			'TransactionAmount'				=> p($orderinfo[total], false),
			'CustomerNum'					=> $sess->gvar('userid'),
			'OrderNum'						=> $oid,
			
			'TestTransaction'				=> $this->class_vars[testmode],
			'Ecommerce'						=> '1',
			'transactionCode'				=> '32',
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data_string)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data_string) . "\r\n\r\n";
		
		$results = $cconnect->connect($data_string, $header, $header_array, $this->class_vars[url]);
		$authnet = $this->parse_return($results);
		
		$auth["addon_message"] 	= $this->response_words($authnet["ext_trans_status"]);
		$auth["addon_code"]		= $authnet["ext_trans_status"];
		$auth["addon_oid"] 		= $authnet["ref_num"];
		
		if ($auth["trans_status"] == '00' || $auth["trans_status"] == '11') {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$auth_array = explode("|", $in);
		$out = array(
			"message_format"			=> "$auth_array[0]",
			"account_num"				=> "$auth_array[1]",
			"trans_code"				=> "$auth_array[2]",
			"seq_num"					=> "$auth_array[3]",
			"mo_ident"					=> "$auth_array[4]",
			"cc_num"					=> "$auth_array[5]",
			"exp_date"					=> "$auth_array[6]",
			"auth_amount"				=> "$auth_array[7]",
			"auth_date"					=> "$auth_array[8]",
			"auth_time"					=> "$auth_array[9]",
			"trans_status"				=> "$auth_array[10]",
			"cust_num"					=> "$auth_array[11]",
			"order_num"					=> "$auth_array[12]",
			"ref_num"					=> "$auth_array[13]",
			"auth_resp_code"			=> "$auth_array[14]",
			"auth_source"				=> "$auth_array[15]",
			"auth_char_ind"				=> "$auth_array[16]",
			"tran_id"					=> "$auth_array[17]",
			"valid_id"					=> "$auth_array[18]",
			"cat_code"					=> "$auth_array[19]",
			"country_code"				=> "$auth_array[20]",
			"avs_resp"					=> "$auth_array[21]",
			"merch_store_num"			=> "$auth_array[22]",
			"cvv2_resp"					=> "$auth_array[23]",
			"cavv_code"					=> "$auth_array[24]",
			"cross_ref_num"				=> "$auth_array[25]",
			"ext_trans_status"			=> "$auth_array[26]",
			"cavv_resp"					=> "$auth_array[27]",
			"xid"						=> "$auth_array[28]",
			"eci_val"					=> "$auth_array[29]"
		);
		return $out;
	}
	
	function response_words ($code) {
		$return = array (
			'203' => 'Invalid-merchant-number',
			'212' => 'Invalid-transaction-type',
			'213' => 'Invalid-amount-field',
			'214' => 'Invalid-card-number',
			'254' => 'Expired-card',
			'257' => 'Txn-not-allowed',
			'276' => 'Unable to locate previous msg (Ref # Not Found)',
			'278' => 'No-account',
			'284' => 'General Decline',
			'296' => 'System-malfunction',
			'2Q1' => 'Card Authorization Failed',
			'300' => 'Invalid Request Format',
			'301' => 'Missing file header',
			'303' => 'Invalid sender ID',
			'306' => 'Duplicate file number',
			'307' => 'General Decline',
			'309' => 'Comm link down',
			'310' => 'Missing Batch Header',
			'317' => 'Invalid MOTO ID',
			'338' => 'General Decline',
			'380' => 'Missing Batch Trailer',
			'382' => 'Record count doesn\'t match number records in batch',
			'383' => 'Net amount doesn\'t match batch amount',
			'384' => 'Duplicate transaction',
			'385' => 'Invalid request format',
			'394' => 'record count does not match number records in file',
			'395' => 'Net amount doesn\'t match file amount',
			'396' => 'Declined Post  Reauthorization Attempt (Hard Decline)',
			'317' => 'Invalid MOTO ID (not = space, 1,2, or 4)',
			'318' => 'Invalid account data source (not = 0,1,2,3,4,5,9,D,H,T,X,M)',
			'319' => 'Invalid POS entry mode (not = spaces, 00,01,02,03,04,05,59,06,90)',
			'320' => 'Auth date invalid (transaction date)',
			'321' => 'Invalid auth source code ( not = 1,2,3,4,5,0)',
			'322' => 'Invalid ACI code ( not = A,C,E,F,I,K.M.N.P,R,S,U,V,W,Y)',
			'REJ' => 'Rejected transaction that has been re-keyed.',
			'3AC' => 'Invalid authorization code- (must be upper case AN, no special characters.)',
			'3TI' => 'Invalid tax indicator',
			'3VD' => 'Voided transaction (only seen on Secure reporting.)',
			'3AD' => 'AVS Response Code Declined',
			'3AR' => 'AVS Required / Address Information Not Provided',
			'3BD' => 'AVS and CVV2 Response Code Declined',
			'3BR' => 'AVS and CVV2 Required / Information Not Provided',
			'3CD' => 'CVV2 Response Code Declined',
			'3CR' => 'CVV2 Required / Information Not Provided',
			'3L5' => 'No Data Sent',
			'3L6' => 'Order Number Missing',
			'3M1' => 'Auth Date  Blank',
			'3M2' => 'Auth Amount  Blank',
			'3MT' => 'Managed Transaction',
			'3RV' => 'Reversed Transaction',
			'3TO' => 'Time Out',
			'600' => 'General Decline',
			'990' => 'Voided',
			'991' => 'Voided',
			'992' => 'Voided',
			'993' => 'Voided',
			'994' => 'Voided',
			'995' => 'Voided',
			'996' => 'Voided',
			'997' => 'Voided',
			'998' => 'Voided',
			'999' => 'Voided',
			'XXX' => 'General Decline'
		);
		return $return[$code];
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='transfirst_elink', `internalname`='account', `name`='ePay Account Number', `options`='', `value`='', `help`='Your assigned ePay Account number.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='transfirst_elink', `internalname`='password', `name`='Password', `options`='', `value`='', `help`='Your password.', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='transfirst_elink', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://epaysecure1.transfirst.com/elink/authpd.asp', `help`='Transaction url. Leave default if you are unsure.', `size`='60', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='transfirst_elink', `internalname`='testmode', `name`='Test Mode', `options`='Y::N->True::False', `value`='Y', `help`='Test mode status. Set to false to go live.', `size`='0', `dorder`='4', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='transfirst_elink'");
	}
}
?>