<?PHP
/*
  include/payment/protx_vps_direct.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Protx VSP Direct";
$ADDON_VERSION 	= "2.5";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "protx_vps_direct";

class protx_vps_direct {
	var $class_vars;
	
	function protx_vps_direct ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		/**** Login Information ****/
		$data = "Vendor=".$this->class_vars[vendor]."&";
		$data .= "VendorTxCode=".$oid."&";
		
		/**** Credit Card Information ****/ 
		$data .= "BillingAddress=".urlencode($userinfo[bill_address1])."&";
		$data .= "BillingPostCode=".urlencode($userinfo[bill_zip])."&";
		$data .= "CustomerName=".urlencode($orderinfo[cc_name_on_card])."&";
		$data .= "CustomerEmail=".urlencode($userinfo[email])."&";
		$data .= "ClientIPAddress=".urlencode($_SERVER['REMOTE_ADDR'])."&";
		$data .= "CardHolder=".urlencode($orderinfo[cc_name_on_card])."&";
		$data .= "CardNumber=".tempdecryptit($orderinfo[cc_card_no])."&";
		$data .= "CV2=".$orderinfo[cc_cvv2]."&";
		$data .= "CardType=".
			(($orderinfo[cc_card_type]=="Visa")?"VISA":"").
			(($orderinfo[cc_card_type]=="Mastercard")?"MC":"").
			(($orderinfo[cc_card_type]=="Switch")?"SWITCH":"").
			(($orderinfo[cc_card_type]=="American Express")?"AMEX":"").
			(($orderinfo[cc_card_type]=="Solo")?"SOLO":"").
			(($orderinfo[cc_card_type]=="Carte Blanche")?"DELTA":"")."&";
		$data .= "StartDate=".str_pad($orderinfo[cc_start_month], 2, "0", STR_PAD_LEFT).substr($orderinfo[cc_start_year], -2, 2)."&";
		$data .= "ExpiryDate=".str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT).substr($orderinfo[cc_expir_year], -2, 2)."&";
		$data .= "IssueNumber=".$orderinfo[cc_issue]."&";
		
		/**** Order Information ****/
		$data .= "Amount=".p($orderinfo[total], false)."&";
		$data .= "Currency=".$settings[defaultrate]."&";
		$data .= "Description=".$settings[title]."%20Order%20Payment&";
		$data .= "VPSProtocol=2.22&";
		$data .= "TxType=PAYMENT";
		
		$results = $cconnect->connect($data, $header, array(), $this->class_vars[url]);
		$authz = $this->parse_return($results);
		
		$auth["addon_message"] 	= $authz["StatusDetail"];
		$auth["addon_code"]		= "";
		$auth["addon_oid"] 		= $authz["VPSTxId"];
		$auth["addon_avs"]		= $authz["AddressResult"];
		$auth["addon_cvn"]		= $authz["CV2Result"];
		
		if ($authz["Status"] == "OK") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$response = split(chr(10), $in);
		for ($i=0; $i<count($response); $i++) {
			$splitAt = strpos($response[$i], "=");
			$output[trim(substr($response[$i], 0, $splitAt))] = trim(substr($response[$i], ($splitAt+1)));
		}
		return $output;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='protx_vps_direct', `internalname`='vendor', `name`='Vendor Login Name', `options`='', `value`='', `help`='', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='protx_vps_direct', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://ukvps.protx.com/vspgateway/service/vspform-register.vsp ', `help`='', `size`='60', `dorder`='2', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='protx_vps_direct'");
	}
}
?>