<?PHP
/*
  include/payment/payflow_pro.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "PayPal Payflow Pro XMLPay";
$ADDON_VERSION 	= "1.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "payflow_pro";

class payflow_pro {
	var $class_vars;
	
	function payflow_pro ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $DB_site, $dbprefix, $cconnect, $settings, $sess;
		
		$url = ($this->class_vars[intTestMode]==1)?'https://pilot-payflowpro.paypal.com':'https://payflowpro.paypal.com';
		$orderinfo	= $sess->gvar('orderinfo');
		
		$vars = array_merge (
			$sess->gvar('userinfo'),
			$sess->gvar('orderinfo'),
			$this->class_vars,
			array (
				'total' 	 => p($orderinfo[total], false),
				'cc_card_no' => tempdecryptit($orderinfo[cc_card_no]),
				'cc_expir'	 => $orderinfo[cc_expir_year].str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT),
				'ip'	 	 => $_SERVER['REMOTE_ADDR']
			)
		);
		
		$request_id = md5(uniqid(rand(), true));
		
		$header_array = array(
			"Content-Type: text/xml",
			"X-VPS-Timeout: 30",
			"X-VPS-VIT-Client-Type: PHP/cURL",
			"X-VPS-VIT-Integration-Product: SunShop Shopping Cart",
			"X-VPS-VIT-Integration-Version: ".$settings[version],
			"X-VPS-Request-ID: ".$request_id,
			"X-VPS-VIT-CLIENT-CERTIFICATION-ID: 598e7cf10670c8e4971bc9ce94b5eb43"
		);
		
		$header = 
			"Content-Type: text/xml\r\n".
			"X-VPS-Timeout: 30\r\n".
			"X-VPS-VIT-Client-Type: PHP/cURL\r\n".
			"X-VPS-VIT-Integration-Product: SunShop Shopping Cart\r\n".
			"X-VPS-VIT-Integration-Version: ".$settings[version]."\r\n".
			"X-VPS-Request-ID: ".$request_id."\r\n".
			"X-VPS-VIT-CLIENT-CERTIFICATION-ID: 598e7cf10670c8e4971bc9ce94b5eb43\r\n\r\n";
		
		$xml_data	= xml_doc('include/payment/payflow_pro/payflow_pro.xml', $vars);
		$results	= $cconnect->connect('<?xml version="1.0" encoding="UTF-8"?>'.$xml_data, $header, $header_array, $url);
		$payflow	= $this->parse_return($results);
		
		$auth["addon_message"] 	= $payflow[Message];
		$auth["addon_code"]		= $payflow[Result];
		$auth["addon_oid"] 		= $payflow[PNRef];
		$auth["addon_avs"] 		= $payflow[AVSResult][StreetMatch].', '.$payflow[AVSResult][ZipMatch];
		$auth["addon_cvn"] 		= $payflow[CVResult];
		
		if ($payflow[Result] == '0' && $payflow[PNRef] != "") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
	    $return =  parse_xml($in);
		return $return[XMLPayResponse][ResponseData][TransactionResults][TransactionResult];
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='payflow_pro', `internalname`='strVendor', `name`='Merchant ID', `options`='', `value`='', `help`='Your assigned merchant login ID.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='payflow_pro', `internalname`='strLogin', `name`='Login', `options`='', `value`='', `help`='Your created user id or set the same as your merchant id.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='payflow_pro', `internalname`='strPassword', `name`='Password', `options`='', `value`='', `help`='Your merchant/user password.', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='payflow_pro', `internalname`='strPartner', `name`='Partner', `options`='', `value`='PayPal', `help`='Your assigned merchant partner.', `size`='0', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='payflow_pro', `internalname`='intTestMode', `name`='Test Mode', `options`='1::0->On::Off', `value`='1', `help`='Test mode settings.', `size`='0', `dorder`='4', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='payflow_pro'");
	}
}
?>
