<?PHP
/*
  include/payment/linkpoint_api.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Linkpoint API";
$ADDON_VERSION 	= "2.3";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "linkpoint_api";

class linkpoint_api {
	var $class_vars;
	
	function linkpoint_api ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $abs_path, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		include $abs_path.'/include/payment/linkpoint_api/lpphp.php';
		$mylpphp = new lphp;
		
		$myorder["host"] 			= "secure.linkpt.net";
		$myorder["port"] 			= "1129";
		$myorder["configfile"] 		= $this->class_vars[storename];
		$myorder["keyfile"] 		= $abs_path.'/include/payment/linkpoint_api/'.$this->class_vars[keyfile];
		$myorder["result"] 			= $this->class_vars[mode];
		$myorder["debugging"] 		= $this->class_vars[debugging];
		
		$myorder["email"] 			= $userinfo[email];
		$myorder["phone"] 			= $userinfo[phone];
		$myorder["name"] 			= $orderinfo[cc_name_on_card];
		$myorder["address1"] 		= $userinfo[bill_address1];
		$myorder["address2"] 		= $userinfo[bill_address2];
		$myorder["city"] 			= $userinfo[bill_city];
		$myorder["state"] 			= (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2));
		$myorder["zip"] 			= $userinfo[bill_zip];
		$myorder["country"] 		= $userinfo[bill_country];
		$myorder["sname"] 			= $userinfo[ship_first_name].' '.$userinfo[ship_last_name];
		$myorder["saddress1"] 		= $userinfo[ship_address1];
		$myorder["saddress2"] 		= $userinfo[ship_address2];
		$myorder["scity"] 			= $userinfo[ship_city];
		$myorder["sstate"] 			= (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2));
		$myorder["szip"] 			= $userinfo[ship_zip];
		$myorder["scountry"] 		= $userinfo[ship_country];
		$myorder["ip"] 				= $_SERVER['REMOTE_ADDR'];
		
		$myorder["oid"] 			= "";
		$myorder["otype"] 			= "SALE";
		$myorder["subtotal"] 		= p(($orderinfo[subtotal]-$orderinfo[discount]-$orderinfo[coupon_savings]), false);
		$myorder["tax"] 			= p($orderinfo[tax], false);
		$myorder["shipping"] 		= p($orderinfo[ship_price], false);
		$myorder["chargetotal"] 	= p($orderinfo[total], false);
		
		$myorder["cvmvalue"] 		= $orderinfo[cc_cvv2];
		$myorder["cvmindicator"] 	= "provided";
		$myorder["cardnumber"] 		= tempdecryptit($orderinfo[cc_card_no]);
		$myorder["cardexpmonth"] 	= $orderinfo[cc_expir_month];
		$myorder["cardexpyear"] 	= substr($orderinfo[cc_expir_year], 2, 2);
		
		if ($settings[curltype] != "compiled") {
			$myorder["cbin"]  = "true";
			$myorder["cpath"] = $settings[pathtocurl];
		}
		
		$linkpt = $mylpphp->curl_process($myorder);
		
		$return["addon_message"] 	= $linkpt["r_error"];
		$return["addon_code"]		= $linkpt["r_approved"];
		$return["addon_oid"] 		= $linkpt["r_ordernum"];
		
		if ($linkpt["r_approved"] != "APPROVED") {
		    $return["approved"] = "Error";
		} else {
		    $return["approved"] = "Approved";
		}
		
		return $return;
	}
	
	function parse_return ($in) {
		return;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='linkpoint_api', `internalname`='storename', `name`='Store Name', `options`='', `value`='', `help`='Your assigned linkpoint API store name/id.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='linkpoint_api', `internalname`='keyfile', `name`='Key File', `options`='', `value`='123456.pem', `help`='Name of your key file. Place key in the linkpoint_api directory.', `size`='30', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='linkpoint_api', `internalname`='mode', `name`='Transaction Mode', `options`='LIVE::GOOD->LIVE::TEST', `value`='GOOD', `help`='Set live or test mode.', `size`='0', `dorder`='3', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='linkpoint_api', `internalname`='debugging', `name`='Debugging Mode', `options`='true::false->On::Off', `value`='false', `help`='Set debugging on or off.', `size`='0', `dorder`='4', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='linkpoint_api'");
	}
}
?>