<?PHP
/*
  include/payment/firstpay_net.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "FirstPay / GoEMerchant (Authorize.net EMU)";
$ADDON_VERSION 	= "1.0";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "firstpay_net";

class firstpay_net {
	var $class_vars;
	
	function firstpay_net ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$data = array (
			'x_login'						=> $this->class_vars[authuser],
			'x_tran_key'					=> $this->class_vars[authkey],
			'x_password'					=> $this->class_vars[authpass],
			
			'x_first_name'					=> $userinfo[bill_first_name],
			'x_last_name'					=> $userinfo[bill_last_name],
			'x_phone'						=> $userinfo[phone],
			'x_fax'							=> 'N/A',
			'x_address'						=> $userinfo[bill_address1],
			'x_city'						=> $userinfo[bill_city],
			'x_state'						=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'x_zip'							=> $userinfo[bill_zip],
			'x_country'						=> $userinfo[bill_country],
			'x_company'						=> $userinfo[bill_company_name],
			'x_email'						=> $userinfo[email],
			
			'x_card_num'					=> tempdecryptit($orderinfo[cc_card_no]),
			'x_card_code'					=> $orderinfo[cc_cvv2],
			'x_exp_date'					=> str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT).substr($orderinfo[cc_expir_year], -2, 2),
			
			'x_amount'						=> p($orderinfo[total], false),
			'x_cust_id'						=> $sess->gvar('userid'),
			'x_invoice_num'					=> $oid,
			'x_description'					=> $settings[title]."%20Order%20Payment",
			'x_trans_id'					=> $oid,
			'x_customer_IP'					=> $_SERVER['REMOTE_ADDR'],
			
			'x_ship_to_company'				=> $userinfo[ship_company_name],
			'x_ship_to_first_name'			=> $userinfo[ship_first_name],
			'x_ship_to_last_name'			=> $userinfo[ship_last_name],
			'x_ship_to_address'				=> $userinfo[ship_address1],
			'x_ship_to_city'				=> $userinfo[ship_city],
			'x_ship_to_state'				=> (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)),
			'x_ship_to_zip'					=> $userinfo[ship_zip],
			'x_ship_to_country'				=> $userinfo[ship_country],
			
			'x_delim_data'					=> 'true',
			'x_delim_char'					=> ',',
			'x_relay_response'				=> 'false',
			'x_version'						=> '1.0',
			'x_method'						=> 'CC',
			'x_type'						=> $this->class_vars[paymode],
			'x_email_customer'				=> 'true',
			'x_test_request'				=> $this->class_vars[testmode],
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$results = $cconnect->connect($data_string, $header, array(), $this->class_vars[authurl]);
		$authnet = $this->parse_return($results);
		
		$authnet["addon_message"] 	= $authnet["x_response_reason_text"];
		$authnet["addon_code"]		= $authnet["x_response_reason_code"];
		$authnet["addon_oid"] 		= $authnet["x_trans_id"];
		$authnet["addon_avs"]		= $authnet["x_avs_code"];
		$authnet["addon_cvn"]		= $authnet["x_cvv2_resp_code"];
		$authnet["addon_auth"]		= ($this->class_vars[paymode]=="AUTH_ONLY")?$authnet["x_auth_code"]:"";
		
		if ($authnet["x_response_code"] == 1) {
			$authnet["approved"] = "Approved";
		} else {
			$authnet["approved"] = "Error";
		}
		
		return $authnet;
	}
	
	function parse_return ($in) {
		$authnet_array = explode(",", str_replace("\"", "", $in));
		$out = array(
			"x_response_code"			=> "$authnet_array[0]",
			"x_response_subcode"		=> "$authnet_array[1]",
			"x_response_reason_code"	=> "$authnet_array[2]",
			"x_response_reason_text"	=> "$authnet_array[3]",
			"x_auth_code"				=> "$authnet_array[4]",
			"x_avs_code"				=> "$authnet_array[5]",
			"x_trans_id"				=> "$authnet_array[6]",
			"x_invoice_num"				=> "$authnet_array[7]",
			"x_description"				=> "$authnet_array[8]",
			"x_amount"					=> "$authnet_array[9]",
			"x_method"					=> "$authnet_array[10]",
			"x_type"					=> "$authnet_array[11]",
			"x_cust_id"					=> "$authnet_array[12]",
			"x_first_name"				=> "$authnet_array[13]",
			"x_last_name"				=> "$authnet_array[14]",
			"x_company"					=> "$authnet_array[15]",
			"x_address"					=> "$authnet_array[16]",
			"x_city"					=> "$authnet_array[17]",
			"x_state"					=> "$authnet_array[18]",
			"x_zip"						=> "$authnet_array[19]",
			"x_country"					=> "$authnet_array[20]",
			"x_phone"					=> "$authnet_array[21]",
			"x_fax"						=> "$authnet_array[22]",
			"x_email"					=> "$authnet_array[23]",
			"x_ship_to_first_name"		=> "$authnet_array[24]",
			"x_ship_to_last_name"		=> "$authnet_array[25]",
			"x_ship_to_company"			=> "$authnet_array[26]",
			"x_ship_to_address"			=> "$authnet_array[27]",
			"x_ship_to_city"			=> "$authnet_array[28]",
			"x_ship_to_state"			=> "$authnet_array[29]",
			"x_ship_to_zip"				=> "$authnet_array[30]",
			"x_ship_to_country"			=> "$authnet_array[31]",
			"x_tax"						=> "$authnet_array[32]",
			"x_duty"					=> "$authnet_array[33]",
			"x_freight"					=> "$authnet_array[34]",
			"x_tax_exempt"				=> "$authnet_array[35]",
			"x_po_num"					=> "$authnet_array[36]",
			"x_md5_hash"				=> "$authnet_array[37]",
			"x_cvv2_resp_code"			=> "$authnet_array[38]"
		);
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='firstpay_net', `internalname`='authuser', `name`='Username', `options`='', `value`='', `help`='Your Firstpay username.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='firstpay_net', `internalname`='authpass', `name`='Password', `options`='', `value`='', `help`='Your Firstpay password or leave blank and set the transaction key below.', `size`='20', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='firstpay_net', `internalname`='authkey', `name`='Transaction Key', `options`='', `value`='', `help`='Your Firstpay transaction key.', `size`='20', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='firstpay_net', `internalname`='authurl', `name`='Transaction URL', `options`='', `value`='https://secure.goemerchant.com/secure/gateway/aegateway.aspx', `help`='Authorize.net transaction url. Leave default if you are unsure.', `size`='60', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='firstpay_net', `internalname`='testmode', `name`='Test Mode', `options`='True::False->True::False', `value`='', `help`='Authorize.net test mode status. Set to false to go live.', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='firstpay_net', `internalname`='paymode', `name`='Payment Mode', `options`='sale->AUTH CAPTURE', `value`='AUTH_CAPTURE', `help`='If you would like to authorize the card initially and then charge upon shipment change the value of \"Payment Mode\" from \"AUTH CAPTURE\" to \"AUTH ONLY\" otherwise leave it as it is. You will be able to capture the payment later on the transaction view page', `size`='0', `dorder`='5', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='firstpay_net'");
	}
}
?>