<?PHP
/*
  include/payment/cybersource_soap.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Cybersource (SOAP API)";
$ADDON_VERSION 	= "1.0";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "cybersource_soap";

class cybersource_soap {
	var $class_vars;
	
	function cybersource_soap ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess, $settings;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$data = '<?xml version="1.0" encoding="UTF-8"?>
		<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ns1="urn:schemas-cybersource-com:transaction-data-1.26">
		  <SOAP-ENV:Header xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
		    <wsse:Security SOAP-ENV:mustUnderstand="1">
		      <wsse:UsernameToken>
		        <wsse:Username>'.$this->class_vars[merchid].'</wsse:Username>
		        <wsse:Password Type="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText">'.$this->class_vars[password].'</wsse:Password>
		      </wsse:UsernameToken>
		    </wsse:Security>
		  </SOAP-ENV:Header>
		  <SOAP-ENV:Body>
		    <ns1:requestMessage>
		      <ns1:merchantID>'.$this->class_vars[merchid].'</ns1:merchantID>
		      <ns1:merchantReferenceCode>'.$oid.'</ns1:merchantReferenceCode>
		      <ns1:billTo>
			  	<ns1:firstName>'.$userinfo[bill_first_name].'</ns1:firstName>
		        <ns1:lastName>'.$userinfo[bill_last_name].'</ns1:lastName>
				<ns1:street1>'.$userinfo[bill_address1].'</ns1:street1>
				<ns1:street2>'.$userinfo[bill_address2].'</ns1:street2>
		        <ns1:city>'.$userinfo[bill_city].'</ns1:city>
		        <ns1:state>'.(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)).'</ns1:state>
				<ns1:postalCode>'.$userinfo[bill_zip].'</ns1:postalCode>
		        <ns1:country>'.$userinfo[bill_country].'</ns1:country>
		        <ns1:phoneNumber>'.$userinfo[phone].'</ns1:phoneNumber>
				<ns1:email>'.$userinfo[email].'</ns1:email>
				<ns1:ipAddress>'.$_SERVER['REMOTE_ADDR'].'</ns1:ipAddress>
				<ns1:customerID>'.$sess->gvar('userid').'</ns1:customerID>
		      </ns1:billTo>
		      <ns1:purchaseTotals>
		        <ns1:currency>'.$settings[defaultrate].'</ns1:currency>
		        <ns1:grandTotalAmount>'.p($orderinfo[total], false).'</ns1:grandTotalAmount>
		      </ns1:purchaseTotals>
		      <ns1:card>
		        <ns1:accountNumber>'.tempdecryptit($orderinfo[cc_card_no]).'</ns1:accountNumber>
		        <ns1:expirationMonth>'.$orderinfo[cc_expir_month].'</ns1:expirationMonth>
		        <ns1:expirationYear>'.$orderinfo[cc_expir_year].'</ns1:expirationYear>
				<ns1:cvNumber>'.$orderinfo[cc_cvv2].'</ns1:cvNumber>
		      </ns1:card>
		      <ns1:ccAuthService run="true"/>
			  <ns1:ccCaptureService run="true"/>
		    </ns1:requestMessage>
		  </SOAP-ENV:Body>
		</SOAP-ENV:Envelope>';
		
		$results = $cconnect->connect($data, $header, array(), $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		$auth["addon_message"] 	= $this->resp_code($auth["reasonCode"]);
		$auth["addon_code"]		= $auth["reasonCode"];
		$auth["addon_oid"] 		= $auth["merchantReferenceCode"];
		$auth["addon_avs"]		= $auth["ccAuthReply"]["avsCode"];
		$auth["addon_cvn"]		= $auth["ccAuthReply"]["cvCode"];
		
		if ($auth["decision"] == "ACCEPT" && $auth["reasonCode"] == "100") {
			$auth["approved"] = "Approved";
		} elseif ($auth["decision"] == "REJECT" && $auth["reasonCode"] == "520") {
			$auth["approved"] = "Review";
			$auth["a_notes"] = $auth["addon_message"].' To charge this order you will need to review the order in the CyberSource control panel and choose \'Re-Authorize and Settle\' in the available actions.';
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		global $abs_path;
		include_once $abs_path.'/include/soap/nusoap.php';
		$parser = new soap_parser($in, 'UTF-8');
		$out = $parser->get_response();
		return $out;
	}
	
	function resp_code($code) {
		$response_text = array(
			'100' => 'Successful transaction.',
			'101' => 'The request is missing one or more required fields.',
			'102' => 'One or more fields in the request contains invalid data.',
			'104' => 'The merchantReferenceCode sent with this authorization request matches the merchantReferenceCode of another authorization request that you sent in the last 15 minutes.',
			'150' => 'Error=> General system failure. ',
			'151' => 'Error=> The request was received but there was a server timeout. This error does not include timeouts between the client and the server.',
			'152' => 'Error=> The request was received, but a service did not finish running in time.',
			'201' => 'The issuing bank has questions about the request. You do not receive an authorization code in the reply message, but you might receive one verbally by calling the processor.',
			'202' => 'Expired card. You might also receive this if the expiration date you provided does not match the date the issuing bank has on file.',
			'203' => 'General decline of the card. No other information provided by the issuing bank.',
			'204' => 'Insufficient funds in the account.',
			'205' => 'Stolen or lost card.',
			'207' => 'Issuing bank unavailable.',
			'208' => 'Inactive card or card not authorized for card-not-present transactions.',
			'210' => 'The card has reached the credit limit. ',
			'211' => 'Invalid card verification number.',
			'221' => 'The customer matched an entry on the processor\'s negative file.',
			'231' => 'Invalid account number.',
			'232' => 'The card type is not accepted by the payment processor.',
			'233' => 'General decline by the processor.',
			'234' => 'There is a problem with your CyberSource merchant configuration.',
			'235' => 'The requested amount exceeds the originally authorized amount. Occurs, for example, if you try to capture an amount larger than the original authorization amount. This reason code only applies if you are processing a capture through the API.',
			'236' => 'Processor Failure',
			'238' => 'The authorization has already been captured. This reason code only applies if you are processing a capture through the API.',
			'239' => 'The requested transaction amount must match the previous transaction amount. This reason code only applies if you are processing a capture or credit through the API.',
			'240' => 'The card type sent is invalid or does not correlate with the credit card number.',
			'241' => 'The request ID is invalid. This reason code only applies when you are processing a capture or credit through the API.',
			'242' => 'You requested a capture through the API, but there is no corresponding, unused authorization record. Occurs if there was not a previously successful authorization request or if the previously successful authorization has already been used by another capture request. This reason code only applies when you are processing a capture through the API.',
			'243' => 'The transaction has already been settled or reversed.',
			'246' => 'The capture or credit is not voidable because the capture or credit information has already been submitted to your processor. Or, you requested a void for a type of transaction that cannot be voided. This reason code applies only if you are processing a void through the API.',
			'247' => 'You requested a credit for a capture that was previously voided. This reason code applies only if you are processing a void through the API.',
			'250' => 'Error=> The request was received, but there was a timeout at the payment processor.',
			'520' => 'The authorization request was approved by the issuing bank but declined by CyberSource based on your Smart Authorization settings.'
		);
		return $response_text[$code];
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='cybersource_soap', `internalname`='merchid', `name`='Merchant ID', `options`='', `value`='', `help`='Cybersource merchant ID', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='cybersource_soap', `internalname`='password', `name`='Transaction Key', `options`='', `value`='', `help`='Cybersource transaction key.', `size`='70', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='cybersource_soap', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://ics2ws.ic3.com/commerce/1.x/transactionProcessor/CyberSourceTransaction_1.26.wsdl', `help`='Cybersource transaction url', `size`='70', `dorder`='3', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='cybersource_soap'");
	}
}
?>
