<?PHP
/*
  include/payment/cybersource_api.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Cybersource (SO API)";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "cybersource_api";

class cybersource_api {
	var $class_vars;
	
	function cybersource_api ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess, $settings, $abs_path;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		$data = '
			<requestMessage xmlns="urn:schemas-cybersource-com:transaction-data-'.$this->class_vars[targetAPIVersion].'">
			   <merchantID>'.$this->class_vars[merchantID].'</merchantID>
			   <merchantReferenceCode>'.$oid.'</merchantReferenceCode>
			   <billTo>
			      <firstName>'.$userinfo[bill_first_name].'</firstName>
			      <lastName>'.$userinfo[bill_last_name].'</lastName>
			      <street1>'.$userinfo[bill_address1].'</street1>
			      <city>'.$userinfo[bill_city].'</city>
			      <state>'.(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)).'</state>
			      <postalCode>'.$userinfo[bill_zip].'</postalCode>
			      <country>'.$userinfo[bill_country].'</country>
			      <phoneNumber>'.$userinfo[phone].'</phoneNumber>
			      <email>'.$userinfo[email].'</email>
			   </billTo>
			   <item id="0">
			     <unitPrice>'.p($orderinfo[total], false).'</unitPrice>
			   </item>
			   <purchaseTotals>
			      <currency>'.$settings[defaultrate].'</currency>
			   </purchaseTotals>
			   <card>
			      <accountNumber>'.tempdecryptit($orderinfo[cc_card_no]).'</accountNumber>
			      <expirationMonth>'.$orderinfo[cc_expir_month].'</expirationMonth>
			      <expirationYear>'.$orderinfo[cc_expir_year].'</expirationYear>
				  <cvNumber>'.$orderinfo[cc_cvv2].'</cvNumber>
			   </card>
			   <ccAuthService run="true"/>
			   <ccCaptureService run="true"/>
			</requestMessage>';
		
		$request[CYBS_SK_XML_DOCUMENT] 		= $data;
		$config[CYBS_C_TARGET_API_VERSION] 	= $this->class_vars[targetAPIVersion];
		$config[CYBS_C_KEYS_DIRECTORY]     	= $abs_path.'/include/payment/cybersource_api/keys/';
		$config[CYBS_C_MERCHAND_ID]        	= $this->class_vars[merchantID];
		$config[CYBS_C_SEND_TO_PRODUCTION] 	= $this->class_vars[sendToProduction];
		$config[CYBS_C_ENABLE_LOG]         	= "false";
		$config[CYBS_C_LOG_DIRECTORY]      	= "logs/";
		
		$reply = array();
		
		$status = cybs_run_transaction($config, $request, $reply);
		$auth	= $this->parse_return($reply);
		
		$auth["addon_message"] 	= $auth["reason"]." ".$auth["invalidField"];
		$auth["addon_code"]		= "";
		$auth["addon_oid"] 		= $oid;
		
		if ($status == CYBS_S_OK) {
			if ($auth["decision"] == "ACCEPT") {
				$auth["approved"] = "Approved";
			} elseif ($auth["decision"] == "REVIEW") {
				$auth["approved"] = "Review";
			} else {
				$auth["approved"] = "Error";
			}
		} else {
			$this->handleError($status, $request, $reply);
			exit;
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$auth_reply = array(
			100 => "Successful transaction.",
			101 => "The request is missing one or more required fields.",
			102 => "One or more fields in the request contains invalid data.",
			104 => "The merchantReferenceCode sent with this authorization request matches the merchantReferenceCode of another authorization request that you sent in the last 15 minutes.",
			150 => "Error: General system failure.",
			151 => "Error: The request was received but there was a server timeout. This error does not include timeouts between the client and the server.",
			152 => "Error: The request was received, but a service did not finish running in time.",
			201 => "The issuing bank has questions about the request. You do not receive an authorization code programmatically, but you might receive one verbally by calling the processor.",
			202 => "Expired card.",
			203 => "General decline of the card. No other information provided by the issuing bank.",
			204 => "Insufficient funds in the account.",
			205 => "Stolen or lost card.",
			207 => "Issuing bank unavailable.",
			208 => "Inactive card or card not authorized for card-not-present transactions.",
			210 => "The card has reached the credit limit.",
			211 => "Invalid card verification number.",
			221 => "Inactive card/customer matched an entry on the processors negative file.",
			231 => "Invalid account/card number.",
			232 => "The card type is not accepted by the payment processor.",
			233 => "General decline by the processor.",
			234 => "There is a problem with shops CyberSource merchant configuration.",
			235 => "The requested amount exceeds the originally authorized amount.",
			236 => "Processor failure.",
			238 => "The authorization has already been captured.",
			239 => "The requested transaction amount must match the previous transaction amount.",
			240 => "The card type sent is invalid or does not correlate with the credit card number.",
			241 => "The request ID is invalid.",
			242 => "You requested a capture through the API, but there is no corresponding, unused authorization record.",
			250 => "Error: The request was received, but there was a timeout at the payment processor.",
			520 => "The authorization request was approved by the issuing bank but declined by CyberSource based on shops Authorization settings."
		);
		
		$attributes = array();
	    $attributes = XMLParser($in[CYBS_SK_XML_DOCUMENT]);
		
	    reset($attributes);
		while (list ($key, $val) = each ($attributes)) {
			$name = $val['tag']; $value = $val['value'];
			$name = str_replace("c:", "", $name);
			$out[$name] = $value;
		}
		
		$out[invalidField]	= str_replace("c:", "", $out[invalidField]);
		$out[invalidField]	= str_replace("/", "->", $out[invalidField]);
		$code 				= $out[reasonCode];
		$out[reason] 		= $auth_reply[$code];
		
		return $out;
	}
	
	function handleError($status, $request, $reply) {
		echo "RunTransaction Status: $status\n";
		
		switch ($status) {
			case CYBS_S_PHP_PARAM_ERROR:
				printf("Please check the parameters passed to cybs_run_transaction for correctness.\n" );
				break;
			
			case CYBS_S_PRE_SEND_ERROR:
				printf("The following error occurred before the request could be sent:\n%s\n", $reply[CYBS_SK_ERROR_INFO]);
				break;
			
			case CYBS_S_SEND_ERROR:
				printf("The following error occurred while sending the request:\n%s\n", $reply[CYBS_SK_ERROR_INFO]);
				break;
			
			case CYBS_S_RECEIVE_ERROR:
				printf("The following error occurred while waiting for or retrieving the reply:\n%s\n", $reply[CYBS_SK_ERROR_INFO]);
				$this->handleCriticalError($status, $request, $reply);
				break;
			
			case CYBS_S_POST_RECEIVE_ERROR:
				printf("The following error occurred after receiving and during processing of the reply:\n%s\n", $reply[CYBS_SK_ERROR_INFO]);
				$this->handleCriticalError($status, $request, $reply);
				break;		
			
			case CYBS_S_CRITICAL_SERVER_FAULT:
				printf("The server returned a CriticalServerError fault:\n%s\n", $this->getFaultContent($reply));
				$this->handleCriticalError($status, $request, $reply);
				break;
			
			case CYBS_S_SERVER_FAULT:
				printf("The server returned a ServerError fault:\n%s\n", $this->getFaultContent($reply));
				break;
			
			case CYBS_S_OTHER_FAULT:
				printf("The server returned a fault:\n%s\n", $this->getFaultContent($reply));
				break;
	 		
			case CYBS_S_HTTP_ERROR:
				printf("An HTTP error occurred:\n%s\nResponse Body:\n%s\n", $reply[CYBS_SK_ERROR_INFO], $reply[CYBS_SK_RAW_REPLY]);
				break;
		}
	}
	
	function handleCriticalError($status, $request, $reply) {
		$replyType = '';
		$replyText = '';
		
		if ($status == CYBS_S_CRITICAL_SERVER_FAULT) {
			$replyType = 'FAULT DETAILS: ';
			$replyText = $this->getFaultContent($reply);
		} else {
			$replyText = $reply[CYBS_SK_RAW_REPLY];
			if ($replyText <> '') {
				$replyType = 'RAW REPLY: ';
			} else {
				$replyType = "No Reply available.";
			}
		}
		
		$messageToSend = sprintf("STATUS: %d\nERROR INFO: %s\nREQUEST: \n%s\n%s\n$s\n",	nStatus, $reply[CYBS_SK_ERROR_INFO], $this->getArrayContent($request), $replyType, $replyText);
		
		printf( "\nThis is a critical error. Send the following information to the appropriate personnel at your company: \n%s\n", $messageToSend);
	}
	
	function getFaultContent($reply) {
		$requestID = $reply[CYBS_SK_FAULT_REQUEST_ID];
		if ($requestID == "") {
			$requestID = "(unavailable)";
		}
		return(sprintf("Fault code: %s\nFault string: %s\nRequestID: %s\nFault document: %s", $reply[CYBS_SK_FAULT_CODE], $reply[CYBS_SK_FAULT_STRING],	$requestID, $reply[CYBS_SK_FAULT_DOCUMENT]));
	}
	
	function getArrayContent($arr) {
		$content = '';
		while (list($key, $val) = each($arr)) {
			$content = $content . $key . ' => ' . $val . "\n";
		}
		return($content);
	}
	
	function getFileContent($filename) {
		$handle = fopen($filename, "r");
		$content = fread($handle, filesize($filename));
		fclose($handle);
		return($content);
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='cybersource_api', `internalname`='merchantID', `name`='Merchant ID', `options`='', `value`='', `help`='Your assigned merchant ID.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='cybersource_api', `internalname`='sendToProduction', `name`='Production Mode', `options`='true::false->True::False', `value`='true', `help`='Production mode settings, set to true when you are ready to go live.', `size`='0', `dorder`='2', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='cybersource_api', `internalname`='targetAPIVersion', `name`='API version', `options`='', `value`='1.10', `help`='API version settings. Leave to default if unknown.', `size`='5', `dorder`='3', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='cybersource_api'");
	}
}
?>
