<?PHP
/*
  include/payment/cardia.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Cardia Shop v2.2";
$ADDON_VERSION 	= "2.2";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "cardia";

$ADDON_SHOPOID	= "id";
$ADDON_TOTAL	= "";
$ADDON_ORDERID	= "";

class cardia {
	var $class_vars;
	
	function cardia ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function skip_form () {
		global $settings, $orderinfo, $sess;
		$sess->dvar('orderinfo'); 
		$sess->svar('orderinfo', $orderinfo);
		header('location: '.$settings[secureurl].'checkout.php?l=review');
		exit;
	}
	
	function hold_forward () {
		global $cconnect, $settings, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$prepareURL = 'https://secure.cardia.no/Service/Card/Transaction/1.2/Transaction.asmx/PrepareTransaction';
		if ($this->class_vars[test_mode] == "true") $this->class_vars[merchantToken] = "CF4B6B54-6C28-4FA3-86B0-E9A347D75C6C";
		
		$append = array('status' => 'Pending', 'cc_status' => 'Awaiting Payment', 'pm_name' => 'Cardia Shop v2.2');
		$orderid = store_order($append, '', false);
		
		$param = array (
    		'merchantToken'                	=> $this->class_vars[merchantToken],
    		'merchantReference'            	=> $orderid,
    		'store'                       	=> $settings[title],
    		'orderDescription'            	=> $settings[title].' Order#'.$orderid.' Payment',
    		'currencyCode'                	=> $settings[defaultrate],
    		'amount'                       	=> str_replace('.', ',', p($orderinfo[total], false)),
    		'successfulTransactionUrl'     	=> $settings[secureurl].'checkout.php?return=credit_card&id='.$orderid,
    		'unsuccessfulTransactionUrl'   	=> $settings[secureurl].'checkout.php?return=credit_card&id='.$orderid,
    		'authorizedNotAuthenticatedUrl'	=> '',
    		'skipLastPage'                 	=> 'true',
    		'skipFirstPage'                	=> 'false',
    		'isOnHold'                     	=> 'true',
    		'useThirdPartySecurity'        	=> 'false',
    		'paymentMethod'                	=> '3000',
			'applicationIdentifier'		   	=> ''
  		);
		
		foreach($param as $k => $v ) $data .= $k."=".urlencode(utf8_encode($v))."&";
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $prepareURL);
		$auth	 = $this->parse_xml($results);
		
		switch ($auth['ResponseCode']) {
      		case  1: break;
			case 10: $this->error = 'Invalid merchantReferance (Duplicate?): '.$auth['Error']; break;
			case 11: $this->error = 'Invalid merchantToken (Not Activated?): '.$auth['Error']; break;
      		default: $this->error = 'An unknown Response was received: '.$results; break;
    	}
		
		if ($this->error != "") {
			echo $this->error; exit;
		} else {
			$out[payment_tags] = '<input type="hidden" name="guid" value="'.$auth['ReferenceGuid'].'">';
			$out[url] = $auth['Address'].'?guid='.$auth['ReferenceGuid'];
			$out[method] = "GET";
		}
		return $out;
	}
	
	function verify () {
		global $cconnect, $orderinfo;
    	$statusURL  = 'https://secure.cardia.no/Service/Card/Transaction/1.2/Transaction.asmx/ReturnTransactionStatus';
		
		if ($this->class_vars[test_mode] == "true") $this->class_vars[merchantToken] = "CF4B6B54-6C28-4FA3-86B0-E9A347D75C6C";
		
		$param = array (
    		'merchantToken'		=> $this->class_vars[merchantToken],
    		'merchantReference'	=> $orderinfo[id],
  		);
		
		foreach($param as $k => $v ) $data .= "$k=".urlencode(utf8_encode($v))."&";
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $statusURL);
		$auth = $this->parse_xml($results);
		
		switch ($auth['StatusCode']) {
      		case 1: break;
     		case 3: $trans_error = "There was no transaction - aborted:"; break;
      		case 2: $trans_error = "The transaction was rejected:"; break;
      		case 4: $trans_error = "General error:"; break;
      		case 5: $trans_error = "The transaction was authorized and later voided:"; break;
     	}
		
    	switch ($auth['ResponseCode']) {
      		case  0: break;
      		case 25: case 26: case 27: case 28: case 29: case 31: case 54: $auth_error = "Card cannot be used for internet purchase."; break;
      		case 17: case 18: $auth_error = "Invalid expiration date, or already expired."; break;
      		case 6: case 7: case 19:  $auth_error = "Invalid card number."; break;
      		case 45: case 46: $auth_error = "Amount too low, or too high."; break;
      		case 69: case 75: $auth_error = "Card not authorized."; break;
      		case 74: $auth_error = "Card rejected."; break;
    	}
		
    	return array(
     		'HasFault'			=> ($auth_error || $trans_error) ? true:false,
     		'AuthError'			=> $auth_error,
     		'TransError'		=> $trans_error,
     		'ResponseCode'		=> $auth['ResponseCode'],
     		'StatusCode'		=> $auth['StatusCode'],
     		'Amount'			=> $auth['Amount'],
     		'CurrencyCode'		=> $auth['CurrencyCode'],
			'MerchantReference' => $orderinfo[id]
    	);
	}
	
	function parse_xml ($in) {
		$attributes = array();
	    $attributes = XMLParser($in);
		
	    reset($attributes);
		while (list ($key, $val) = each ($attributes)) {
			$name = $val['tag']; $value = $val['value'];
			$out[$name] = $value;
		}
		return $out;
	}
	
	function catch_return () {
		global $userinfo, $orderinfo, $cconnect, $abs_path;
		
		include_once $abs_path.'/include/classes/class.connect.php';
		$cconnect = new curl_connect();
		$POST = $this->verify();
		
		if ($POST['ResponseCode'] == 0 && $POST['StatusCode'] == 1) {
			$results['approved'] = "Approved";
		} else {
			$results['approved'] = "Error";
			$results[error] = $POST['TransError']." ".$POST['AuthError'];
		}
		return $results;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='cardia', `internalname`='merchantToken', `name`='Merchant Token', `options`='', `value`='', `help`='A unique identifier identifying the merchant. The ID is given to you by Cardia..', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='cardia', `internalname`='test_mode', `name`='Test Mode', `options`='true::false->True::False', `value`='true', `help`='Set to false to go live.', `size`='0', `dorder`='2', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='cardia', `internalname`='pass_type', `name`='', `options`='', `value`='get', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='cardia'");
	}
}
?>