<?PHP
/*
  include/payment/bluepay_advanced.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Bluepay Advanced Integration";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "bluepay_adv";

class bluepay_adv {
	var $class_vars;
	
	function bluepay_adv ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$tps = $this->class_vars[merchantkey] . $this->class_vars[merchantid] . 'SALE' . p($orderinfo[total], false) . $userinfo[bill_first_name] . tempdecryptit($orderinfo[cc_card_no]);
		$tps = md5($tps);
		
		$param = array (
			'ACCOUNT_ID' 		=> $this->class_vars[merchantid],
			'USER_ID' 			=> '',
			'TAMPER_PROOF_SEAL' => $tps,
			'TRANS_TYPE' 		=> 'SALE',
			'PAYMENT_TYPE' 		=> 'CREDIT',
			'MODE' 				=> $this->class_vars[testmode],
			'MASTER_ID' 		=> '',
			
			'PAYMENT_ACCOUNT' 	=> tempdecryptit($orderinfo[cc_card_no]),
			'CARD_CVV2' 		=> $orderinfo[cc_cvv2],
			'CARD_EXPIRE' 		=> str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT).substr($orderinfo[cc_expir_year], -2, 2),
			'SSN' 				=> '',
			'BIRTHDATE' 		=> '',
			'CUST_ID' 			=> '',
			'CUST_ID_STATE' 	=> '',
			'AMOUNT' 			=> p($orderinfo[total], false),
			'NAME1' 			=> $userinfo[bill_first_name],
			'NAME2' 			=> $userinfo[bill_last_name],
			'ADDR1' 			=> $userinfo[bill_address1],
			'ADDR2' 			=> $userinfo[bill_address2],
			'CITY' 				=> $userinfo[bill_city],
			'STATE' 			=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'ZIP' 				=> $userinfo[bill_zip],
			'COUNTRY' 			=> $userinfo[bill_country],
			'MEMO' 				=> '',
			
			'ORDER_ID' 			=> '',
			'INVOICE_ID' 		=> '',
			'AMOUNT_TIP' 		=> '',
			'AMOUNT_TAX' 		=> '',
			
			'DO_REBILL' 		=> '',
			'REB_FIRST_DATE' 	=> '',
			'REB_EXPR' 			=> '',
			'REB_CYCLES' 		=> '',
			'REB_AMOUNT' 		=> '',
			
			'DO_AUTOCAP' 		=> '1',
			'AVS_ALLOWED'		=> $this->class_vars[match_avs],
			'CVV2_ALLOWED' 		=> $this->class_vars[match_cvv2]
		);
		
		//debug($param);
		
		$header_array = array();
		$header = "";
		
		foreach($param as $k => $v ) {
			$data .= $k."=".$v."&";
		}
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$authnet = $this->parse_return($results);
		
		$authnet["addon_message"] 	= $authnet["MESSAGE"];
		$authnet["addon_code"]		= $authnet["AUTH_CODE"];
		$authnet["addon_oid"] 		= $authnet["TRANS_ID"];
		
		if ($authnet["STATUS"] == "1") {
			$authnet["approved"] = "Approved";
		} else {
			$authnet["approved"] = "Error";
		}
		
		return $authnet;
	}
	
	function parse_return ($in) {
		parse_str($in, $out);
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bluepay_adv', `internalname`='merchantid', `name`='Merchant ID', `options`='', `value`='', `help`='Your Bluepay Merchant ID.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bluepay_adv', `internalname`='merchantkey', `name`='Merchant Key', `options`='', `value`='', `help`='Your Transaction Key.', `size`='30', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bluepay_adv', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://secure.bluepay.com/interfaces/bp20post', `help`='Transaction url. Leave default if you are unsure.', `size`='60', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bluepay_adv', `internalname`='testmode', `name`='Test Mode', `options`='TEST::LIVE->True::False', `value`='', `help`='Test mode status. Set to false to go live.', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bluepay_adv', `internalname`='match_avs', `name`='AVS Match', `options`='#::SUXYER_->Dont Enforce::Enforce', `value`='#', `help`='', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='bluepay_adv', `internalname`='match_cvv2', `name`='CVV2 Match', `options`='#::MP_->Dont Enforce::Enforce', `value`='#', `help`='', `size`='0', `dorder`='6', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='bluepay_adv'");
	}
}
?>