<?PHP
/*
  include/methods/paypal_standard.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Amazon Simple Pay (IPN)";
$ADDON_VERSION 	= "1.0";
$ADDON_TYPE 	= "Pay Method";
$CLASS_NAME 	= "amazon_simple_pay";

class amazon_simple_pay {
	var $class_vars;
	
	function amazon_simple_pay ($class_vars) {
		global $settings;
		$this->class_vars	= $class_vars;
		$this->required		= array();
		$this->req_names	= array();
	}
	
	function render () {
		global $settings, $orderinfo, $sess;
		$sess->dvar('orderinfo'); 
		$sess->svar('orderinfo', $orderinfo);
		header('location: '.$settings[secureurl].'checkout.php?l=review');
		exit;
	}
	
	function check_required () {
		return true;
	}
	
	function pre_process () { 
		global $settings, $lang;
		$lango = $lang['order'];
		
		$display = array($lango['pay_method'] => $this->class_vars[display_name]);
		foreach ($display as $k => $v) {
			$data[payment_details] .= ($v != "")?template('order_overall_review_payment_item.html', array('item' => array('name' => $k, 'value' => $v))):"";
		}
		
		$data[form_action] = $settings[secureurl].'checkout.php?l=process';
		return $data;
	}
	
	function getSignature($stringToSign) {
		global $abs_path;
		include_once $abs_path.'/include/classes/class.hmac.php';
		$crypt = new crypt_hmac($this->class_vars[merchant_key_secret], 'sha1');
		$binary_hmac = pack("H40", $crypt->hash(trim($stringToSign)));
		return base64_encode($binary_hmac);
	}

	
	function process () {
		global $settings, $lang, $txname, $mrb, $sess;
		$lango = $lang['order'];
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$append = array(
			'cc_status'		=> 'Awaiting Payment',
			'status'		=> 'Pending',
			'pm_name'		=> $ADDON_NAME,
			'pm_module'		=> 'amazon_simple_pay.php',
			'pm_type'		=> 'methods',
		);
		$data[orderid]	= store_order($append, '', false);
		$data[result]	= $lango['order_success'];
		$data[notes]	= $lango['notes_amazon'];
		
		$sign_fields = array(
			'accessKey' 				=> $this->class_vars[merchant_key_id],
			'amazonPaymentsAccountId' 	=> $this->class_vars[merchant_account_id],
			'immediateReturn' 			=> '1',
			'processImmediate' 			=> '1',
			'collectShippingAddress' 	=> '0',
			'cobrandingStyle'			=> 'logo',
			'isDonationWidget' 			=> '0',
			'referenceId' 				=> $data[orderid],
			'amount' 					=> $settings[defaultrate].' '.p($orderinfo[total], false),
			'description' 				=> $settings[title].' Order #: '.$data[orderid],
			'ipnUrl' 					=> $settings[secureurl].'include/methods/simple_pay_ipn/simple_pay_ipn.php',
			'returnUrl' 				=> $settings[shopurl].'checkout.php?return=amazon_simple_pay',
			'abandonUrl' 				=> $settings[shopurl].'index.php?l=cart_view'
		);
		
		ksort($sign_fields);
		foreach ($sign_fields as $k => $v) $stringToSign .= $k . $v;
		$sign_fields[signature] = $this->getSignature($stringToSign);
		
		foreach ($sign_fields as $k => $v) {
			$proceed[data] .= '<input type="hidden" name="'.$k.'" value="'.$v.'" />'."\n";
		}
		$proceed[data] .= '<input type="image" src="https://authorize.payments.amazon.com/pba/images/GLPayNowWithLogo.png" border="0"><br /><br />';
		$proceed[url] = 'https://authorize.payments.amazon.com/pba/paypipeline';
		$data[form] = template('order_payment_proceed.html', array('proceed' => $proceed, 'lang' => $lango));
		
		return $data;
	}
	
	function catch_return () {
		global $DB_site, $dbprefix, $abs_path, $sess, $settings, $orderinfo, $userinfo, $cart, $lang, $gs, $ae;
		
		$returned 	= $_GET;
		$lango 		= $lang['order'];
		$orderinfo	= get('orders', $returned[referenceId]);
		$userinfo	= $orderinfo;
		$cart		= new cart();
		
		$orderinfo[pay_method] = 'amazon_simple_pay';
		
		ksort($returned);
		unset($returned[signature]);
		foreach ($returned as $k => $v) $stringToSign .= $k . $v;
		$signature = $this->getSignature($stringToSign);
		
		$append = array(
			'pm_module'		=> 'amazon_simple_pay.php',
			'pm_type'		=> 'methods',
			'pm_name'		=> 'Amazon Simple Pay (IPN)',
			'pm_orderid'	=> $returned[transactionId]
		);
	
		if ($_GET[signature] == urldecode($signature)) {
			$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$orderinfo[id]."' ORDER by `id`");
			while ($row = $DB_site->fetch_assoc($results)) {
				$cart->items[] = unserialize(base64_decode(stripslashes($row[data])));
			}
			
			switch ($returned[status]) {
				case 'PS': case 'PR':
					$append2 = array('status' => 'Pending', 'cc_status' => 'Payment Received');
					$data[orderid]	= update_order($orderinfo[id], array_merge($append, $append2), true);
					$data[result]	= $lango['order_success'];
					break;
				case 'PI':
					$ae->new_alert('<strong>Order Note:</strong> Your payment has been initiated but it will take between five seconds and 48 hours to complete, based on the availability of external payment networks and the riskiness of the transaction.');
					$append2 = array('status' => 'Pending', 'cc_status' => 'Payment Initiated');
					$data[orderid]	= update_order($orderinfo[id], array_merge($append, $append2), false);
					$data[result]	= $lango['order_success'];
					break;
				case 'PF':
					$ae->new_error('<strong>'.$lango['pay_error'].'</strong> Your payment has been declined or has failed.');
					$append2 = array('status' => 'Pending', 'cc_status' => 'Error');
					$data[orderid]	= update_order($orderinfo[id], array_merge($append, $append2), false);
					$data[result]	= $lango['order_error'];
					break;
				default:
					$ae->new_error('<strong>'.$lango['pay_error'].'</strong>');
					$append2 = array('status' => 'Pending', 'cc_status' => 'Error');
					$data[orderid]	= update_order($orderinfo[id], array_merge($append, $append2), false);
					$data[result]	= $lango['order_error'];
					break;
			}
		} else {
			$returned[errorMessage] = ($returned[errorMessage]=='')?'Unable to verify signature. Please contact us so that we can manually verify your payment.':$returned[errorMessage];
			$ae->new_error('<strong>'.$lango['pay_error'].'</strong> '.$returned[errorMessage]);
			$data[orderid]	= update_order($orderinfo[id], $append, false);
			$data[result]	= $lango['order_error'];
		}
		return $data;
	}
	
	function initiate_refund ($order) {
		global $settings, $abs_path, $DB_site, $dbprefix;
		
		$data  = array(
			'Action'						=> 'Refund',
			'AWSAccessKeyId'				=> $this->class_vars[merchant_key_id],
			'RefundAmount.CurrencyCode'		=> $settings[defaultrate],
			'RefundAmount.Value'			=> $order[total],
			'RefundTransactionReference'	=> 'Refund for '.$order[id],
			'SignatureVersion'				=> '1',
			'Timestamp'						=> date('Y-m-d\TH:i:s'). substr_replace(date('O'),':',3,0),
			'TransactionDescription'		=> 'Refund for '.$order[id],
			'TransactionId'					=> $order[pm_orderid],		
			'Version'						=> '2008-05-01'
		);
		
		foreach ($data as $k => $v) $stringToSign .= $k . $v;
		$data[Signature] = $this->getSignature($stringToSign);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.urlencode($v).(($k!='Signature')?"&":'');
		}
		
		include_once $abs_path.'/include/classes/class.connect.php';
		$cconnect = new curl_connect();
		$results = $cconnect->connect($data_string, $header, array(), 'https://fps.amazonaws.com/paynow');
		$returned = parse_xml($results);
		
		if ($returned[ErrorResponse][Error][Message] != '') {
			return $returned[ErrorResponse][Error][Message];
		} else {
			$attributes = array();
			$returned	= array();
			$attributes = XMLParser($results);
			
			reset($attributes);
			while (list ($key, $val) = each ($attributes)) {
				$name = $val['tag']; $value = $val['value'];
				$returned[$name] = $value;
			}
			
			if ($returned['ns1:PendingReason'] == "Pending response from the Payment Processor.") {
				$DB_site->query("UPDATE `".$dbprefix."orders` set `cc_status`='Refunded', `status`='Canceled' where id='".$order[id]."'");
				$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$order[id]."', `type`='A', `private`='1', `note`='A refund on this order has been initiated in the amount of ".p($order[total]).". Transaction ID: ".$returned['ns1:TransactionId']."', `addedby`='Amazon IPN', `datestamp`='".stamp()."'");
				return $returned['ns1:PendingReason'];
			} else {
				return 'An unknown error occured. Please try again later.';
			}
		}
	}
	
	function load_actions () {
		$map_actions = array (
			'Amazon Simple Pay: Initiate a Refund' => 'initiate_refund'
		);
		return $map_actions;
	}
	
	function install () {
		global $DB_site, $dbprefix, $settings;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='amazon_simple_pay', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='amazon_simple_pay', `internalname`='display_name', `name`='Display Name', `moptions`='', `options`='', `value`='Amazon Simple Pay (Via Amazon Site)', `help`='', `size`='36', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='amazon_simple_pay', `internalname`='merchant_account_id', `name`='AWS Account ID', `options`='', `value`='', `help`='Your AWS Account ID', `size`='30', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='amazon_simple_pay', `internalname`='merchant_key_id', `name`='AWS Access Key ID', `options`='', `value`='', `help`='Your AWS Access Key ID', `size`='30', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='amazon_simple_pay', `internalname`='merchant_key_secret', `name`='AWS Secret Access Key', `options`='', `value`='', `help`='Your AWS Secret Access Key', `size`='30', `dorder`='5', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='amazon_simple_pay', `internalname`='display_order', `name`='Display Order', `moptions`='', `options`='', `value`='1', `help`='', `size`='4', `dorder`='6', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_methods where `module`='amazon_simple_pay'");
	}
}

$OUT_DATA = 'PHRhYmxlIGJvcmRlcj0iMCIgY2VsbHNwYWNpbmc9IjAiIGNlbGxwYWRkaW5nPSIzIj4NCgk8dHI+DQoJCTx0ZCB2YWxpZ249Im1pZGRsZSI+PGltZ
	yBzcmM9ImltYWdlcy9hbWF6b25fcGF5bWVudHMucG5nIiBhbHQ9IkFtYXpvbiBQYXltZW50cyIgd2lkdGg9IjEzNCIgaGVpZ2h0PSI4NCIgYm9yZGVyPSIwIiB
	zdHlsZT0iYm9yZGVyOiAwcHggc29saWQgIzAwMDAwMDsiPjwvdGQ+DQoJCTx0ZD48aW1nIHNyYz0iJHNldHRpbmdzW3RoZW1lX3BhdGhdL2ltYWdlcy9zcGFjZ
	S5naWYiIHdpZHRoPSIxMCIgaGVpZ2h0PSIxIiBib3JkZXI9IjAiPjwvdGQ+DQoJCTx0ZCB2YWxpZ249Im1pZGRsZSI+DQoJCQlBbWF6b24gUGF5bWVudHMgb2Z
	mZXJzIG1lcmNoYW50cyBhIHNldCBvZiBwYXltZW50IGFuZCBjaGVja291dCBzb2x1dGlvbnMgdGhhdCB0aGV5IGNhbiBpbnRlZ3JhdGUgDQoJCQlvbiB0aGVpc
	iBzaXRlLiBUaGVzZSBzb2x1dGlvbnMgZW5hYmxlIHRoZSB0ZW5zIG9mIG1pbGxpb25zIG9mIEFtYXpvbiBjdXN0b21lcnMgdG8gY29tcGxldGUgcHVyY2hhc2V
	zIG9uIHlvdXIgDQoJCQl3ZWJzaXRlIHVzaW5nIHRoZSBzYW1lIGluZm9ybWF0aW9uIGluIHRoZWlyIEFtYXpvbi5jb20gYWNjb3VudC48YnI+PGJyPg0KCQkJP
	GlucHV0IHR5cGU9ImJ1dHRvbiIgdmFsdWU9IkxlYXJuIE1vcmUiIG9uQ2xpY2s9IndpbmRvdy5vcGVuKCdodHRwOi8vd3d3LnR1cm5rZXl3ZWJ0b29scy5jb20
	vc3Vuc2hvcC9hbWF6b24uaHRtbCcsJ0FtYXpvbicsJ3dpZHRoPTYwMCxoZWlnaHQ9NTAwLHJlc2l6YWJsZT0xLHNjcm9sbGJhcnM9MSx0aXRsZWJhcj0xLG1lb
	nViYXI9MSx0b29sYmFyPTEsbG9jYXRpb249MSxzdGF0dXM9MSxkaXJlY3Rvcmllcz0xLGNoYW5uZWxtb2RlPTAsZnVsbHNjcmVlbj0wJyk7IHJldHVybiBmYWx
	zZTsiPg0KCQk8L3RkPg0KDQoJPC90cj4NCjwvdGFibGU+';

?>