<?PHP
/*
  include/class.orderitem.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

class orderitem {
	var $item;
	
	function orderitem ($item) {
		$this->item = unserialize(base64_decode(stripslashes($item)));
	}
	
	function get_quantity () {
		return $this->item->quantity;
	}
	
	function update_quantity ($quantity) {
		if ($quantity < 1) return;
		$this->item->quantity = $quantity;
	}
	
	function remove_option ($index) {
        if ($index < 0) return;
        unset($this->item->options[$index]);
    }
	
	function return_options () {
		$options = array();
		if ($this->item->id == "gs") {
			foreach ($this->item->options[0] as $k => $v) {
				$options[$k]  = $v;
			}
		} else {
			foreach ($this->item->options as $k => $v) {
				$data = array();
				$data[id] 		= $this->item->options[$k]->id;
				$data[name] 	= $this->item->options[$k]->name;
				$data[value] 	= $this->item->options[$k]->value;
				$data[valueid] 	= $this->item->options[$k]->valueid;
				$data[weight] 	= $this->item->options[$k]->weight;
				$data[sku] 		= $this->item->options[$k]->sku;
				$data[price] 	= $this->item->options[$k]->price;
				$data[desc] 	= $this->item->options[$k]->desc;
				array_push($options, $data);
			}
		}
		return $options;
	}
	
	function options_price_increase () {
		$total = '0.00';
		if (!is_array($this->item->options)) return $total;
		foreach ($this->item->options as $k => $v)
			$total += $this->item->options[$k]->price;
		return $total;
	}
	
	function display_options_together () {
		global $lang;
		if ($this->item->id == "gs") {
			foreach ($this->item->options[0] as $k => $v) {
				$option[name]  = $lang['gs'][$k];
				$option[value] = $v;
				$ret .= "$option[name]: $option[value]; ";
			}
		} else {
			if (!is_array($this->item->options)) return;
			foreach ($this->item->options as $k => $v) {
				$option[name]  = $this->item->options[$k]->name;
				$option[value] = $this->item->options[$k]->value;
				$option[sku]   = ($this->item->options[$k]->sku!='')?'('.$this->item->options[$k]->sku.') ':'';
				$ret .= "$option[sku]$option[name]: $option[value]; ";
			}
		}
		return $ret;
	}
	
	function display_options () {
		global $lang;
		if ($this->item->id == "gs") {
			foreach ($this->item->options[0] as $k => $v) {
				$option[name]  = $lang['gs'][$k];
				$option[value] = $v;
				$ret .= template('orders_option_display.html', $option);
			}
		} else {
			if (!is_array($this->item->options)) return;
			foreach ($this->item->options as $k => $v) {
				$option[name]  = $this->item->options[$k]->name;
				$option[value] = $this->item->options[$k]->value;
				$option[sku]   = ($this->item->options[$k]->sku!='')?'('.$this->item->options[$k]->sku.') ':'';
				$ret .= template('orders_option_display.html', $option);
			}
		}
		return $ret;
	}
	
	function display_options_client () {
		global $lang;
		if ($this->item->id == "gs") {
			foreach ($this->item->options[0] as $k => $v) {
				if ($k == 'cert') continue;
				$option[name]  = $lang['cart_view_gs'][$k];
				$option[value] = $v;
				$ret .= template('misc_option_display.html', array('option' => $option));
			}
		} else {
			if (!is_array($this->item->options)) return;
			foreach ($this->item->options as $k => $v) {
				$option[name]  = $this->item->options[$k]->name;
				$option[value] = $this->item->options[$k]->value;
				//$option[sku]   = ($this->item->options[$k]->sku!='')?'('.$this->item->options[$k]->sku.') ':'';
				$ret .= template('misc_option_display.html', array('option' => $option));
			}
		}
		return $ret;
	}
	
	function return_serialized () {
		return serialize($this->item);
	}
}
?>