<?PHP
/*
  include/class.imageresize.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

define("GIF", 1);
define("JPG", 2);
define("PNG", 3);

class image_resize {
	var $rdata;
	
	function image_resize () { }
	
	function createfromsource ($in, $img){
		switch ($in) {
			case JPG: $src = @imagecreatefromjpeg($img); break;
			case GIF: $src = @imagecreatefromgif($img); break;
			case PNG: $src = @imagecreatefrompng($img); break;
			default: return false; break;
		}
		return $src;
	}
	
	function resize_and_store ($ipath="", $maxHeight=0, $maxWidth=0, $bpath=false) {
		$return = $this->resize($ipath, $maxHeight, $maxWidth, $bpath, true);
		if ($return) $this->store($ipath);
		return $return;
	}
	
	function resize_and_display ($ipath="", $maxHeight=0, $maxWidth=0) {
		$this->resize($ipath, $maxHeight, $maxWidth);
		$this->display();
	}
	
	function resize ($ipath="", $maxHeight=0, $maxWidth=0, $bpath=false, $checkfalse=false) {
		global $settings, $abs_path;
		$this->rdata = array();
		
		// Return To Prevent Errors
		if ($ipath=="" || $maxHeight==0 || $maxWidth==0) return false;
		if (!extension_loaded("gd") && !extension_loaded("imagick")) return false;
		if ($settings[resize] == "none") return false;
		
		if (!($size=@getimagesize($ipath))) return false;
		
		$this->rdata[file]		= basename($ipath);
		$this->rdata[curr_w]	= $size[0];
		$this->rdata[curr_h]	= $size[1];
		$this->rdata[curr_t]	= $size[2];
		$this->rdata[curr_m] 	= $size['mime'];
		
		if ($this->rdata[curr_h] != 0 && $this->rdata[curr_w] != 0) {
			$this->rdata[srcRatio]	= $this->rdata[curr_w]/$this->rdata[curr_h];
			$this->rdata[destRatio]	= $maxWidth/$maxHeight;
		} else {
			if ($checkfalse) return false;
		}
		
		if ($this->rdata[destRatio] > $this->rdata[srcRatio]) {
			$this->rdata[new_h] = $maxHeight;
			$this->rdata[new_w] = ceil($maxHeight*$this->rdata[srcRatio]);
		} else {
			$this->rdata[new_w] = $maxWidth;
			$this->rdata[new_h] = ceil($maxWidth/$this->rdata[srcRatio]);
		}
		
		if ($this->rdata[new_h] > $this->rdata[curr_h] || $this->rdata[new_w] > $this->rdata[curr_w]) {
			$this->rdata[new_w] = $this->rdata[curr_w];
			$this->rdata[new_h] = $this->rdata[curr_h];
			if ($checkfalse) return false;
		}
		
		if ($bpath!=false) @copy($ipath, $abs_path."/".$settings[productpath]."originals/".$this->rdata[file]);
		
		if ($settings[resize] == "gd") {
			$this->rdata[im] = imagecreatetruecolor($this->rdata[new_w], $this->rdata[new_h]);
			if(!$this->rdata[im]) return false;
			
			if ($this->rdata[curr_t] == 1 || $this->rdata[curr_t] == 3) {
				imagefill($this->rdata[im], 0, 0, 0xffffff);
			}
			
			$src_img = $this->createfromsource($this->rdata[curr_t], $ipath);
			imagecopyresampled($this->rdata[im], $src_img, 0, 0, 0, 0, $this->rdata[new_w], $this->rdata[new_h], imagesx($src_img), imagesy($src_img));
			return true;
		} elseif ($settings[resize] == "imagick") {
			$this->rdata[im] = @imagick_readimage($ipath);
			if(!$this->rdata[im]) return false;
			imagick_scale($this->rdata[im], $this->rdata[curr_w], $this->rdata[curr_h]);
			imagick_writeimage($this->rdata[im], $ipath);
			imagick_free($this->rdata[im]);
			return true;
		}
		return false;
	}
	
	function store ($ipath) {
		global $settings;
		if ($settings[resize] == "gd") {
			switch($this->rdata[curr_t]){
				case JPG; imagejpeg($this->rdata[im], $ipath, 100); break;
				case PNG; imagepng($this->rdata[im], $ipath); break;
				case GIF; imagegif($this->rdata[im], $ipath); break;
				default; return false; break;
			}
		} else {
			imagick_writeimage($this->rdata[im], $ipath);
			imagick_free($this->rdata[im]);
		}
	}
	
	function display () {
		global $settings;
		header('Content-type: '.$this->rdata[curr_m]);
		if ($settings[resize] == "gd") {
			switch($this->rdata[curr_t]){
				case JPG; imagejpeg($this->rdata[im], '', 100); break;
				case PNG; imagepng($this->rdata[im]); break;
				case GIF; imagegif($this->rdata[im]); break;
				default; return false; break;
			}
		} else {
			imagick_displayimage($this->rdata[im]);
			imagick_free($this->rdata[im]);
		}
	}
}
?>