<?PHP
/*
  include/class.cart.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

class gs_option {
	var $sender_name;
    var $recipient_name;
	var $recipient_email;
	var $message;
    var $price;
	var	$cert;
    
    function gs_option () {
		$this->sender_name 	= '';
		$this->recipient_name	= '';
		$this->recipient_email 	= '';
		$this->message 		= '';
		$this->price 		= '';
		$this->cert 		= '';
    }
}

class option {
    var $id;
	var $product;
	var $name;
    var $value;
	var $valueid;
	var $weight;
	var $price;
	var $desc;
    
    function option () {
		$this->id 	= 0;
		$this->product 	= '';
		$this->name 	= '';
		$this->value 	= '';
		$this->valueid 	= 0;
		$this->weight 	= 0;
		$this->weight 	= '';
		$this->price 	= 0;
		$this->desc 	= '';
    }
}

class item {
	var $id;
	var $quantity;
	var $options;
	var $regid;
	
	function item ($id=0, $quantity=0, $opt=array(), $regid='') {
		$this->id 		= $id;
		$this->quantity = $quantity;
		$this->options 	= array();
		$this->regid	= $regid;
		if ($opt[gs] == 1) {
			$this->options[0] = new gs_option();
			$this->options[0]->sender_name		= $opt[sender_name];
			$this->options[0]->recipient_name	= $opt[recipient_name];
			$this->options[0]->recipient_email	= $opt[recipient_email];
			$this->options[0]->message		= $opt[message];
			$this->options[0]->price		= $opt[amount];
		} else {
			foreach ($opt as $k => $v) {
				$entry = count($this->options);
				$data = option_data($k, $v);
				$this->options[$entry]		= new option();
				$this->options[$entry]->id	= $data[id];
				$this->options[$entry]->product	= $data[product];
				$this->options[$entry]->name	= $data[name];
				$this->options[$entry]->value	= $data[value];
				$this->options[$entry]->valueid	= $data[valueid];
				$this->options[$entry]->weight 	= $data[weight];
				$this->options[$entry]->sku 	= $data[sku];
				$this->options[$entry]->price 	= $data[price];
				$this->options[$entry]->desc	= $data[desc];
			}
		}
	}
	
	function addoption ($id, $value) {
		$entry = count($this->options);
		$data = option_data ($id, $value);
		$this->options[$entry]			= new option();
		$this->options[$entry]->id		= $data[id];
		$this->options[$entry]->product	= $data[product];
		$this->options[$entry]->name	= $data[name];
		$this->options[$entry]->value 	= $data[value];
		$this->options[$entry]->valueid = $data[valueid];
		$this->options[$entry]->weight 	= $data[weight];
		$this->options[$entry]->sku 	= $data[sku];
		$this->options[$entry]->price 	= $data[price];
		$this->options[$entry]->desc 	= $data[desc];
    }
	
	function options_weight_increase () {
		$weight = '0.00';
		foreach ($this->options as $k => $v)
			$weight += $this->options[$k]->weight;
		return $weight;
	}
	
	function options_price_increase () {
		$total = '0.00';
		foreach ($this->options as $k => $v)
			$total += $this->options[$k]->price;
		return $total;
	}
	
	function removeoption ($index) {
		if ($index < 0) return;
		unset($this->options[$index]);
	}
	
	function display_options () {
		global $lang;
		if ($this->id == "gs") {
			foreach ($this->options[0] as $k => $v) {
				if ($k == 'cert') continue;
				$option[name]  = $lang['cart_view_gs'][$k];
				$option[value] = $v;
				$ret .= template('misc_option_display.html', array('option' => $option));
			}
		} else {
			foreach ($this->options as $k => $v) {
				$option[name]  = $this->options[$k]->name;
				$option[value] = $this->options[$k]->value;
				$ret .= template('misc_option_display.html', array('option' => $option));
			}
		}
		return $ret;
	}
	
	function subtotal () {
		$subtotal	= '0.00';
	    $iteminfo	= get('products', $this->id);
		$iteminfo	= calc_price($iteminfo, $this->quantity);
		$price		= $iteminfo[out_price] + $this->options_price_increase();
		$subtotal	+= (($price * $this->quantity));
		return $subtotal;
	}
	
	function return_serialized () {
		return serialize($this);
	}
}

class cart {
    var $items;
	var $coupon;
	
	function cart () {
        $this->items = array();
		$this->previous = array();
		$this->coupon = '';
	}
	
	function restoreitem ($obj) {
		$this->items[]	= unserialize(base64_decode($obj));
	}
	
	function additem ($id='', $quantity=0, $opt=array(), $regid='') {
		if ($opt[gs] == 1) { $this->items[] = new item('gs', ceil($quantity), $opt); return; }
		if ($id == '' || $id == 0 || (!is_object($id) && $quantity == 0)) return;
		foreach ($this->items as $k => $v) {
			$obj = $this->options_to_object($opt);
			if ($this->items[$k]->id == $id && md5(serialize($this->items[$k]->options)) == md5(serialize($obj))) {
				if (!$this->revalidateitem($k, ($this->items[$k]->quantity + ceil($quantity)))) {
					$this->items[$k]->quantity = $this->items[$k]->quantity + ceil($quantity);
					return true;
				} else {
					return false;
				}
			}
		}
		$this->items[] = new item($id, ceil($quantity), $opt, $regid);
		return true;
	}
	
	function revalidateitem ($item_index, $quantity) {
		global $DB_site, $dbprefix, $settings, $sess, $lang, $ae;
		if ($this->items[$item_index]->id == '') return 'skip'; 
		$option_errors = array();
		$product = get('products', $this->items[$item_index]->id);
		foreach($this->items[$item_index]->options as $k => $v) {
			$options = $DB_site->query_first("SELECT oi.`optionid`, o.`name`, oi.`in_stock`, oi.`value` FROM `".$dbprefix."products_options_items` oi LEFT JOIN `".$dbprefix."products_options` o on oi.`optionid`=o.`id` WHERE oi.`id`='".addslashes($v->valueid)."'");
			if (($options[in_stock] < $quantity) && $settings[enforceoptionstock] == "Yes" && $options[optionid] != "") {
				$ae->new_error('<strong>'.$product[title].':</strong> '.$lang['cart_view']['currently'].' '.$options[in_stock].' '.$lang['cart_view']['of'] .' '.$options[name].' "'.$options[value].'" '.$lang['cart_view']['stock2']);
			}
		}
		
		if ($product[viewable] == 'n') { $ae->new_error('<strong>'.$product[title].':</strong> '.$lang['cart_view']['notviewable']); }
		if ($product[in_stock] < $quantity && $settings[enforcestock] == "Yes") $ae->new_error('<strong>'.$product[title].':</strong> '.$lang['cart_view']['notthatmany']);
		if ($product[id] == "") $ae->new_error($lang['cart_view']['invalidid']);
		
		return $ae->is_errors();
	}
	
	function options_to_object ($opt) {
		$options = array();
		$entry = 0;
		foreach ($opt as $k => $v) {
			$data = option_data ($k, $v);
			$options[$entry]			= new option();
			$options[$entry]->id		= $data[id];
			$options[$entry]->product	= $data[product];
			$options[$entry]->name		= $data[name];
			$options[$entry]->value 	= $data[value];
			$options[$entry]->valueid 	= $data[valueid];
			$options[$entry]->weight 	= $data[weight];
			$options[$entry]->sku 		= $data[sku];
			$options[$entry]->price 	= $data[price];
			$options[$entry]->desc 		= $data[desc];
			$entry++;
		}
		return $options;
	}
	
	function subtotal ($type=1) {
		$subtotal = '0.00';
		foreach ($this->items as $k => $v) {
			$iteminfo = get('products', $this->items[$k]->id);
			if (($type == 2 && $iteminfo[charge_tax] == "y") || ($type == 1) || ($type == 3 && $iteminfo[charge_shipping] == "y"))
				$subtotal += $this->items[$k]->subtotal();
		}
		return $subtotal;
	}
	
	function product_count () {
		$count = 0;
		foreach ($this->items as $k => $v) 
			$count += $this->items[$k]->quantity;
		return $count;
	}
	
	function weight () {
		global $settings;
		foreach ($this->items as $k => $v) {
	    	$iteminfo = get('products',$this->items[$k]->id);
			if ($iteminfo[charge_shipping] == "y")
				$weight += (($iteminfo[weight] + $this->items[$k]->options_weight_increase()) * $this->items[$k]->quantity);
		}
		$weight = ($settings[roundup]=="Yes")?round($weight):$weight;
		return $weight;
	}
	
	function set_previous ($p_array) {
		unset($this->previous);
		$this->previous = $p_array;
	}
	
	function return_serialized ($index) {
		return serialize($this->items[$index]);
	}
	
    function removeitem ($index) {
        if ($index < 0) return;
		unset($this->items[$index]);
	}
	
	function clearcart () {
		unset($this->items);
		$this->items = array();
	}
	
	function addoption ($item_index, $opt_id, $opt_value) {
		if ($item_index == '' && $item_index >= 0) return;
		$this->items[$item_index]->addoption($opt_id, $opt_value);
	}
	
	function removeoption ($item_index, $opt_index) {
		if ($item_index < 0) return;
		$this->items[$item_index]->removeoption($opt_index);
	}
	
	function updatequantity ($id, $quantity) {
		if ($quantity < 1) return;
		if (isset($this->items[$id])) $this->items[$id]->quantity = $quantity;
	}
	
	function pass_cart () {
		$cart = array();
		foreach ($this->items as $k => $v) {
	    	$iteminfo = get('products', $this->items[$k]->id);
			$iteminfo = calc_price($iteminfo, $this->items[$k]->quantity);
			$item = array();
			$item[items] 		= $this->items[$k]->id;
			$item[quantity] 	= $this->items[$k]->quantity;
			$item[title] 		= $iteminfo[title];
			$item[price] 		= $iteminfo[out_price]+$this->items[$k]->options_price_increase();
			$item[description]	= $iteminfo[short_desc];
			$item[data]			= $this->return_serialized($k);
			array_push($cart, $item);
		}
		return $cart;
	}
	
	function discount ($type="discounts") {
		global $DB_site, $dbprefix, $cart, $lang, $sess;
		$discount = array(); $discount[items] = array();
		$disc_used = array(); $coup_used = array();
		$results = $DB_site->query("SELECT * FROM `".$dbprefix.$type."` d WHERE 
			d.`status`='1' AND (d.`used`<d.`max` OR d.`max`='0') AND
			d.`vstart`<='".stamp()."' AND d.`vend`>='".stamp()."' AND
			d.`omin`<='".$this->subtotal()."'".(($type=='coupons')?" AND 
			d.`code`='".$cart->coupon."'":"").restrict('d'));
		while ($dis = $DB_site->fetch_assoc($results)) {
			$dis 		= filter_data($dis);
			$this_id	= $dis[id];
			$this_entry = $discount[items][$this_id];
			$this_type 	= ($type=='discounts')?'dtype':'ctype';
			switch ($dis[type]) {
				case 'U':
					$this_apply = 0;
					if (islogged()) {
						$relate = $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_relation` WHERE 
							`".substr($type, 0, -1)."id`='".$dis[id]."' AND `relationid`='".$sess->gvar('userid')."'
						");
						if ($relate[id] != "") $this_apply = 1;
					}
				case 'G':
					if ($this->product_count() >= $disc[pmin] && (($dis[type] == 'U' && $this_apply == 1) || $dis[type] == 'G')) {
						if (!is_array($this_entry)) $discount[items][$this_id] = array('name' => $dis[name], 'total' => ($dis[$this_type]=='A')?$dis[value]:(($dis[$this_type]=='P')?($this->subtotal()*($dis[value]/100)):$lang[free_ship]));
						elseif ($dis[$this_type] != 'S') $discount[items][$this_id][total] += ($dis[$this_type]=='A')?$dis[value]:($this->subtotal()*($dis[value]/100));
						if ($dis[$this_type] == 'S') $discount[free_shipping] = 1;
						else $discount[total] += ($dis[$this_type]=='A')?$dis[value]:($cart->subtotal()*($dis[value]/100));
					}
					break;
				case 'P':
				case 'C':
					$this_apply_total = 0;
					$this_apply_quant = 0;
					foreach ($this->items as $k => $v) {
						$this_apply = 0;
						if ($dis[type] == 'C') {
							$cats = $DB_site->query("SELECT p.`catid` FROM `".$dbprefix."products` p
								INNER JOIN (
									SELECT pc.`catid` AS cid
									FROM `".$dbprefix."products_categories` pc
									LEFT JOIN `".$dbprefix."categories` c ON c.`id`=pc.`catid` WHERE 
									pc.`productid`='".$this->items[$k]->id."'
									".restrict('c')."
									UNION SELECT `catid` AS cid
									FROM `".$dbprefix."products` pc
									WHERE pc.`id`='".$this->items[$k]->id."'
									".restrict('pc')."
								) prods ON prods.`cid`=p.`catid`
								GROUP by p.`catid`
							");
							while ($cdata = $DB_site->fetch_assoc($cats)) {
								$relate	= $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_relation` WHERE 
									`".substr($type, 0, -1)."id`='".$dis[id]."' AND `relationid`='".$cdata[catid]."'");
								if ($relate[id] != "") $this_apply = 1;
							}
						} else {
							$relate	= $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_relation` WHERE 
								`".substr($type, 0, -1)."id`='".$dis[id]."' AND `relationid`='".$this->items[$k]->id."'");
							if ($relate[id] != "") $this_apply = 1;
						}
						
						$this_apply_total += ($this_apply == 1)?$this->items[$k]->subtotal():0;
						$this_apply_quant += ($this_apply == 1)?$this->items[$k]->quantity:0;
					}
					
					if (p($this_apply_total) != p(0) && $this_apply_quant >= $dis[pmin] && p($this_apply_total, false) >= p($dis[omin], false)) {
						if (!is_array($this_entry)) $discount[items][$this_id] = array('name' => $dis[name], 'total' => ($dis[$this_type]=='A')?(($dis[dapply]=='A')?$dis[value]*$this_apply_quant:$dis[value]):(($dis[$this_type]=='P')?($this_apply_total*($dis[value]/100)):$lang[free_ship]));
						elseif ($dis[$this_type] != 'S') $discount[items][$this_id][total] += ($dis[$this_type]=='A')?(($dis[dapply]=='A')?$dis[value]*$this_apply_quant:$dis[value]):($this_apply_total*($dis[value]/100));
						if ($dis[$this_type] == 'S') $discount[free_shipping] = 1;
						else $discount[total] += ($dis[$this_type]=='A')?(($dis[dapply]=='A')?$dis[value]*$this_apply_quant:$dis[value]):($this_apply_total*($dis[value]/100));
					}
					break;
			}
			switch ($type) {
				case 'discounts':
					if (ceil($discount[total]) > 0) array_push($disc_used, $dis[id]);
					break;
				case 'coupons':
					if (ceil($discount[total]) > 0) array_push($coup_used, $dis[id]);
					break;
			}
		}
		switch ($type) {
			case 'discounts':
				$sess->dvar('disc_used');
				$sess->svar('disc_used', $disc_used);
				break;
			case 'coupons':
				$sess->dvar('coup_used');
				$sess->svar('coup_used', $coup_used);
				break;
		}
		return $discount;
	}
	
	function debug () {
		echo "<pre>";
		print_r($this);
		echo "</pre>";
	}
}
?>