<?PHP
/*
  global.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

define('SS_SESSION_START', '1');
define('COUNTRY', '1');
define('STATE', '2');
define('PROV', '3');
define('OUTSIDE', '4');
define('ZIPCODE', '5');

$abs_path = dirname(__FILE__);

////////////////////
// Load Secure Files
////////////////////

define('ABS_PATH', $abs_path);
require_once $abs_path."/libsecure.php";
if (!defined('ADMIN_DIR')) define('ADMIN_DIR', 'admin');

// Uncomment this line to disable strict SQL
// $DB_site->query("SET sql_mode='MYSQL40'");

/////////////////////
// Start Cart Session
/////////////////////

if (!$sess->gvar('cart')) {
	restorecart();
	if (!$sess->gvar('cart')) $sess->svar('cart', new cart());
	$rep->store_report(1, 1, 0, $_SERVER['REMOTE_ADDR']."-".$client->property('long_name')."-".$client->property('platform'));
	
	// Check For Referer
	$rhost = parse_url($settings[shopurl]); $shost = parse_url($settings[secureurl]);
	$location1 = @strpos(trim($_SERVER['HTTP_REFERER']), trim($rhost[host]));
	$location2 = @strpos(trim($_SERVER['HTTP_REFERER']), trim($shost[host]));
	if ($_SERVER['HTTP_REFERER'] != "" && $location1 === false && $location2 === false) {
		$rep->store_report(3, 1, 0, $_SERVER['HTTP_REFERER']);
	}
}

$cart = $sess->gvar('cart');
$cache_query = array();

// Clear Cart
if ($_GET['cc'] == 1) {
	$cart->items = array();
	savecart();
}

if ($_GET['SSSESS'] != "") set_transfered();

//////////////
// Set Secured
//////////////

$login_box['secure'] = (is_secure())?'true':'false';

/////////////////
// AJAX Functions
/////////////////

$run_ajax = array(
	'updateprice', 'wishlistadd', 'registryadd', 'accountupdate', 
	'check_payment', 'tell_friend', 'add_review', 'add_registry', 
	'edit_registry', 'update_registry', 'password_request', 
	'loading', 'reset_password', 'send_wishlist', 'contact_submit'
);

////////////////////
// Set Page Location
////////////////////

$location1 = @strpos(trim($_SERVER['PHP_SELF']), 'class.');
if (!in_array($_GET[l], $run_ajax) && $location1 === false) {
	$visiturl = $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].(($_SERVER['QUERY_STRING']!="")?"?".$_SERVER['QUERY_STRING']:"");
	$rep->store_report(2, 1, ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=="on")?1:0), $visiturl);
}

//////////////////
// Secure Redirect
//////////////////

function redirect ($page, $secure=true) {
	global $settings, $sess, $cart;
	if ($settings[secureurl] != $settings[shopurl]) {
		$data = (islogged())?'&USERIN='.base64_encode(tempcryptit($sess->gvar('USERIN'))).'&PASSIN='.$sess->gvar('PASSIN'):'';
		$session = '&'.$sess->name().'='.$sess->id();
	}
	header('location: '.(($secure)?$settings[secureurl]:$settings[shopurl]).$page.$session.$data);
	exit;
}

////////////////
// Perform Login
////////////////

function perform_login () {
	global $sess, $settings;
	if (authenticate($_POST[username], md5(desql($_POST[password])))) {
		lastvisit();
		if ($_POST[issecure] == 'true') redirect('index.php?p=previous', false);
		if (isset($_POST[pl]) && $settings[shopurl] != $settings[secureurl]) redirect('index.php?p='.$_POST[pl], false);
		else header("location: ".$settings[shopurl]."index.php".get_previous()); 
	} else {
		$sess->svar('login_error', 1);
		if (get_previous() == "") $location = $settings[shopurl].'index.php?l=previous';
		else $location = $settings[secureurl].get_previous();
		header("location: ".$location);
	}
	exit;
}

/////////////////
// Empty Redirect
/////////////////

function empty_redirect () {
	global $ae, $lang;
	$ae->new_error($lang['cart_view']['error_1']);
	header("location: ".$settings[shopurl]."index.php?l=cart_view");
	exit;
}

////////////
// Is Secure
////////////

function is_secure() {
	return ($_SERVER['SERVER_PORT'] == 443 || $_SERVER["HTTPS"] == "on" || $_SERVER["HTTPS"] == "1")?true:false;        
}

///////////////
// Check Secure
///////////////

function check_secure () {
	global $settings, $sess;
	$result = parse_url($settings[secureurl]);
	if ($result[scheme] == "https" && !is_secure()) {
		redirect('index.php?l=account'.(($_GET[tab]!="")?'&tab='.$_GET[tab]:''), true);
	}
}

//////////////////////////
// Shopping Cart Functions
//////////////////////////

// Check Restored Shopping Cart

function checkcart ($cart) {
	global $DB_site, $dbprefix, $settings;
	foreach ($cart->items as $k => $v) {
		$current_items[$k] = $v->id;
	}
	
	$items = @implode("' OR `id`='", $current_items);
	$item_result = $DB_site->query("SELECT `id` FROM `".$dbprefix."products` WHERE `id`='".$items."'");
	$valid_items = array('gs');
	while ($item = $DB_site->fetch_assoc($item_result)) {
		$valid_items[] = $item[id];
	}
	
	if (is_array($current_items)) {
		$invalid_items = @array_diff($current_items, $valid_items);
		foreach ($current_items as $k => $v) {
			if (in_array($v, $invalid_items)) $cart->removeItem($k);
		}
	}
	
	foreach ($cart->items as $k => $v) {
		if ($v->id == 'gs') continue;
		
		$current_options = array();
		foreach ($v->options as $x => $y) {
			$current_options[] = $y->id;
		}
		
		$options = implode("' OR `id`='", $current_options);
		$option_result = $DB_site->query("SELECT `id` FROM `".$dbprefix."products_options` WHERE (`id`='".$options."') AND `productid`='".$v->id."'");
		$valid_options = array();
		while ($option = $DB_site->fetch_assoc($option_result)) {
			$valid_options[] = $option[id];
		}
		$invalid_options = array_diff($current_options, $valid_options);
		foreach ($current_options as $x => $y) {
			if (in_array($y, $invalid_options)) $cart->removeOption($k, $y);
		}
	}
	return $cart;
}

// Restore Saved Shopping Cart

function restorecart ($passed_id="") {
	global $DB_site, $dbprefix, $settings, $_COOKIE, $sess;
	if (isset($_COOKIE['cartid']) || $passed_id != "") {
		$check = $DB_site->query("SELECT * FROM ".$dbprefix."users_saved_carts WHERE sessid='".addslashes((($passed_id!="")?$passed_id:$_COOKIE['cartid']))."'");
		if ($DB_site->num_rows($check) > 0) {
			$data = $DB_site->fetch_assoc($check);
			$cart = unserialize(base64_decode($data[cart]));
			$cart = checkcart($cart);
			$sess->svar('cart', $cart);
		}
	}
	return $cart;
}

// Item Has Options

function hasoptions ($id) {
	global $DB_site, $dbprefix;
	$result = $DB_site->query("SELECT * FROM `".$dbprefix."products_options` WHERE `productid`='$id' AND type<>'checkbox'");
	if ($DB_site->num_rows($result) > 0) return true;
	else return false;
}

// Pre Validate Item

function prevalidateitem ($id, $quantity, $options=array()) {
	global $DB_site, $dbprefix, $settings, $sess, $lang, $ae;
	$option_errors = array();
	$product = $DB_site->query_first("SELECT * FROM `".$dbprefix."products` p WHERE `id`='".$id."' ".restrict('p'));
	$product = filter_data($product);
	foreach($options as $k => $v) {
		$optionsd = $DB_site->query_first("SELECT oi.`optionid`, o.`name`, oi.`in_stock`, oi.`value` FROM `".$dbprefix."products_options_items` oi LEFT JOIN `".$dbprefix."products_options` o on oi.`optionid`=o.`id` WHERE oi.`id`='".addslashes($v)."'");
		if ($optionsd[in_stock] < $quantity && $settings[enforceoptionstock] == "Yes" && $optionsd[optionid] != "") {
			$ae->new_error($lang['cart_view']['currently'].' '.$optionsd[in_stock].' '.$lang['cart_view']['of'].' '.$optionsd[name].' "'.$optionsd[value].'" '.$lang['cart_view']['stock1']);
		}
	}
	
	// Other Checks
	if ($product[viewable] == 'n') { $ae->new_error($lang['cart_view']['notviewable']); }
	if ($product[in_stock] < $quantity && $settings[enforcestock] == "Yes") $ae->new_error($lang['cart_view']['notthatmany']);
	if ($product[id] == "") $ae->new_error($lang['cart_view']['invalidid']);
	
	return $ae->is_errors();
}

// Update Cart

function updatecart ($remove, $quantity) {
	global $DB_site, $dbprefix, $settings, $lang, $cart, $ae;
	if (is_array($remove)) {
		foreach ($remove as $k => $v) $cart->removeitem(intval($k));
	}
	
	if (is_array($quantity)) {
		foreach ($quantity as $k => $v) {
			$temp = explode(":", $k);
			$errors = $cart->revalidateitem($temp[0], $v);
			if (!$errors) $cart->updatequantity($temp[0], intval($v));
		}
	}
	if (isset($_POST['coupon']) && $_POST['coupon'] != "") {
		$results = $DB_site->query_first("SELECT * FROM `".$dbprefix."coupons` d WHERE 
			d.`status`='1' AND (d.`used`<d.`max` OR d.`max`='0') AND
			d.`vstart`<='".stamp()."' AND d.`vend`>='".stamp()."' AND
			d.`omin`<='".$cart->subtotal()."' AND 
			d.`code`='".desql($_POST['coupon'])."'".restrict('d')
		);
		
		if ($results[id] != "") {
			$cart->coupon = $_POST['coupon'];
			$ae->new_alert($lang['cart_view']['coupon'].$cart->coupon.$lang['cart_view']['coupadded']);
		} else {
			$ae->new_error($lang['cart_view']['coupon'].$_POST['coupon'].$lang['cart_view']['coupfailed']);
		}
	}
}

// Final Validation

function checkout_check () {
	global $settings, $lang, $cart, $ae;
	
	foreach ($cart->items as $k => $v) {
		if ($v->id == 'gs') continue;
		$errors = $cart->revalidateitem($k, $v->quantity);
		if ($errors) $redirect = 1;
	}
	
	if ($redirect == 1) {
		$ae->error_heading($lang['cart_view']['reval']);
		header('location: '.$settings[shopurl].'index.php?l=cart_view');
		exit;
	}
}

// Save Shopping Cart

function savecart () {
	global $DB_site, $dbprefix, $settings, $sess, $cart;
	$base64_cart = base64_encode(serialize($sess->gvar('cart')));
	$check = $DB_site->query_first("SELECT `sessid` FROM `".$dbprefix."users_saved_carts` WHERE `sessid`='".$sess->id()."'");
	
	if ($_COOKIE['cartid'] != $sess->id()) {
		setcookie('cartid', $sess->id(), (time()+60*60*24*30), '/', false);
	}
	
	if (count($cart->items)) {
		$DB_site->query(((isset($check[sessid]))?"UPDATE":"INSERT INTO")." `".$dbprefix."users_saved_carts` SET
			`sessid`='".$sess->id()."',
			`cart`='".$base64_cart."',
			`userid`='".$sess->gvar('userid')."',
			`stamp`=NOW()".
			((isset($check[sessid]))?" WHERE `sessid`='".$sess->id()."'":"")
		);
	} else {
		$DB_site->query("DELETE FROM `".$dbprefix."users_saved_carts` WHERE `sessid`='".$sess->id()."'");
	}
}

// Remove Saved Shopping Cart

function removecart () {
	global $DB_site, $dbprefix, $sess;
	$DB_site->query("DELETE FROM `".$dbprefix."users_saved_carts` WHERE `sessid`='".$sess->id()."'");
}

/////////////////
// Get Table Data
/////////////////

function get ($table, $id, $match='id', $append="") {
	global $DB_site, $dbprefix, $settings, $lang, $gs, $cache_query, $settings;
	$query = "SELECT * FROM `".$dbprefix.$table."` WHERE `".$match."`='".addslashes($id)."'";
	if ($cache_query[$query] != '') $result = $cache_query[$query];
	else { $result = $DB_site->query_first($query); $cache_query[$query] = $result; }
	if (is_array($result)) {
		$alter_tables = array('products', 'categories');
		$format_watch = array(" & "); $format_new = array(" &amp; ");
		foreach ($result as $key => $val) {
			$info[$append.$key] = (!in_array($table, $alter_tables))?stripslashes($val):str_replace($format_watch, $format_new, stripslashes($val));
		}
	}
	switch ($table) {
		case 'users':
			$check_array = array('_address1', '_address2', '_city', '_state', '_zip', '_country');
			foreach ($check_array as $value) $info['bill'.$value] = ($info['bill'.$value]=="")?$info['ship'.$value]:$info['bill'.$value];
			$area = get('state_country', $info[ship_country], 'type`=\''.COUNTRY.'\' AND `abb'); $info[area_id_1] = $area[id];
			$area = get('state_country', $info[ship_state], 'type`=\''.STATE.'\' AND `abb'); $info[area_id_2] = $area[id];
			$area = get('state_country', $info[ship_state], 'type`=\''.PROV.'\' AND `abb'); $info[area_id_3] = $area[id];
			$groupinfo = get('groups', $info[group_in], 'id', 'group_');
			$rewards = get('users_rewards', $info[id], 'userid', 'rewards_');
			$rewards[rewards_value] = p($rewards[rewards_total]*$settings[points_to_dollars]);
			$info = array_merge($info, $groupinfo, $rewards);
			break;
		case 'products';
			if ($id == 'gs' || $id == '0') return $gs->info();
			$convert = array('title', 'meta_title', 'meta_keywords', 'meta_description');
			foreach ($convert as $k => $v) $info[$v] = str_replace('"', '&quot;', $info[$v]);
			$empty = array('meta_title', 'meta_description');
			$alt = array('title', 'short_desc');
			foreach ($empty as $k => $v) if ($info[$v] == '') $info[$v] = $info[$alt[$k]];
			$info[num] = ($info[sku]!="")?$info[sku]:$info[id];
			$vendorinfo = get('vendors', $info[vendor], 'id', 'vendor_');
			$info = array_merge($info, $vendorinfo);
			break;
		case 'categories';
			$convert = array('title', 'meta_title', 'meta_keywords', 'meta_desc');
			foreach ($convert as $k => $v) $info[$v] = str_replace('"', '&quot;', $info[$v]);
			if (!is_numeric($id)) {
				$info[title] = $lang[categories][$id];
				$info[meta_title] = $lang[categories][$id];
				$info[id] = 0;
			}
			break;
		default;
			break;
	}
	return (is_array($info))?$info:array();
}

//////////////////
// Site Map Render
//////////////////

function sitemap_render ($subof=0) {
	global $DB_site, $dbprefix;
	$info = $DB_site->query("SELECT * FROM `".$dbprefix."categories` c WHERE `subof`='".$subof."' AND `viewable`='1' ".restrict('c'));
	if ($DB_site->num_rows($info) == 0) return;
	$site_map .= template('page_site_map_open.html', array());
	while ($row = $DB_site->fetch_assoc($info)) {
		$item = get('categories', $row[id]);
		$site_map .= template('page_site_map_item.html', array('item' => $item));
		$site_map .= sitemap_render($row[id]);
	}
	$site_map .= template('page_site_map_close.html', array());
	return $site_map;
}

///////////////
// Load Plugins
///////////////

function load_plugins ($cache) {
	global $DB_site, $dbprefix, $settings, $abs_path, $class_cache;
	foreach ($cache as $v) {
		@include_once($abs_path."/include/plugins/plugin_".$v.'.php');
		
		if (isset($CLASS_NAME)) $class_cache[$v] = $CLASS_NAME;
		else $CLASS_NAME = $class_cache[$v];
		
		$class_vars = module_vars($CLASS_NAME, 'plugins');
		if ($class_vars[enabled] == 1) {
			$obj = new $CLASS_NAME($class_vars);
			$plugin[$CLASS_NAME] = $obj->render();
		}
	}
	return $plugin;
}

/////////////
// Date Stamp
/////////////

function stamp () {
	return strtotime('now');
}

/////////////////
// Download Error
/////////////////

function download_error () {
	global $lang, $ae;
	$ae->new_error($lang['account']['download_err']);
	return array('account' => array('message' => $ae->display()));
}

/////////////////////////
// Product Has Downloads?
/////////////////////////

function has_downloads ($id) {
	global $DB_site, $dbprefix, $settings, $sess;
	$down = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_downloads` where `productid`='".$id."'");
	return ($down[id]!="")?true:false;
}

///////////////////
// Product Download
///////////////////

function download () {
	global $DB_site, $dbprefix, $settings, $sess;
	if (is_numeric($_GET[oid]) && is_numeric($_GET[id]) && is_numeric($_GET[pid])) {
		$userinfo = get('users', $sess->gvar('userid'));
		$order = get('orders', $_GET[oid]);
		
		if ($order[userid] == $userinfo[id]) {
			$prod = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$_GET[oid]."' AND `productid`='".$_GET[pid]."'");
			$down = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_downloads` where `productid`='".$prod[productid]."' AND id ='".$_GET[id]."' ORDER by `id`");
			$down = filter_data($down);
			if ($order[cc_status] == $settings[statusdownloads]) {
				$dhits = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_dl_count` where `productid`='".$prod[productid]."' and `orderid`='".$_GET[oid]."'");
				if ($dhits[hitcount] >= $settings[maxdownloads] && $settings[maxdownloads] != "") return download_error(); 
			} else {
				return download_error();
			}
			
			if ($dhits[id] == "") $DB_site->query("INSERT INTO `".$dbprefix."products_dl_count` set `productid`='".$prod[productid]."', `orderid`='".$_GET[oid]."', `hitcount`='1'");
			else $DB_site->query("UPDATE `".$dbprefix."products_dl_count` set `hitcount`='".($dhits[hitcount]+1)."' where `id`='".$dhits[id]."'");
			
			header("Cache-control: private");
			header("Content-type: application/octet-stream");
			header("Content-transfer-encoding: binary\n");
			header("Content-disposition: attachment; filename=\"".$down[filename]."\"");
			header("Content-Length: ".filesize($settings[pathtodownloads].$down[filename]));
			readfile($settings[pathtodownloads].$down[filename]);
			exit;
		}
	}
	return download_error(); 
}

////////////////////////
// Display User Wishlist
////////////////////////

function wishlist () {
	global $DB_site, $dbprefix, $settings, $lang, $sess;
	if ($_GET[uid] == '' && $sess->gvar('uid') != '') $_GET[uid] = $sess->gvar('uid');
	
	$query 		= "SELECT * FROM `".$dbprefix."users_wishlist` where `userid`='".$_GET[uid]."' AND `registryid`='0' AND `private_set`='0' order by `id`";
	$results	= $DB_site->query($query);
	$count	 	= $DB_site->num_rows($results);
	
	if ($count > 0) {
		if ($_GET[uid] != '') $sess->svar('uid', $_GET[uid]);
		$query_string	= preg_replace('/&amp;s\[.*\]=.*/', '', htmlentities($_SERVER["QUERY_STRING"]));
		$append			= preg_replace("/pg=([0-9]*)/", '', (($_GET[pg]=="")?'&amp;':"").$query_string.(($_GET[pg]=="")?'&amp;tab=4':""));
		$page			= new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[itemsperpage], $_GET[pg], $append);
		
		$list[pages] = $page->paginate('pg');
		$results = $DB_site->query($query.' LIMIT '.((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[itemsperpage]).','.$settings[itemsperpage]);
		while ($prod = $DB_site->fetch_assoc($results)) {
			$product = get('products', $prod[productid]);
			$product = calc_price($product, 1);
			$product = pre_display($product, 'thumb');
			$data	 = unserialize(base64_decode($prod[data]));
			if (is_array($data[options])) {
				foreach ($data[options] as $k => $v) {
					$option = option_data($v[opt_ids], $v[opt_val]);
					$product[options] .= template('misc_option_display.html', array('option' => $option));
					$product[options_hidden] .= '<input type="hidden" name="option['.$v[opt_ids].']" value="'.$v[opt_val].'" />';
					if (is_numeric(substr($product[price], 1))) $product[price] = p(substr($product[price], 1)+$option[price]);
				}
			}
			$list[products] .= template('page_user_wishlist_item.html', array('wishlist' => $prod, 'lang' => $lang['wishlist'], 'product' => $product, 'hide' => $product[hide]));
		}
		$list[products] = ($list[products]=="")?$lang['wishlist']['noitems']:$list[products];
		return $list;
	} else {
		header('location: '.$settings[shopurl]);
		exit;
	}
}

////////////////////////
// Display User Registry
////////////////////////

function registry () {
	global $DB_site, $dbprefix, $settings, $lang, $sess;
	if ($_GET[uid] == '' && $sess->gvar('uid') != '') $_GET[uid] = $sess->gvar('uid');
	$query 	= "SELECT *, uw.id as wid FROM `".$dbprefix."users_wishlist` uw LEFT JOIN `".$dbprefix."users_registry` ur on uw.`registryid`=ur.`id` where 
		ur.`userid`='".$_GET[uid]."' AND uw.`registryid`='".$_GET[id]."' AND `private_set`='0' order by ur.`id`";
	$results = $DB_site->query($query);
	$count	 = $DB_site->num_rows($results);
	
	if ($count > 0) {
		if ($_GET[uid] != '') $sess->svar('uid', $_GET[uid]);
		$query_string	= preg_replace('/&amp;s\[.*\]=.*/', '', htmlentities($_SERVER["QUERY_STRING"]));
		$append 		= preg_replace("/pg=([0-9]*)/", '', (($_GET[pg]=="")?'&amp;':"").$query_string.(($_GET[pg]=="")?'&amp;tab=4':""));
		$page 			= new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[itemsperpage], $_GET[pg], $append);
		
		$list[pages] = $page->paginate('pg');
		$results = $DB_site->query($query.' LIMIT '.((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[itemsperpage]).','.$settings[itemsperpage]);
		while ($prod = $DB_site->fetch_assoc($results)) {
			$prod = filter_data($prod);
			
			$product = get('products', $prod[productid]);
			$product = calc_price($product, 1);
			$product = pre_display($product, 'thumb');
			$data	 = unserialize(base64_decode($prod[data]));
			if (is_array($data[options])) {
				foreach ($data[options] as $k => $v) {
					$option = option_data($v[opt_ids], $v[opt_val]);
					$product[options] .= template('misc_option_display.html', array('option' => $option));
					$product[options_hidden] .= '<input type="hidden" name="option['.$v[opt_ids].']" value="'.$v[opt_val].'" />';
					if (is_numeric(substr($product[price], 1))) $product[price] = p(substr($product[price], 1)+$option[price]);
				}
			}
			$list[products]	   .= template('page_user_registry_item.html', array('registry' => $prod, 'lang' => $lang['wishlist'], 'product' => $product, 'hide' => $product[hide]));
			$list['date']		= $event['date'] = date($settings[datestamp], strtotime($prod[date]));
			$list[name] 		= $prod[name];
			$list[description] 	= $prod[description];
		}
		$list[products] = ($list[products]=="")?$lang['wishlist']['noitems']:$list[products];
		return $list;
	} else {
		header('location: '.$settings[shopurl]);
		exit;
	}
}

/////////////////
// Account Output
/////////////////

function account_output () {
	global $DB_site, $dbprefix, $settings, $lang, $sess, $ae;
	$userinfo = get('users', $sess->gvar('userid'));
	$hide = array();
	
	// Error Changes
	switch ($_GET[d]) {
		case 'deletewish':
			$DB_site->query("DELETE FROM `".$dbprefix."users_wishlist` WHERE `id`='".sanitize($_GET[id])."' AND `userid`='".$userinfo[id]."'");
			break;
		case 'defaultset':
			$DB_site->query("UPDATE `".$dbprefix."users_registry` set `default`='0' WHERE `userid`='".$userinfo[id]."'");
			$DB_site->query("UPDATE `".$dbprefix."users_registry` set `default`='1' WHERE `id`='".sanitize($_GET[id])."' AND `userid`='".$userinfo[id]."'");
			break;
		case 'deletereg':
			$DB_site->query("DELETE FROM `".$dbprefix."users_wishlist` WHERE `registryid`='".sanitize($_GET[id])."' AND `userid`='".$userinfo[id]."'");
			$DB_site->query("DELETE FROM `".$dbprefix."users_registry` WHERE `id`='".sanitize($_GET[id])."' AND `userid`='".$userinfo[id]."'");
			$ae->new_alert($lang['account']['reg_deleted']);
			break;
		case 'regadded':
			$ae->new_alert($lang['account']['reg_added']);
			break;
		case 'regupdated':
			$ae->new_alert($lang['account']['reg_updated']);
			break;
		case 'oinvalid':
			$ae->new_error($lang['account']['oinvalid']);
			break;
	}
	
	// Set Customer Info
	$userinfo['bill_state_list'] = getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.STATE.'\' OR type=\''.PROV.'\'', $userinfo[bill_state], 'type,name', 1);
	$userinfo['ship_state_list'] = getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.STATE.'\' OR type=\''.PROV.'\'', $userinfo[ship_state], 'type,name', 1);
	$userinfo['bill_country_list'] = getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.COUNTRY.'\'', ($userinfo[bill_country]=="")?$settings[country]:$userinfo[bill_country], 'name');
	$userinfo['ship_country_list'] = getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.COUNTRY.'\'', ($userinfo[ship_country]=="")?$settings[country]:$userinfo[ship_country], 'name');
	
	$userinfo[news_check]	= ($userinfo[newsletter]=="1")?'checked="checked"':'';
	$userinfo[required] 	= '<span class="required">*</span>';
	
	$custom[fields] 		= display_custom('users', true);
	if ($custom[fields] == "") array_push($hide, 'Custom Fields');
	if ($settings[rewards_points] != "Yes") array_push($hide, 'Rewards');
	
	$account[address]		= template('account_customer_information.html', array('custom' => $custom, 'userinfo' => $userinfo, 'hide' => $hide, 'lang' => $lang[account], 'message' => $message));
	
	// Set Order History
	$query 			= "SELECT * FROM `".$dbprefix."orders` where `userid`='".$userinfo[id]."' order by `order_stamp` desc";
	$results 		= $DB_site->query($query);
	$count	 		= $DB_site->num_rows($results);
	$query_string 	= preg_replace('/&amp;s\[.*\]=.*/', '', htmlentities($_SERVER["QUERY_STRING"]));
	$append 		= preg_replace("/opg=([0-9]*)/", '', (($_GET[opg]=="")?'&amp;':"").$query_string.(($_GET[opg]=="")?'&amp;tab=2':""));
	$page 			= new pager($query, template('list_pages_output.html', array(), 0), 5, 25, $_GET[opg], $append);
	
	$account[orders_paging] = $page->paginate('opg');
	$account[orders] = contentstart(array($lang['account']['onumber'], $lang['account']['odate'], $lang['account']['ostatus'], $lang['account']['pstatus'], $lang['account']['action']), array(), array("center","left","left","left","center"), 0, "100%");	
	$results = $DB_site->query($query.' LIMIT '.((($_GET[opg]==0)?0:$_GET[opg]-1)*25).',25');
	while ($row = $DB_site->fetch_assoc($results)) {
		$row = filter_data($row);
		$account[orders] .= content(array($row[id], date($settings[datestamp].' '.$settings[timestamp], $row[order_stamp]), $row[status], $row[cc_status], '<a href="index.php?l=account&amp;p=order&amp;id='.$row[id].'">'.$lang['account']['view'].'</a>'), array(), array("center","left","left","left","center"), '');
	}
	$account[orders] .= contentend();
	
	// Set Downloads
	$account[downloads] = contentstart(array($lang['account']['onumber'], $lang['account']['name'], $lang['account']['desc'], $lang['account']['status'], $lang['account']['action']), array(), array("center","left","left","center","center"), 0, "100%");
	$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders` where `userid`='".$userinfo[id]."' order by `order_stamp` desc");
	while ($row = $DB_site->fetch_assoc($results)) {
		$prods = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$row[id]."' ORDER by `id`");
		while ($prod = $DB_site->fetch_assoc($prods)) {
			$downs = $DB_site->query("SELECT * FROM `".$dbprefix."products_downloads` where `productid`='".$prod[productid]."' ORDER by `id`");
			while ($down = $DB_site->fetch_assoc($downs)) {
				$down = filter_data($down);
				if ($row[cc_status] == $settings[statusdownloads]) {
					$dhits = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_dl_count` where `productid`='".$prod[productid]."' and `orderid`='".$row[id]."'");
					if ($dhits[hitcount] >= $settings[maxdownloads] && $settings[maxdownloads] != "") { $status = $lang['account']['exp']; $action = $lang['account']['none']; }
					else { $status = $lang['account']['ready']; $action = '<a href="'.$settings[shopurl].'index.php?l=account&amp;p=download&amp;id='.$down[id].'&amp;oid='.$row[id].'&amp;pid='.$prod[productid].'">'.$lang['account']['down'].'</a>'; }
				} else {
					$status = $lang['account']['pend']; $action = $lang['account']['none'];
				}
				$account[downloads] .= content(array($row[id], $down[name], $down[description], $status, $action), array(), array("center","left","left","center","center"), '');
			}
		}
	}
	$account[downloads] .= contentend();
	
	// Set Wishlist Items
	$query 			= "SELECT * FROM `".$dbprefix."users_wishlist` where `userid`='".$userinfo[id]."' AND `registryid`='0' order by `id`";
	$results 		= $DB_site->query($query);
	$count	 		= $DB_site->num_rows($results);
	$query_string 	= preg_replace('/&amp;s\[.*\]=.*/', '', htmlentities($_SERVER["QUERY_STRING"]));
	$append 		= preg_replace("/wpg=([0-9]*)/", '', (($_GET[wpg]=="")?'&amp;':"").$query_string.(($_GET[wpg]=="")?'&amp;tab=4':""));
	$page 			= new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[itemsperpage], $_GET[wpg], $append);
	
	$account[wish_paging] = $page->paginate('wpg');
	$results = $DB_site->query($query.' LIMIT '.((($_GET[wpg]==0)?0:$_GET[wpg]-1)*$settings[itemsperpage]).','.$settings[itemsperpage]);
	while ($prod = $DB_site->fetch_assoc($results)) {
		$product = get('products', $prod[productid]);
		$product = calc_price($product, $prod[quantity]);
		$product = pre_display($product, 'thumb');
		$data	 = unserialize(base64_decode($prod[data]));
		if (is_array($data[options])) {
			foreach ($data[options] as $k => $v) {
				$option = option_data($v[opt_ids], $v[opt_val]);
				$product[options] .= template('misc_option_display.html', array('option' => $option));
				$product[options_hidden] .= '<input type="hidden" name="option['.$v[opt_ids].']" value="'.$v[opt_val].'" />';
				if (is_numeric(substr($product[price], 1))) $product[price] = p(substr($product[price], 1)+$option[price]);
			}
		}
		$wishlist = $prod;
		$list[products] .= template('account_wishlist_item.html', array('wishlist' => $wishlist, 'lang' => array_merge($lang['product_list'], $lang['wishlist']), 'product' => $product, 'hide' => $product[hide]));
	}
	$list[products] = ($list[products]=="")?$lang['account']['wish_empty']:$list[products];
	$account[wishlist] = template('list_products_list.html', array('list' => $list)).template('account_wishlist_send.html', array('lang' => $lang['account'], 'hide' => array(($settings[imageverify]!="Yes")?'Image Verification':'')));
	
	// Set Registry Items
	$results = $DB_site->query("SELECT * FROM `".$dbprefix."users_registry` where `userid`='".$userinfo[id]."' order by `default` DESC");
	while ($reg = $DB_site->fetch_assoc($results)) {
		if ($reg['default']!='1') $hide = array(); else $hide[] = 'Set Default';
		$reg['event_date'] = date($settings[datestamp], strtotime($reg['date']));
		$list[products] = template('account_registry_heading.html', array('registry' => $reg, 'lang' => $lang['account'], 'hide' => $hide));
		$results2 = $DB_site->query("SELECT * FROM `".$dbprefix."users_wishlist` where `userid`='".$userinfo[id]."' AND `registryid`='".$reg[id]."' order by `id`");
		while ($prod = $DB_site->fetch_assoc($results2)) {
			$product = get('products', $prod[productid]);
			$product = calc_price($product, $prod[quantity]);
			$product = pre_display($product, 'thumb');
			$data 	 = unserialize(base64_decode($prod[data]));
			if (is_array($data[options])) {
				foreach ($data[options] as $k => $v) {
					$option = option_data($v[opt_ids], $v[opt_val]);
					$product[options] .= template('misc_option_display.html', array('option' => $option));
					$product[options_hidden] .= '<input type="hidden" name="option['.$v[opt_ids].']" value="'.$v[opt_val].'" />';
					if (is_numeric(substr($product[price], 1))) $product[price] = p(substr($product[price], 1)+$option[price]);
				}
			}
			$wishlist[id]	 = $prod[id];
			$list[products] .= template('account_registry_item.html', array('wishlist' => $wishlist, 'registry' => $prod, 'lang' => array_merge($lang['product_list'], $lang['wishlist']), 'product' => $product, 'hide' => $product[hide]));
		}
		$account[registry] .= template('list_products_list.html', array('list' => $list));
	}
	$months = array ('01' => 'Jan','02' => 'Feb','03' => 'Mar','04' => 'Apr','05' => 'May','06' => 'Jun ','07' => 'Jul','08' => 'Aug','09' => 'Sep','10' => 'Oct','11' => 'Nov','12' => 'Dec');
	$days	= array(); for ($i=1; $i<=31; $i++) array_push($days, date('d', strtotime('1/'.$i.'/'.date("Y"))));
	foreach ($months as $k => $v) $month_options .= template('misc_option_select.html', array('option' => array('value' => $k, 'name' => $v)));
	foreach ($days as $k => $v) $day_options .= template('misc_option_select.html', array('option' => array('value' => $v, 'name' => $v)));
	$year_options = get_years();
	$account[registry] .= template('account_registry_add_edit.html', array('lang' => $lang['account'], 'month_options' => $month_options, 'day_options' => $day_options, 'year_options' => $year_options));
	
	$account[message] = $ae->display();
	
	$account[hide] = array();
	if ($settings[registry] != "Yes") array_push($account[hide], 'Registry');
	if ($settings[wishlist] != "Yes") array_push($account[hide], 'Wishlist');
	
	return array('account' => $account);
}

////////////
// Get Years
////////////

function get_years () {
	$years	= array(); 
	for ($i=date("Y"); $i<(date("Y")+10); $i++) array_push($years, $i);
	foreach ($years as $k => $v) $year_options .= template('misc_option_select.html', array('option' => array('value' => $v, 'name' => $v)));
	return $year_options;
}

///////////////////////////
// Order Information Output
///////////////////////////

function order_output () {
	global $DB_site, $dbprefix, $abs_path, $settings, $lang, $sess, $ae;
	$userinfo = get('users', $sess->gvar('userid'));
	$order = get('orders', $_GET[id]);
	
	include $abs_path.'/include/classes/class.shiptrack.php';
	
	// Errror Changes
	if ($order[userid] != $userinfo[id]) {
		header('location: index.php?l=account&d=oinvalid&tab=2'); exit;
	} else {
		switch ($_POST[d]) {
			case 'add_note':
				if ($_POST[note] != "") {
					$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".sanitize($_GET[id])."', `type`='C', `private`='0', `note`='".sf($_POST[note])."', `addedby`='".$userinfo[username]."', `datestamp`='".stamp()."'");
					$ae->new_alert($lang['account']['note_added']);
				} else {
					$ae->new_error($lang['account']['note_error']);
				}
				break;
		}
		
		foreach ($order as $k => $v) if ($v == "") $hide[] = $k;
		$order['date'] = date($settings[datestamp].' '.$settings[timestamp], $order[order_stamp]);
		
		// Order Details
		$order[items] = contentstart(array($lang['account']['id'], $lang['account']['name'], $lang['account']['uprice'], $lang['account']['quan'], $lang['account']['total']), array(), array("left","left","left","center","right"), "#536da7", "100%");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".sanitize($_GET[id])."' ORDER by `id`");
		while ($row = $DB_site->fetch_assoc($results)) {
			$row  = filter_data($row);
			$prod = unserialize(base64_decode($row[item]));
			$item = new orderitem($row[data]);
			$order[items] .= content(array(shortenit($prod[num], 10), '<u>'.shortenit($prod[title], 35).'</u><br />'.$item->display_options_client(), p($row[price]+$item->options_price_increase()), $item->get_quantity(), p(($row[price]+$item->options_price_increase())*$item->get_quantity())), array(), array("left","left","left","center","right"));
		}
		$vari = array('subtotal', 'discount', 'coupon_savings', 'ship_price', 'tax', 'gift_cert_savings', 'rewards_savings');
		foreach ($vari as $k => $v) $order[items] .= (p($order[$v])!=p('0'))?content(array('<strong>'.$lang['account'][$v].':</strong> ', '', '', '', (($k==1 || $k==2 || $k==5 || $k==6)?'-':'&nbsp;').p($order[$v])), array(), array("right","left","left","right","right"), "", "", array('4', 'skip', 'skip', 'skip', '1')):'';
		$order[items] .= content(array('<strong>'.$lang['account']['total'].':</strong> ', '', '', '', p($order[total])), array(), array("right","left","left","right","right"), "", "", array('4', 'skip', 'skip', 'skip', '1'));
		$order[items] .= contentend();
		
		// Order Notes
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_notes` where `orderid`='".sanitize($_GET[id])."' AND `private`='0' order by `datestamp`");
		$order[ncount] = $DB_site->num_rows($results);
		while ($row = $DB_site->fetch_assoc($results)) {
			$note = filter_data($row);
			$note[datetime]	= date($settings[datestamp].' '.$settings[timestamp], $note[datestamp]);
			$note[addedby]	= ($note[type]=="A")?$lang['account']['admin']:$lang['account']['customer'];
			$notes[notes]  .= template('account_add_order_note_item.html', array('note' => $note, 'lang' => $lang['account']));
		}
		$order[notes] = template('account_add_order_note.html', array('id' => $_GET[id], 'notes' => $notes, 'lang' => $lang['account']));
		
		// Shipping Details
		$track = new shiptrack();
		$sdetails = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders_tracking` where `orderid`='".sanitize($_GET[id])."'");
		$sdetails = filter_data($sdetails);
		$order[carrier]	 = ($sdetails[carrier]!="")?$sdetails[carrier]:$lang['account']['na'];
		$order[shipdate] = ($sdetails[datestamp]!="")?date($settings[datestamp].' '.$settings[timestamp], $sdetails[datestamp]):$lang['account']['na'];
		$order[tracking] = ($sdetails[number]!="")?$track->return_link($sdetails[carrier], $sdetails[number], $sdetails[number], "", "_TRACK", ""):$lang['account']['na'];
		
		$order[message] = $ae->display();
	}
	return array('order' => $order, 'account' => array('hide' => $hide));
}

//////////////////////
// Currency Conversion
//////////////////////

function getCurrency($dollar, $type) {
    global $DB_site, $dbprefix;
	$data = $DB_site->query_first("SELECT `rate` FROM `".$dbprefix."currency` WHERE `currency`='".$type."'");
	return p(($data[rate]*$dollar), false);
}

function parsePRICE ($txt) {
    global $settings, $sess;
	return preg_replace_callback("/".(($settings[cs_pos]=='before')?(($settings[cs]=='$')?'\\':'').$settings[cs]:'')."([0-9\.]*)".(($settings[cs_pos]=='after')?(($settings[cs]=='$')?'\\':'').$settings[cs]:'')."/",create_function('$match', 'return "$match[0] ('.$sess->gvar('my_rate').' ".getCurrency($match[1],'.$sess->gvar('my_rate').').")";'), $txt);
}

////////////////
// Currency List
////////////////

function currency_list () {
    global $DB_site, $dbprefix, $settings, $sess;
	$results = $DB_site->query("SELECT DISTINCT * FROM ".$dbprefix."currency order by currency");
	while ($row = $DB_site->fetch_assoc($results)) {
	    if ($sess->gvar('my_rate') == $row[currency]) $selected = 'selected="selected"';
		elseif ($row[currency] == $settings[defaultrate] && $sess->gvar('my_rate') == "") $selected = 'selected="selected"';
		else  $selected = '';
		$list .= template('misc_option_select.html', array('option' => array('selected' => $selected, 'name' => $row[name], 'value' => $row[currency])));
	}
	return $list;
}

/////////////////
// Check Required
/////////////////

function check_required ($vars) {
	$check = array ('bill_first_name', 'bill_last_name', 'phone', 'email', 'bill_address1', 'bill_city', 'bill_zip', 'bill_country');
	if ($vars[bill_oset] != 1) array_push($check, 'bill_state');
	if ($vars[store_info] == "store") array_push($check, 'username', 'password1', 'password2');
	if ($vars[same] != "copy") array_push($check, 'ship_first_name', 'ship_last_name', 'ship_address1', 'ship_city', 'ship_state', 'ship_zip', 'ship_country');
	if ($vars[ship_oset] != 1) array_push($check, 'ship_state');
	
	foreach ($check as $k => $v) {
		if ($vars[$v] == "") return false;
	}
	return true;
}

//////////////
// Check Email
//////////////

function check_email ($email) {
	global $DB_site, $dbprefix, $userinfo;
	$result	= $DB_site->query_first("SELECT * FROM ".$dbprefix."users WHERE `email` = '".$email."'");
	if ($result[id] != "" && $userinfo[id] != $result[id]) return false;
	return true;
}

////////////////////
// Update Last Visit
////////////////////

function lastvisit () {
	global $DB_site, $dbprefix, $sess;
	$DB_site->query("UPDATE ".$dbprefix."users set lastvisit='".stamp()."' WHERE `id`='".$sess->gvar('userid')."'");
}

////////////////
// Check Account
////////////////

function check_account ($vars, $force_email=0, $force_create=0) {
	global $DB_site, $settings, $dbprefix, $sess, $lang, $ae, $lang;
	
	// Errror Changes
	if (!is_array($vars)) return;
	if (!check_required($vars) && $force_create==0) $ae->new_error($lang['account']['required']);
	
	check_custom('users', true);
	
	foreach ($vars as $k => $v) $vars[$k] = strip_tags($v);
        
	if ($vars['ship_oset'] == '1') $vars['ship_state'] = ''; else $vars['ship_other'] = '';
	if ($vars['bill_oset'] == '1') $vars['bill_state'] = ''; else $vars['bill_other'] = '';
	
	if ($vars[store_info] == "store") {
		$result = $DB_site->query("SELECT * FROM `".$dbprefix."users` WHERE `username`='".sanitize($vars[username])."'");
		$rows = $DB_site->num_rows($result);
		if ($rows > 0) $ae->new_error($lang['account']['username_exists']);
		
		if (!check_email($vars[email]) && $force_email != 1) $ae->new_error($lang['account']['email_exists2']);
		if (!check_email_address($vars[email]) && $force_email != 1) $ae->new_error($lang['account']['email_fail']);
		if ($vars[newsletter] != "1") $vars[newsletter] = 0;
		if ($vars[password1] != $vars[password2]) $ae->new_error($lang['account']['pass_match']);
		else $vars[password] = $vars[password1];
		
		if (!$ae->is_errors()) {
			if ($vars[same] == "copy") {
				$same_array = array('first_name', 'last_name', 'company_name', 'address1', 'address2', 'city', 'state', 'other', 'zip', 'country');
				foreach ($same_array as $k => $v) $vars['ship_'.$v] = $vars['bill_'.$v];
			}
			
			// Filter Email Data
			$vars[username_orig] = substr($vars[username], 0, 25);
			$vars[password_orig] = substr($vars[password], 0, 15);
			
			$query  = "INSERT INTO `".$dbprefix."users` set";
			$result = $DB_site->query("DESCRIBE `".$dbprefix."users`");
			while ($field = $DB_site->fetch_assoc($result)) {
				if ($field['Field'] == 'password') $vars[password] = md5($vars[password]);
				if (isset($vars[$field['Field']])) $query .= " `".$field['Field']."`='".sf($vars[$field['Field']])."',";
			}
			$query .= " `group_in`='".$settings[defaultgroup]."'";
			$DB_site->query($query);
			$myid = $DB_site->insert_id();
			
			custom_store('users', 'userid', $myid);
			
			$email = template('email_signup_welcome.html', array('info' => $vars));
			mail_send($vars[email], $vars[bill_first_name].' '.$vars[bill_last_name], $lang['account']['signup_subject'], $email, $settings[contactemail], $settings[title], true);
			
			authenticate($vars[username], $vars[password]); lastvisit();
			$unset = array('same', 'store_info', 'password1', 'password2');
			foreach ($unset as $k => $v) unset($vars[$v]);
		}
	} else {
		if (!$ae->is_errors()) {
			if ($vars[same] == "copy") {
				$same_array = array('first_name', 'last_name', 'company_name', 'address1', 'address2', 'city', 'state', 'other', 'zip', 'country');
				foreach ($same_array as $k => $v) $vars['ship_'.$v] = $vars['bill_'.$v];
			}
		}
	}
        
	if (islogged()) {
		$userinfo = get('users', $sess->gvar('userid'));
		$unset = array('id', 'username', 'password');
		foreach ($unset as $k => $v) unset($userinfo[$v]);
		$vars = array_merge($userinfo, $vars);
	}
	
	$vars[bill_state_display] = ereg_replace("[^A-Za-z]", "", $vars[bill_state]);
	$vars[ship_state_display] = ereg_replace("[^A-Za-z]", "", $vars[ship_state]);
	
	$sess->dvar('userinfo');
	$sess->svar('userinfo', $vars);
	
	return $ae->is_errors();
}

/////////////////
// Account Signup
/////////////////

function account_signup () {
	global $settings, $lang, $sess, $ae;
	if ($_POST['do'] == "create") {	
		check_account($_POST[userinfo]);
		if (!$ae->is_errors()) $ae->new_alert($lang['account']['stored']);
	}
	
	$hide = array();
	if ($sess->gvar('login_error') == 1) { $sess->dvar('login_error'); $ae->new_error($lang['account']['pass_error']); }
	
	if (is_array($sess->gvar('userinfo'))) $userinfo = $sess->gvar('userinfo');
	$userinfo['bill_state_list'] = getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.STATE.'\' OR type=\''.PROV.'\'', ($userinfo[bill_state]=="")?$settings[state]:$userinfo[bill_state], 'type,name');
	$userinfo['ship_state_list'] = getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.STATE.'\' OR type=\''.PROV.'\'', ($userinfo[ship_state]=="")?$settings[state]:$userinfo[ship_state], 'type,name');
	$userinfo['bill_country_list'] = getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.COUNTRY.'\'', ($userinfo[bill_country]=="")?$settings[country]:$userinfo[bill_country], 'name');
	$userinfo['ship_country_list'] = getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.COUNTRY.'\'', ($userinfo[ship_country]=="")?$settings[country]:$userinfo[ship_country], 'name');
	
	$userinfo[news_check]	= ($userinfo[newsletter]=="1")?'checked="checked"':'';
	$userinfo[same_check]	= ($userinfo[same]=="copy")?'checked="checked"':'';
	$userinfo[required]		= '<span class="required">*</span>';
	
	if ($_POST['do'] == "create" && !$ae->is_errors()) {
		$sess->dvar('userinfo');
		return $ae->display().template('page_message_output.html', array('page' => array('message' => $lang['account']['signup_mess'], 'heading' => $lang['account']['signup_head']), 'lang' => $lang[account]));
	} else {
		$custom[fields] = display_custom('users');
		if ($custom[fields] == "") array_push($hide, 'Custom Fields');
		return template('account_customer_signup.html', array('custom' => $custom, 'userinfo' => $userinfo, 'hide' => $hide, 'lang' => $lang[account], 'message' => array('error' => $ae->display())));
	}
}

////////////////////
// Parse Option Data
////////////////////

function option_data ($id, $value) {
	$op_data	= get('products_options', $id);
	$single		= ($op_data[type]=="select" || $op_data[type]=="radio" || $op_data[type]=="checkbox")?true:false;
	$selected	= ($single)?get('products_options_items', $value):"";
	$selected	= calc_option_price($selected);
        
	$data[id]		= $op_data[id];
	$data[product]	= $op_data[productid];
	$data[name]		= $op_data[name];
	$data[value]	= ($single)?$selected[value]:strip_tags($value);
	$data[valueid]	= ($single)?$value:'';
	$data[weight]	= ($single)?$selected[weight]:'';
	$data[sku]		= ($single)?$selected[sku]:'';
	$data[price]	= ($single)?($selected[mod].$selected[price]):'';
	$data[desc]		= $op_data[description];
	$data[type]		= $op_data[type];
	return $data;
}

///////////////////
// Options To Array
///////////////////

function options_to_array () {
	$data = array();
	foreach ($_POST[options] as $k => $v) {
		array_push($data, option_data ($k, $v));
	}
	return $data;
}

////////////////////
// Evaluate Template
////////////////////

function template ($file, $vars=array(), $eval=1) {
	global $lang_client, $settings, $abs_path, $plugin_cache;
	
	ob_start();
   	if (@include $abs_path."/themes/".$settings[theme]."/".$file) $contents = ob_get_contents();
	else $contents = 'Unable to open template file "'.$file.'"';
   	ob_end_clean();
	
	if (!is_array($plugin_cache[$file])) { 
		preg_match_all("/plugin\[(.*)\]/i", $contents, $temp);
		$plugin_cache[$file] = $temp[1];
	}
	
	$plugin = load_plugins($plugin_cache[$file]);
	
	foreach ($vars as $key => $val) ${$key} = $val;
	
	for ($i=0; $i<count($hide); $i++) {
		if (!$contents = @preg_replace('/(.*)(<!--\/\/ Start Hide '.$hide[$i].' \/\/-->)(.*)(<!--\/\/ End Hide '.$hide[$i].' \/\/-->)(.*)/sim', '\1\5', $contents)) {
			$contents = ($hide[$i]!='')?str_replace("Start Hide ".$hide[$i]." //-->", "", $contents):$contents;
			$contents = ($hide[$i]!='')?str_replace("<!--// End Hide ".$hide[$i], "", $contents):$contents;
		}
	}
	
	if ($eval == 1) {
		if (!@eval("return \$out = \"".addslashes($contents)."\";")) $out = "Error parsing template $file";
	}
	
	else $out = $contents;
	
	return stripslashes(stripslashes($out));
}

/////////////
// XML Output
/////////////

function xml_doc ($file, $vars=array(), $noheader=0) {
	global $lang, $abs_path, $settings;
	ob_start();
   	if (@include $abs_path."/".$file) $contents = ob_get_contents();
   	ob_end_clean();
	if (!$contents = @preg_replace('/(.*)(<!--\/\/ Start Hide '.$vars[hide].' \/\/-->)(.*)(<!--\/\/ End Hide '.$vars[hide].' \/\/-->)(.*)/sim', '\1\5', $contents)) {
		$contents = ($vars[hide]!='')?str_replace("Start Hide ".$vars[hide]." //-->", "", $contents):$contents;
		$contents = ($vars[hide]!='')?str_replace("<!--// End Hide ".$vars[hide], "", $contents):$contents;
	}
	@eval("\$out = \"".addslashes((($noheader==1)?'<?xml version="1.0" encoding="UTF-8"?>':'').$contents)."\";");
   	return stripslashes(stripslashes($out));
}

//////////////////
// Show Categories
//////////////////

function showcategories () {
    global $DB_site, $dbprefix, $settings, $lang, $sess, $subarr;
	
	$areas 	= array("new", "specials", "featured", "bestsellers");
	$set 	= array("newcat", "speccat", "featcat", "bestcat");
	$add	= array("is_new='y'", "`sale_price`<>'".p(0)."'", "`is_featured`='y'", "`id`<>''");
	
	for ($i=0; $i<count($areas); $i++) {
		if ($settings[$set[$i]] == "Yes") {
			if ($settings[showcattotals] == "Yes") {
				$query = "SELECT * FROM `".$dbprefix."products` as p WHERE p.`viewable`='y' AND ".$add[$i]." ".restrict('p').(($i==3)?" LIMIT ".$settings[itemsperpage]:"");
				$result = $DB_site->query($query);
				$total = $DB_site->num_rows($result);
			}
			
		    $category[id] 		= $areas[$i];
			$category[title] 	= $lang['categories'][$areas[$i]];
			$category[total] 	= $total;
			$out .= template('table_categories_item.html', array('category' => $category, 'lang' => $lang['categories'], 'hide' => array('0' => (($settings[showcattotals]!="Yes")?'Totals':''))));
		}
	}
	
	$results = $DB_site->query("SELECT `id` FROM `".$dbprefix."categories` as c WHERE `viewable`='1' AND `subof`='0' ".restrict('c')." ORDER BY `dorder`");
	while ($row = $DB_site->fetch_assoc($results)) {
		$category = get('categories', $row[id]);
		if ($settings[showcattotals] == "Yes") {
			$subarr = array();
			subcats($row[id]);
			array_push($subarr, $row[id]);
			
			$query = "SELECT p.`id` FROM `".$dbprefix."products` p
				INNER JOIN (
					SELECT p.`id` AS pid
					FROM `".$dbprefix."products` p
					LEFT JOIN `".$dbprefix."categories` c ON c.`id`=p.`catid`
					WHERE (p.`catid` IN (".implode(",", $subarr)."))
					".restrict('c')."
					UNION SELECT `productid` AS pid
					FROM `".$dbprefix."products_categories` pc
					LEFT JOIN `".$dbprefix."categories` c ON c.`id`=pc.`catid`
					WHERE (pc.`catid` IN (".implode(",", $subarr)."))
					".restrict('c')."
				) prods ON prods.`pid`=p.`id`
				WHERE p.`viewable`='y'
				".restrict('p');
			
			$result = $DB_site->query($query);
			$category[total] = $DB_site->num_rows($result);
		}
		$out .= template('table_categories_item.html', array('category' => $category, 'lang' => $lang['categories'], 'hide' => array('0' => (($settings[showcattotals]!="Yes")?'Totals':''))));
	}
	
	$subarr = array();
	return $out;
}

///////////////
// Authenticate
///////////////

function authenticate ($login, $password, $type=0) {
    global $DB_site, $dbprefix, $sess, $cache_query;
	$query = "SELECT id FROM `".$dbprefix."users` WHERE `username`='".desql($login)."' AND `password`='".desql($password)."';";
	if ($cache_query[$query] != '') $result = $cache_query[$query];
	else { $result = $DB_site->query_first($query); $cache_query[$query] = $result; }
	if (isset($result[id])) {
	    if ($type != 1) {
			$sess->dvar('userid'); $sess->svar('userid', $result[id]);
			$sess->dvar('USERIN'); $sess->svar('USERIN', $login);
			$sess->dvar('PASSIN'); $sess->svar('PASSIN', $password);
		}
		return true;
	} else 
		return false;
}

////////////
// Rate Sort
////////////

function ratesort ($a, $b) {
	return $a > $b;
}

///////////////
// Get Shipping
///////////////

function get_shipping ($weight="", $subtotal="") {
	global $settings, $DB_site, $dbprefix, $cart, $ups_output, $discounts, $coupon, $sess;
	$userinfo = $sess->gvar('userinfo');
	
	foreach ($cart->items as $i => $v) {
		$iteminfo = get('products', $cart->items[$i]->id);
		if ($iteminfo[charge_shipping] == "y") $continue = 1;
	}
	
	if ($continue != 1 && $weight == "") {
		$shipping[method] 	= "fixed";
		$shipping[rates] 	= '0.00';
		return $shipping;
	}
	
	$weight		= ($weight=="")?$cart->weight():$weight;
	$subtotal	= ($subtotal=="")?$cart->subtotal(3):$subtotal;
	
	// Realtime Shipping Rates
	if ($settings[shipmethod] == "realtime") {
		$shipping 			= run_shipping($weight);
		$shipping[method]	= 'realtime';
		
		if (is_array($shipping[options])) {
			asort($shipping[options]);
			while (list ($k, $v) = each ($shipping[options]))
				$shipping[values] .= template('misc_option_select.html', array('option' => array('value' => $k.'-> '.$v, 'name' => '('.p($v).') - '.$k)));
		}
	}
	
	// Ship Table Shipping Rates
	elseif ($settings[shipmethod] == "shiptable") {
		$shipping[method] = 'shiptable';
		$area_c = get('state_country', $userinfo[ship_country], 'type`=\''.COUNTRY.'\' AND `abb');
		$area_s = get('state_country', $userinfo[ship_state], 'type`=\''.STATE.'\' AND `abb');
		$area_p = get('state_country', $userinfo[ship_state], 'type`=\''.PROV.'\' AND `abb');
		$userinfo[area_id_1] = ($userinfo[area_id_1]=="")?$area_c[id]:$userinfo[area_id_1];
		$userinfo[area_id_2] = ($userinfo[area_id_2]=="")?$area_s[id]:$userinfo[area_id_2];
		$userinfo[area_id_3] = ($userinfo[area_id_3]=="")?$area_p[id]:$userinfo[area_id_3];
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."ship_table` st 
			LEFT JOIN `".$dbprefix."ship_zones_relation` szr on szr.`zoneid`=st.`zoneid`
			where (szr.`areaid`='".$userinfo[area_id_1]."' 
			OR szr.`areaid`='".$userinfo[area_id_2]."' 
			OR szr.`areaid`='".$userinfo[area_id_3]."') order by st.`id`");
		while ($row=$DB_site->fetch_assoc($results)) {
				if ($settings[tableset] == "price") $compare = $subtotal; else $compare = $weight;
				if ($compare >= $row[from_value] && $compare <= $row[to_value])
				$shipping[rates] = ($row[price] + $settings[handling]);
		}
		
		$shipping[rates] = ($discounts[free_shipping]==1 || $coupon[free_shipping]==1)?p(0, false):p($shipping[rates], false);
	}
	
	// Fixed Shipping Rates
	elseif ($settings[shipmethod] == "fixed") {
	    $shipping[method] = "fixed";
		if ($settings[method] == "perorder")
			$shipping[rates] = $settings[rate] + $settings[handling];
		
		elseif ($settings[method] == "perpound") {
			$rate = ($weight * $settings[rate]);
			$shipping[rates] = $rate + $settings[handling];
		}
		
		elseif ($settings[method] == "peritem") {
			$rate = ($cart->product_count() * $settings[rate]);
			$shipping[rates] = $rate + $settings[handling];
		}
		
		elseif ($settings[method] == "percentage") {
			$rate = ($subtotal * ($settings[rate] / 100));
			$shipping[rates] = $rate + $settings[handling];
		}
		
		$shipping[rates] = ($discounts[free_shipping]==1 || $coupon[free_shipping]==1)?p(0, false):p($shipping[rates], false);
	}
	
	// Product Defined Shipping Rates
	elseif ($settings[shipmethod] == "set") {
		$shipping[method] = "set";
		foreach ($cart->items as $i => $v) {
			$iteminfo = get('products', $cart->items[$i]->id);
			if ($iteminfo[charge_shipping] == "y") {
				$total += ($iteminfo[flat_rate_shipping] * $cart->items[$i]->quantity);
			}
		}
		$shipping[rates] = $total + $settings[handling];
		$shipping[rates] = ($discounts[free_shipping]==1 || $coupon[free_shipping]==1)?p(0, false):p($shipping[rates], false);
	}
	
	if ($shipping[method] != 'realtime') {
		$new_rate = ($discounts[free_shipping]==1 || $coupon[free_shipping]==1)?p(0, false):$shipping[rates];
		$shipping[values] = template('misc_option_select.html', array('option' => array('value' => 'Standard Shipping -> '.$new_rate, 'name' => '('.p($new_rate).') - Standard Shipping')));
		if (p($settings[expedited]) != p(0))
			$shipping[values] .= template('misc_option_select.html', array('option' => array('value' => 'Expedited Standard Shipping -> '.($shipping[rates]+$settings[expedited]), 'name' => '('.p($shipping[rates]+$settings[expedited]).') - Expedited Standard Shipping')));
	}
	
	return $shipping;
}

//////////////////
// Create Packages
//////////////////

function create_packages ($mode=0) {
	global $DB_site, $dbprefix, $cart, $settings;
	switch ($mode) {
		case '0':
			foreach ($cart->items as $i => $v) {
				$iteminfo 	= get('products', $cart->items[$i]->id);
				if ($iteminfo[charge_shipping] == "y") {
					$quanleft 	= $cart->items[$i]->quantity;
					$maxperbox 	= ($iteminfo[max_per_box]!=0)?$iteminfo[max_per_box]:1;
					$addweight 	= $cart->items[$i]->options_weight_increase();
					while ($quanleft > 0) {
						$quan 		= ($quanleft < $maxperbox)?$quanleft:$maxperbox;
						$quanleft	= ($quanleft - $quan);
						$pack[weights][]	= (($iteminfo[weight] + $addweight) * $quan);
						$pack[lengths][]	= ($iteminfo[ship_seperatly]=="y")?$iteminfo[box_length]:$settings[avg_length];
						$pack[widths][]		= ($iteminfo[ship_seperatly]=="y")?$iteminfo[box_width]:$settings[avg_width];
						$pack[heights][]	= ($iteminfo[ship_seperatly]=="y")?$iteminfo[box_height]:$settings[avg_height];
					}
				}
			}
			break;
		case '1':
			$tot_weight = 0;
			foreach ($cart->items as $i => $v) {
				$iteminfo 	= get('products', $cart->items[$i]->id);
				if ($iteminfo[charge_shipping] == "y") {
					$quanleft 	= $cart->items[$i]->quantity;
					$maxperbox 	= ($iteminfo[max_per_box]!=0)?$iteminfo[max_per_box]:1;
					$addweight 	= $cart->items[$i]->options_weight_increase();
					if ($iteminfo[ship_seperatly] == "y") {
						while ($quanleft > 0) {
						    $quan 		= ($quanleft < $maxperbox)?$quanleft:$maxperbox;
							$quanleft	= ($quanleft - $quan);
							$pack[weights][]	= (($iteminfo[weight] + $addweight) * $quan);
							$pack[lengths][]	= ($iteminfo[ship_seperatly]=="y")?$iteminfo[box_length]:$settings[avg_length];
							$pack[widths][]		= ($iteminfo[ship_seperatly]=="y")?$iteminfo[box_width]:$settings[avg_width];
							$pack[heights][]	= ($iteminfo[ship_seperatly]=="y")?$iteminfo[box_height]:$settings[avg_height];
						}
					} else $tot_weight = ($tot_weight + (($iteminfo[weight] + $addweight) * $quanleft));
				}
			}
			if ($tot_weight != 0) {
				$pack[weights][]	= $tot_weight;
				$pack[lengths][]	= $settings[avg_length];
				$pack[widths][]		= $settings[avg_width];
				$pack[heights][]	= $settings[avg_height];
			}
			break;
		case '2':
			foreach ($cart->items as $i => $v) {
				$iteminfo 	= get('products', $cart->items[$i]->id);
				if ($iteminfo[charge_shipping] == "y") {
					$addweight 	= $cart->items[$i]->options_weight_increase();
					$quanleft 	= $cart->items[$i]->quantity;
					$account	= str_replace(" ", "", $iteminfo[vendor_account_num]);
					if ($iteminfo[vendor_dropship] == 1) {
						$pack[vendor][$account][zip]		= $iteminfo[vendor_zip];
						$pack[vendor][$account][city]		= $iteminfo[vendor_city];
						$pack[vendor][$account][state]		= substr($iteminfo[vendor_state],0,2);
						$pack[vendor][$account][country]	= $iteminfo[vendor_country];
						$pack[vendor][$account][lengths]	= ($iteminfo[ship_seperatly]=="y")?$iteminfo[box_length]:$settings[avg_length];
						$pack[vendor][$account][widths]		= ($iteminfo[ship_seperatly]=="y")?$iteminfo[box_width]:$settings[avg_width];
						$pack[vendor][$account][heights]	= ($iteminfo[ship_seperatly]=="y")?$iteminfo[box_height]:$settings[avg_height];
						$pack[vendor][$account][weights]	+= (($iteminfo[weight] + $addweight) * $quanleft);
					} else {
						$tot_weight = ($tot_weight + (($iteminfo[weight] + $addweight) * $quanleft));
					}
				}
			}
			if ($tot_weight != 0) {
				$pack[vendor]["0_0"][weights]	= $tot_weight;
				$pack[vendor]["0_0"][lengths]	= $settings[avg_length];
				$pack[vendor]["0_0"][widths]	= $settings[avg_width];
				$pack[vendor]["0_0"][heights]	= $settings[avg_height];
			}
			break;
	}
	
	//debug($pack);
	
	return $pack;
}

///////////////
// Run Shipping
///////////////

function run_shipping ($totalweight) {
	global $DB_site, $dbprefix, $abs_path, $settings, $cconnect, $ups_output, $sess, $ae, $lang;
	$userinfo = $sess->gvar('userinfo');
	$results = array();
	
	require_once $abs_path."/include/classes/class.connect.php";
	$cconnect = new curl_connect();
	
	if ($settings[dropshipon] == "1") $packages = create_packages(2);
	else $packages = create_packages($settings[shiptogether]);
	
	$modules = modules('shipping');
	for ($i=0; $i<count($modules); $i++) {
		if ($modules[$i][installed] == 1 && $modules[$i][enabled] == 1) {
			$CLASS_NAME = $modules[$i][class_name];
			$ADDON_NAME = $modules[$i][module_name];
			
			$class_vars = module_vars($CLASS_NAME, 'shipping');
			
			switch ($settings[dropshipon]) {
				case 1:
					foreach ($packages[vendor] as $key => $val) {
						$calc = new $CLASS_NAME($class_vars);
						$calc->start();
						$vendor = $packages[vendor][$key];
						
						$calc->setaddress (
							$vendor[city], substr($vendor[state], 0, 2), $vendor[zip], $vendor[country], 
							$userinfo[ship_city], (($userinfo[ship_country]=="US")?substr($userinfo[ship_state], 0, 2):$userinfo[ship_state]), (($userinfo[ship_country]=="US")?substr($userinfo[ship_zip], 0, 5):$userinfo[ship_zip]), $userinfo[ship_country]
						);
						$calc->add_package($vendor[weights], $vendor[lengths], $vendor[widths], $vendor[heights]);
						$calc->end_all();
						$thisone = $calc->process();
						
						if (is_array($result[$ADDON_NAME])) {
							foreach ($thisone as $k => $v) {
								if ($result[$ADDON_NAME][$j][method] == $v[method]) $result[$ADDON_NAME][$j][rate] += $v[rate];
							}
						} else $result[$ADDON_NAME] = $thisone;
					}
					break;
				case 0:
					$calc = new $CLASS_NAME($class_vars);
					$calc->start();
					$calc->setaddress (
						$settings[city], substr($settings[state], 0, 2), $settings[zip], $settings[country], 
						$userinfo[ship_city], (($userinfo[ship_country]=="US")?substr($userinfo[ship_state], 0, 2):$userinfo[ship_state]), (($userinfo[ship_country]=="US")?substr($userinfo[ship_zip], 0, 5):$userinfo[ship_zip]), $userinfo[ship_country]
					);
					
					if ($class_vars[multi_support] != 1) {
						$calc->add_package($totalweight, $settings[avg_length], $settings[avg_width], $settings[avg_height]);
					} else {
						for ($s=0; $s<count($packages[weights]); $s++) {
							$calc->add_package($packages[weights][$s], $packages[lengths][$s], $packages[widths][$s], $packages[heights][$s], $pack[vendor][$s]);
						}
					}
					
					$calc->end_all();
					$result[$ADDON_NAME] = $calc->process();
					break;
			}
			
			$results = array_merge($results, $result);
		}
		
		if (is_array($results[$ADDON_NAME])) {
			$return[errors][$ADDON_NAME] = array();
			foreach ($results[$ADDON_NAME] as $k => $v) {
				if ($v[statuscode] != 0 && $v[statuscode] != 202) {
					$return[options]['['.$ADDON_NAME.'] '.$v[method]] = ($v[rate] + $settings[handling]); $return[atleastone] = 1;
				} else {
					$error_out = (($v[errorcode]!="")?$v[errorcode].": ":"").$v[error];
					if (!in_array($error_out, $return[errors][$ADDON_NAME]))
						$return[errors][$ADDON_NAME][] = $error_out;
				}
			}
		}
	}
	
	if ($return[atleastone] != 1) {
		for ($i=0; $i<count($modules); $i++) {
			if ($modules[$i][installed] == 1 && $modules[$i][enabled] == 1) {
				$ADDON_NAME = $modules[$i][module_name];
				if (is_array($return[errors][$ADDON_NAME])) {
					foreach ($return[errors][$ADDON_NAME] as $k => $v) $return[error] .= "<u>".$ADDON_NAME."</u>: ".$v."<br />";
				}
			}
		}
		$ae->new_error($lang['shipping']['error'].'<br />'.$return[error]);
	}
	
	return $return;
}

///////////////////
//  Payment Methods
///////////////////

function methods_modules () {
	global $DB_site, $dbprefix, $lang, $ae;
	$result = $DB_site->query("SELECT * FROM `".$dbprefix."modules_methods` WHERE `internalname`='enabled' AND `value`='1' ORDER by `module`"); 
	while ($row = $DB_site->fetch_assoc($result)) {
		$order = $DB_site->query_first("SELECT * FROM `".$dbprefix."modules_methods` WHERE `internalname`='display_order' AND `module`='".$row[module]."'");
		$modules[stripslashes($row[module])] = $order[value];
	}
	
	if (is_array($modules)) {
		asort($modules);
		$modules_out = array(); $i=0;
		foreach($modules as $k => $v) {
			$row = $DB_site->query_first("SELECT `module`, `value` FROM `".$dbprefix."modules_methods` WHERE `module`='".$k."' AND `internalname`='display_name'");
			$row  = filter_data($row);
			$out[data] .= template('misc_radio_select.html', array('option' => array('name' => 'order[payment_method]', 'value' => $row[module], 'display' => $row[value], 'checked' => (($i++==0)?'checked="checked"':''))));
		}
	} else {
		$ae->new_error($lang['order']['no_methods']);
		$out[hide] = "Continue";
	}
	
	return $out;
}

/////////////////
// Format Seatrch
/////////////////

function fsearch ($in) {
	return addslashes($in);
}

/////////////////
// Search Results
/////////////////

function search ($s) {
	global $dbprefix, $settings, $subarr, $sess;
	$fields = array("p.*", "p.manufacturer");
	if ($s[cid] > 0) {
		array_push($fields, "c.id AS catid");
		array_push($fields, "c.title AS cattitle");
		array_push($fields, "pc.productid");
		array_push($fields, "pc.catid AS pcatid");
	}
	$searchin = array();
	
	// Sanitize Input
	if (is_array($s)) {
		foreach($s as $k => $v) { $s[$k] = desql(sanitize(urldecode($v))); }
	}
	
	$sql = "SELECT ".implode(", ",$fields)." FROM `".$dbprefix."products` p 
		".(($s[cid] > 0)?"LEFT JOIN `".$dbprefix."products_categories` pc ON p.id=pc.productid 
		LEFT JOIN `".$dbprefix."categories` c ON (c.id=pc.catid OR p.`catid`=c.`id`)":"")."
		".(($s[mid] > 0)?"LEFT JOIN `".$dbprefix."manufacturers` m ON m.id=p.manufacturer":"")." WHERE 
	";
	if ($s[title] == "Y") {
		if ($s[match] == "exact") {
			$searchin[title] = "p.title = '".fsearch($s[search])."'";
		} elseif ($s[match] == "any") {
			$words = explode(" ", $s[search]);
			foreach ($words as $key => $word) $titles[] = "p.title LIKE '%".fsearch($word)."%'";
			$searchin[title] = implode(" OR ", $titles);
		} else {
			$words = explode(" ", $s[search]);
			foreach ($words as $key => $word) $titles[] = "p.title LIKE '%".fsearch($word)."%'";
			$searchin[title] = implode(" AND ", $titles);
		}
	}
	if ($s[short_desc] == "Y"  && $s[search] != "") {
		if ($s[match] == "exact") {
			$searchin[short_desc] = "p.short_desc = '".fsearch($s[search])."'";
		} elseif ($s[match] == "any") {
			$words = explode(" ", $s[search]);
			foreach ($words as $key => $word) $short_descs[] = "p.short_desc LIKE '%".fsearch($word)."%'";
			$searchin[short_desc] = implode(" OR ", $short_descs);
		} else {
			$words = explode(" ", $s[search]);
			foreach ($words as $key => $word) $short_descs[] = "p.short_desc LIKE '%".fsearch($word)."%'";
			$searchin[short_desc] = implode(" AND ", $short_descs);
		}
	}
	if ($s[full_desc] == "Y"  && $s[search] != "") {
		if ($s[match] == "exact") {
			$searchin[short_desc] = "p.full_desc = '".fsearch($s[search])."'";
		} elseif ($s[match] == "any") {
			$words = explode(" ", $s[search]);
			foreach ($words as $key => $word) $full_descs[] = "p.full_desc LIKE '%".fsearch($word)."%'";
			$searchin[full_desc] = implode(" OR ", $full_descs);
		} else {
			$words = explode(" ", $s[search]);
			foreach ($words as $key => $word) $full_descs[] = "p.full_desc LIKE '%".fsearch($word)."%'";
			$searchin[full_desc] = implode(" AND ", $full_descs);
		}
	}
	
	if (!isset($searchin[title]) || $searchin[title] == "") $searchin[title] = 0;
	if (!isset($searchin[short_desc]) || $searchin[short_desc] == "") $searchin[short_desc] = 0;
	if (!isset($searchin[full_desc]) || $searchin[full_desc] == "") $searchin[full_desc] = 0;
	
	$sql .= "((".$searchin[title].") OR (".$searchin[short_desc].") OR (".$searchin[full_desc].")";
	
	if ($s[sku] != "" && $s[sku] != "Y")
		$sql .= ") AND ((p.sku = '".fsearch($s[sku])."')";
	elseif ($s[sku] == "Y")
		$sql .= " OR (p.sku = '".fsearch($s[search])."')";
	
	$sql .= ")";
	
	if ($s[price_from] != "" || $s[price_to] != "")
		$sql .= " AND (".(($s[price_from]!="")?"p.price >= ".fsearch($s[price_from]):"1")." AND ".(($s[price_to]!="")?"p.price <= ".fsearch($s[price_to]):"1").")";
	if ($s[weight_from] != "" || $s[weight_to] != "")
		$sql .= " AND (".(($s[weight_from]!="")?"p.weight >= ".fsearch($s[weight_from]):"1")." AND ".(($s[weight_to]!="")?"p.weight <= ".fsearch($s[weight_to]):"1").")";
	if ($s[mid] > 0)
		$sql .= " AND (m.id = ".$s[mid].")";
	if ($s[cid] > 0) {
		if ($s[subcats] == "Y") {
			subcats($s[cid]);
			array_push($subarr, $s[cid]);
			$sql .= " AND (c.id IN (".implode(",", $subarr)."))";
		} else
			$sql .= " AND (c.id = ".$s[cid].")";
		$sql .= " ".restrict('c');
	}
	$sql .= " AND p.`viewable`='y' ".restrict('p')." GROUP by p.id ORDER by ".$settings[orderby]." ";
	
	// Save search for return
	$sess->dvar('s');
	$sess->svar('s', $s);
	
	return $sql;
}

///////////////////////
// Subcategories Search
///////////////////////

$subarr = array();
function subcats ($id) {
	global $DB_site, $dbprefix, $subarr;
	$temp = $DB_site->query("SELECT id FROM `".$dbprefix."categories` as c WHERE c.viewable='1' AND c.subof='".$id."' ".restrict('c'));
	while ($row = $DB_site->fetch_assoc($temp)) {
		array_push($subarr, $row[id]);
		subcats($row[id]);
	}
}

///////////////////
// Category Options
///////////////////

function catoptionlist ($cats, $level=0, $select=""){
	global $options_array;
	if (!is_array($options_array)) $options_array = array();
	for ($x=0; $x<count($cats); $x++) {
		if (is_array($select)) {
			if (in_array($cats[$x][id], $select)) $is_match = ' selected="selected"'; else $is_match = '';
		} else {
			if ($select == $cats[$x][id]) $is_match = ' selected="selected"'; else $is_match = '';
		}
		
		$out = '<option value="'.$cats[$x][id].'"'.$is_match.'>';
		for ($z=0; $z<$level; $z++) $out .= '..';
		$out .= $cats[$x][title].'</option>';
		array_push($options_array, $out);
		
		if (count($cats[$x][subs]) > 0) {
			catoptionlist($cats[$x][subs], $level+1, $select);
		}
	}
	if ($level == 0) return implode("\n", $options_array);
}

////////////
// Apply Tax
////////////

function applytax ($shipping=0, $discount=0) {
    global $DB_site, $dbprefix, $settings, $tax_rates, $cart, $sess;
	$subtotal   = $cart->subtotal(2);
	$subtotal  += ($settings[taxtoshipping]==1)?$shipping:0;
	$subtotal  -= (p($subtotal)!=p(0))?$discount:0;
	$tax 	    = '0.00';
	
	if (islogged()) $userinfo = get('users', $sess->gvar('userid'));
	else $userinfo = get('groups', 1, 'id', 'group_');
	
	if ($userinfo[group_taxable] == 0) return $tax;
	
	if (is_array($tax_rates)) {
		foreach ($tax_rates as $k => $v) {
			$tax_rates[$k][price] = ($tax_rates[$k][rate]/100*$subtotal);
			$tax += ($tax_rates[$k][rate]/100*$subtotal);
		}
	}
	return $tax;
}

////////////
// Tax Rates
////////////

function taxrates () {
    global $DB_site, $dbprefix, $settings, $cart, $userinfo;
	$rates = array();
	$results = $DB_site->query("SELECT *, t.name as name FROM `".$dbprefix."taxes` t LEFT JOIN `".$dbprefix."state_country` sc ON t.tvalue=sc.id");
	while ($row = $DB_site->fetch_assoc($results)) {
		$address = $row[address];
		if (($userinfo[$address.'_state'] == $row[abb] && $row[type] == STATE) ||
			($userinfo[$address.'_state'] == $row[abb] && $row[type] == PROV) ||
			($userinfo[$address.'_other'] == $row[abb] && $row[type] == STATE) ||
			($userinfo[$address.'_other'] == $row[abb] && $row[type] == PROV) ||
			($userinfo[$address.'_country'] == $row[abb] && $row[type] == COUNTRY) ||
			($userinfo[$address.'_zip'] == $row[name] && $row[type] == ZIPCODE))
				array_push($rates, array('name' => $row[name], 'rate' => $row[rate]));
	}
	return $rates;
}

///////////////
// Modules Data
///////////////

function modules ($type) {
	global $abs_path;
	$the_directory = @opendir($abs_path."/include/".$type."/");
	$out = array();
	while($FILE_NAME = @readdir($the_directory)) {
		$filenamea	= @explode(".", $FILE_NAME);
		$temp		= @count($filenamea)-1;
		$extension	= @strtolower($filenamea[$temp]);
		if ($extension == "php") {
			$success = include_once($abs_path."/include/".$type."/".$FILE_NAME);
			array_push($out, module_data($type, array('FILE_NAME' => $FILE_NAME, 'ADDON_NAME' => $ADDON_NAME, 'ADDON_FULLNAME' => $ADDON_FULLNAME, 'ADDON_TYPE' => $ADDON_TYPE, 'ADDON_VERSION' => $ADDON_VERSION, 'CLASS_NAME' => $CLASS_NAME)));
		}
	}
	@closedir($the_directory);
	return $out;
}

/////////////////////
// Show Shopping Cart
/////////////////////

function showcart () {
	global $settings, $cart, $lang, $ae, $sess;
	
	$viewcart[error] 	= $ae->display();
	$viewcart[previous] = $settings[shopurl]."index.php".get_previous();
	
	foreach ($cart->items as $i => $v) {
		$product		= get('products', $cart->items[$i]->id);
		$product		= calc_price($product, $cart->items[$i]->quantity);
		$product[price]	= $product[out_price];
		
		$product[cart_index] = $i;
		$product[quantity] 	 = $cart->items[$i]->quantity;
		$product[price]		+= $cart->items[$i]->options_price_increase();
		$product[subtotal]	 = $product[price] * $product[quantity];
		$product[options]	 = $cart->items[$i]->display_options();
		$viewcart[subtotal]	+= $product[subtotal];
		
		
		
		$product[price] 	= p($product[price]);
		$product[subtotal] 	= p($product[subtotal]);
		
		$viewcart[items] .= template('cart_view_item.html', array('product' => $product, 'lang' => $lang['cart_view']));
	}
	
	$discounts	= $cart->discount();
	$coupon		= $cart->discount('coupons');
	if (is_array($discounts[items]) || is_array($coupon[items])) $viewcart[subtotal2] = p($viewcart[subtotal] - $discounts[total] - $coupon[total]); else $hide[] = "New Subtotal";
	$viewcart[subtotal] = p($viewcart[subtotal]);
	
	if (is_array($discounts[items])) {
		foreach ($discounts[items] as $v) {
			$viewcart[discounts] .= ($v[total]==$lang[free_ship])?'':template('cart_view_discount_item.html', array('discount' => array('name' => $v[name], 'total' => p($v[total]))));
		}
	}
	
	if (is_array($coupon[items])) {
		foreach ($coupon[items] as $v) {
			$viewcart[discounts] .= ($v[total]==$lang[free_ship])?'':template('cart_view_discount_item.html', array('discount' => array('name' => $v[name], 'total' => p($v[total]))));
		}
	}
	
	if (count($cart->items) < 1) $viewcart[items] = template('cart_view_empty.html', array('lang' => $lang['cart_view']));
	
	return template('cart_view.html', array('viewcart' => $viewcart, 'lang' => $lang['cart_view'], 'hide' => $hide));; 
}

//////////////////////
// Cart Contents Table
//////////////////////

function cart_contents () {
	global $settings, $cart, $lang;
	if (count($cart->items) < 1)
		$out = template('table_cart_contents_empty.html', array('product' => $product, 'lang' => $lang['cart_contents']));
	else {
		foreach ($cart->items as $i => $v) {
			$product = get('products', $cart->items[$i]->id);
			$product = calc_price($product, $cart->items[$i]->quantity);
			$product[quantity] = $cart->items[$i]->quantity;
			$product[short_title] = shortenit($product[title], 100);
			$out .= template('table_cart_contents_item.html', array('product' => $product, 'lang' => $lang['cart_contents']));
		}
	}
	return $out; 
}

////////////////////////
// Product Display Parse
////////////////////////

function pre_display ($product, $image) {
	global $DB_site, $dbprefix, $settings, $lang, $sess;
	
	$product[hide] = array();
	
	if (islogged()) $userinfo = get('users', $sess->gvar('userid'));
	else $userinfo = get('groups', 1, 'id', 'group_');
	
	// Default Options Increase
	$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_options` where `productid`='".$product[id]."' order by `dorder`");
	$s_sql	 = ($settings[enforceoptionstock]=="Yes")?"AND `in_stock`>'0' ":"";
	while ($option = $DB_site->fetch_assoc($results)) {
		$option = filter_data($option);
		switch ($option[type]) {
			case 'select':
				$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$option[id]."' ".$s_sql."order by `dorder`");
				while ($item = $DB_site->fetch_assoc($items)) {
					$item = calc_option_price($item);
					$product[dincrease] += ($item[value]==$option['default'])?($item[mod].$item[price]):0;
				}
				break;
			case 'radio':
				$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$option[id]."' ".$s_sql."order by `dorder`");
				while ($item = $DB_site->fetch_assoc($items)) {
					$item = calc_option_price($item);
					$product[dincrease] += ($item[value]==$option['default'])?$item[price]:0;
				}
				break;
			case 'checkbox':
				$item = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$option[id]."' ".$s_sql."order by `dorder`");
				if ($item[id] != "") {
					$item = calc_option_price($item);
					$product[dincrease] += ($item[value]==$option['default'])?$item[price]:0;
				}
				break;
		}
	}
	
	// Any Options
	$option_count = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_options` where `productid`='".$product[id]."'");
	
	// Set Prices
	if ($product[out_price] != $lang['product_detail']['login']) {
		if (p($product[out_price]) == p(0) && $option_count[id] != "") {
			$product[price] = $lang['product_detail']['see_options'];
			array_push($product[hide], 'Sale Price');
		} elseif (p($product[out_price]) == p(0)) {
			$product[price] = $lang['product_detail']['free'];
			array_push($product[hide], 'Sale Price');
		} elseif ($product[sale_price] == $product[out_price] && $product[out_price] != $product[price]) {
			$lang[product_detail][o_price] = $lang[product_detail][orig_price];
			$product[strikethru] = ' product_strikethru';
		} else { 
			$product[price] = $product[out_price];
			array_push($product[hide], 'Sale Price');
		}
	} else {
		array_push($product[hide], 'Add To Cart');
		array_push($product[hide], 'Sale Price');
	}
	
	if ($product[orderable] == 'n') { array_push($product[hide], 'Add To Cart'); array_push($product[hide], 'Form Close'); array_push($product[hide], 'Form'); }
	else array_push($product[hide], 'Cart Hidden');
	
	// Check If List Price Is Set
	if (p($product[list_price]) == p(0) || !is_numeric($product[price])) {
		array_push($product[hide], 'List Price');
		array_push($product[hide], 'Savings');
	} else {
		$product[savings]		= p(($product[list_price]+$product[dincrease])-($product[out_price]+$product[dincrease]));
		$product[list_price]	= p($product[list_price]+$product[dincrease]);
	}
        
	if ($userinfo[group_showretail] == "0") {
		array_push($product[hide], 'List Price');
		array_push($product[hide], 'Savings');   
	}
	
	$product[price]         = (is_numeric($product[price]) || p($product[dincrease]) != p(0))?p($product[price]+$product[dincrease]):$product[price];
	$product[sale_price]    = (p($product[sale_price])!=p(0))?p($product[sale_price]+$product[dincrease]):p(0);
	
	// Check Stock Settings
	if ($settings[showstock] != "Yes") array_push($product[hide], 'Stock');
	elseif ($product[in_stock] > 0) $product[stock] = $lang['product_list']['instock'];
	else $product[stock] = $lang['product_list']['outstock'];
	
	if ($settings[enforcestock] == "Yes" && $product[in_stock] < 1) {
		$product[in_stock] = $lang['product_detail']['outofstock'];
		array_push($product[hide], 'Add To Cart');
	}
	
	// Check Manufacturer
	if ($product[manufacturer] != 0) {
		$man = get('manufacturers', $product[manufacturer]);
		$product[manufacturer_name] = $man[name];
	} else {
		array_push($product[hide], 'Manufacturer');
	}
	
	// Check if Logged In
	if ($settings[wishlist] == 'No') array_push($product[hide], 'Wishlist');
	if ($settings[registry] == 'No') array_push($product[hide], 'Registry');
	
	// Check Product Image
	if ($product[$image.'_image'] != "" && @is_file($settings[productpath].$product[$image.'_image'])) {
		$size = @getimagesize($settings[productpath].$product[$image.'_image'], $imageinfo);
		$product[image_size] = $size[3];
		$product[image_height] = $size[1];
	} else {
		array_push($product[hide], 'Image');
	}
	
	return $product;
}

////////////////////////
// Dispatch Order Emails
////////////////////////

function order_emails ($id) {
	global $DB_site, $dbprefix, $settings, $lang, $cart;
	
	// Prepare Email
	$order = get('orders', $id);
	foreach ($order as $k => $v) if ($v == "" || (is_numeric($v) && p($v) == p(0))) $hide[] = $k;
	$price_arrays = array('ship_price', 'tax', 'subtotal', 'discount', 'total', 'coupon_savings', 'gift_cert_savings', 'rewards_savings');
	foreach ($price_arrays as $v) $order[$v] = p($order[$v]);
	
	$order['datestamp'] = date($settings[datestamp].' '.$settings[timestamp], $order[order_stamp]);
	$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".sanitize($id)."' ORDER by `id`");
	while ($prod = $DB_site->fetch_assoc($results)) {
		$prod  = filter_data($prod);
		$product = get('products', $prod[productid]);
		$item = new orderitem($prod[data]);
		$product[price] 	= $prod[price]+$item->options_price_increase();
		$product[quantity]	= $item->get_quantity();
		$product[subtotal]	= p($item->get_quantity()*$product[price]);
		$product[price]		= p($product[price]);
		$product[options]	= $item->display_options_client();
		$order[items] .= template('email_order_confirmation_item.html', array('product' => $product, 'lang' => $lang['order']));
	}
	$email = template('email_order_confirmation.html', array('order' => $order, 'lang' => $lang['order'], 'hide' => $hide));
	
	// Send Emails
	mail_send($order[email], $order[bill_first_name].' '.$order[bill_last_name], $lang['order']['email_order_subject'], $email, $settings[contactemail], $settings[title], true);
	mail_send($settings[contactemail], $settings[title], $lang['order']['email_admin_order_subject'], $email, $settings[contactemail], $settings[title], true);
}

///////////////////////////
// Manufacturers Table List
///////////////////////////

function manufacturers_list() {
	global $DB_site, $dbprefix, $settings;
	$result = $DB_site->query("SELECT * FROM `".$dbprefix."manufacturers` WHERE viewable='1' order by `dorder` asc");
	while ($man = $DB_site->fetch_assoc($result)) {
		$man = filter_data($man);
		$mans .= template('table_manufacturers_option.html', array('man' => $man));
	}
	return $mans;
}

//////////////
// Query Array
//////////////

function query_array ($q) {
	$return = array();
	$vars = explode("&", $q);
	for ($i=0; $i<count($vars); $i++) {
		$items = explode("=", $vars[$i]);
		$return[$items[0]] = $items[1];
	}
	return $return;
}

////////////////////
// After Order Links
////////////////////

function order_links ($html) {
	$links = new order_links();
	return $links->parse_code($html);
}

class order_links {
	function order_links () {
		return;
	}
	
	function rewrite_link ($link_in) {
		$link = @parse_url(str_replace(array("&amp;"), "&", $link_in));
		if ($link[query] != "") {
			$new_link = $link_in."&cc=1";
		} else {
			$new_link = $link_in."?cc=1";
		}
		
		return $new_link;
	}
	
	function reformat ($match) {
		return "<a".$match[1]."href=\"".$this->rewrite_link($match[2])."\"".$match[3].">";
	}
	
	function reformat2 ($match) {
		$location = @strpos($match[1], 'external_proceed');
		if ($location === false) {
			return "<form".$match[1]."action=\"".$this->rewrite_link($match[2])."\"".$match[3].">";
		} else {
			return "<form".$match[1]."action=\"".$match[2]."\"".$match[3].">";
		}
	}
	
	function parse_code ($txt) {
		$txt = preg_replace_callback("/\<a(.*?)href\s*=\s*['|\"|\s*](.*?)['|\"|>](.*?)\>/", array($this, 'reformat'), $txt);
		$txt = preg_replace_callback("/\<form(.*?)action\s*=\s*['|\"|\s*](.*?)['|\"|>](.*?)\>/", array($this, 'reformat2'), $txt);
		return $txt;
	}
}

///////////////////
// HTML Links Class
///////////////////

function html_links ($html) {
	global $settings;
	if ($settings[htmlpages] == "on") {
		$links = new html_links();
		return $links->parse_code($html);
	} else {
		return $html;
	}
}

class html_links {
	function html_links () {
		return;
	}
	
	function rewrite_link ($link_in) {
		global $DB_site, $dbprefix, $settings;
		$link = parse_url(str_replace(array("&amp;"), "&", $link_in));
		if ($link[query] != "") {
			$qarray = query_array($link[query]);
			switch ($qarray[l]) {
				case 'page_view':
					$filename = str_replace(array('{page_name}'), array($qarray[p]), $settings[html_page]);
					$new_link = $settings[shopurl].(($settings[html_dir]!='')?$settings[html_dir].'/':'').$this->format_title((($settings[html_tolower]=='true')?strtolower($filename):$filename));
					break;
				case 'product_detail':
					$product = get('products', $qarray[p]);
					$category = get('categories', $product[catid]);
					$filename = str_replace(array('{category_name}', '{product_name}', '{product_id}'), array($this->format_cat($category[title]), $this->format_title($product[title]), $this->format_title($product[id])), $settings[html_product]);
					$new_link = $settings[shopurl].(($settings[html_dir]!='')?$settings[html_dir].'/':'').(($settings[html_tolower]=='true')?strtolower($filename):$filename);
					break;
				case 'product_list':
					if ($qarray[m] != "") {
						$manufacturer = get('manufacturers', $qarray[m]);
						$filename = str_replace(array('{manufacturer_name}', '{manufacturer_id}', '{page}'), array($manufacturer[name], $manufacturer[id], (($qarray[pg]=="")?1:$qarray[pg])), $settings[html_manufacturer]);
					} else {
						$category = get('categories', $qarray[c]);
						$filename = str_replace(array('{category_name}', '{category_id}', '{page}'), array($category[title], $category[id], (($qarray[pg]=="")?1:$qarray[pg])), $settings[html_cat]);
					}
					$new_link = $settings[shopurl].(($settings[html_dir]!='')?$settings[html_dir].'/':'').$this->format_title((($settings[html_tolower]=='true')?strtolower($filename):$filename));
					break;
				default:
					$new_link = $link_in;
					break;
			}
		} else {
			$new_link = $link_in;
		}
		return $new_link;
	}
	
	function reformat ($match) {
		global $settings;
		return "<a".$match[1]."href=\"".$this->rewrite_link($match[2])."\"".$match[3].">";
	}
	
	function reformat2 ($match) {
		global $settings;
		return "<option value=\"".str_replace(array($settings[shopurl], $settings[secureurl]), array('', ''), $this->rewrite_link($match[1]))."\">";
	}
	
	function reformat3 ($match) {
		global $settings;
		return "<input type=\"button\"".$match[1]."onclick=\"javascript: location.href='".$this->rewrite_link($match[2])."'\"".$match[3].">";
	}
	
	function parse_code ($txt) {
		global $DB_site, $dbprefix, $settings;
		$txt = preg_replace_callback("/\<a(.*?)href\s*=\s*['|\"|\s*](.*?)['|\"|>](.*?)\>/", array($this, 'reformat'), $txt);
		$txt = preg_replace_callback("/\<option value\s*=\s*['|\"|\s*](.*?)['|\"|>]\>/", array($this, 'reformat2'), $txt);
		$txt = preg_replace_callback("/\<input type=\"button\"(.*?)onclick=\"javascript: location.href\s*=\s*['|\"|\s*](.*?)['|\"|>];\"(.*?)\>/", array($this, 'reformat3'), $txt);
		return $txt;
	}
	
	function format_title ($in) {
		global $settings;
		preg_match_all('/[a-zA-Z0-9-.'.$settings[html_space].']/', str_replace(array("_", " ", "&amp;", "&quot;", "&"), array("-", $settings[html_space], "and", "", "and"), $in), $matches);
		for ($i=0; $i<count($matches[0]); $i++) $new_name .= $matches[0][$i];
		return $new_name;
	}
	
	function format_cat ($in) {
		global $settings;
		preg_match_all('/[a-zA-Z0-9-.\/'.$settings[html_space].']/', str_replace(array("_", " ", "&amp;", "&quot;", "&"), array("-", $settings[html_space], "and", "", "and"), $in), $matches);
		for ($i=0; $i<count($matches[0]); $i++) $new_name .= $matches[0][$i];
		return $new_name;
	}
}

//////////////
// Store Order
//////////////

function store_order ($append_array, $method="", $semail=true) {
	global $DB_site, $dbprefix, $settings, $cart, $sess, $lang, $gs, $rp;
	
	$force_account = 0;
	foreach ($cart->items as $k => $item) {
		if (has_downloads($item->id) && !islogged()) $force_account = 1;
	}
	
	if ($force_account == 1) {
		$store_info = $sess->gvar('userinfo');
		$getuser = explode('@', $store_info[email]);
		$store_info[username] = $getuser[0].'-'.randomnums(4);
		$store_info[password1] = randompass(10);
		$store_info[password2] = $store_info[password1];
		$store_info[store_info] = 'store';
		$check = check_account($store_info, 1, 1);
	}
	
	$result = $DB_site->query_first("SELECT `value` FROM `".$dbprefix."modules_methods` WHERE `module`='".$_SESSION[orderinfo][pay_method]."' AND internalname='display_name'");
	
	$oinfo = (is_array($sess->gvar('orderinfo')))?$sess->gvar('orderinfo'):array();
	$uinfo = (is_array($sess->gvar('userinfo')))?$sess->gvar('userinfo'):array();
	
	if ($uinfo['ship_oset'] == '1') $uinfo['ship_state'] = $uinfo['ship_other']; 
	else { $uinfo['ship_other'] = ''; $uinfo['ship_state'] = ereg_replace("[^A-Za-z]", "", $uinfo['ship_state']); }
	
	if ($uinfo['bill_oset'] == '1') $uinfo['bill_state'] = $uinfo['bill_other']; 
	else { $uinfo['bill_other'] = ''; $uinfo['bill_state'] = ereg_replace("[^A-Za-z]", "", $uinfo['bill_state']); }
	
	$orderinfo = array_merge(
		$uinfo,
		$oinfo,
		$append_array,
		array (
			'userid'		=> $sess->gvar('userid'),
			'order_date' 	=> date('Y-m-d'),
			'ip_addr'		=> $_SERVER['REMOTE_ADDR'],
			'order_stamp'	=> stamp(),
			'pay_method'	=> ($method!="")?$method:$result[value],
			'total'			=> p($oinfo[total], false)
		)
	);
	
	if (p($orderinfo[total]) == p(0)) $orderinfo[cc_status] = "Payment Received";
	unset($orderinfo[id]);
	
	$query  = "INSERT INTO `".$dbprefix."orders` set";
	$result = $DB_site->query("DESCRIBE `".$dbprefix."orders`");
	while ($field = $DB_site->fetch_assoc($result)) {
		$key = $field['Field'];
		if (isset($orderinfo[$key])) $query .= " `".$key."`='".sf($orderinfo[$key])."',";
	}
	$DB_site->query(substr($query, 0, -1));
	$orderid = $DB_site->insert_id();
	
	custom_store('orders', 'orderid', $orderid);
	custom_store('users', 'orderid', $orderid);
	
	foreach ($cart->items as $k => $item) {
		$product = get('products', $item->id);
		$product = calc_price($product, $item->quantity);
		
		if ($item->id == 'gs') {
			$cert = $gs->generate();
			$DB_site->query("INSERT INTO `".$dbprefix."gift_certificates` set
				`userid`='0',
				`orderid`='".$orderid."',
				`purchaser`='".$orderinfo[userid]."',
				`code`='".$cert."',
				`purchaser_name`='".sf($item->options[0]->sender_name)."',
				`recipient_name`='".sf($item->options[0]->recipient_name)."',
				`recipient_email`='".sf($item->options[0]->recipient_email)."',
				`message`='".sf($item->options[0]->message)."',
				`amount`='".$item->options[0]->price."',
				`remaining`='".$item->options[0]->price."',
				`start_date`='".date('Y-m-d')."',
				`end_date`='0000-00-00',
				`status`='1'
			");
			$item->options[0]->cert = $cert;
			$cert = $gs->cert_array($item->options[0]);
			
			if ($orderinfo[cc_status] == "Payment Received") $gs->send(array_merge($cert, array('cert' => $item->options[0]->cert)));
		}
		
		if ($item->regid != "") {
			$purch = $DB_site->query("SELECT `purchased` FROM `".$dbprefix."users_wishlist` where `id`='".$item->regid."'");
			$DB_site->query("UPDATE `".$dbprefix."users_wishlist` set `purchased`='".($purch[purchased]+$item->quantity)."' where `id`='".$item->regid."'");
		}
		
		$DB_site->query("INSERT INTO `".$dbprefix."orders_products` set
			`orderid`='".$orderid."',
			`productid`='".$item->id."',
			`price`='".$product[out_price]."',
			`data`='".sf(base64_encode($cart->return_serialized($k)))."',
			`item`='".sf(base64_encode(serialize(array('num' => $product[num], 'title' => $product[title], 'short_desc' => $product[short_desc], 'full_desc' => $product[full_desc]))))."'
		");
		
		foreach ($item->options as $key => $opt) {
			$option = get('products_options_items', $opt->valueid);
			$DB_site->query("UPDATE `".$dbprefix."products_options_items` set 
				`in_stock`='".($option[in_stock]-$item->quantity)."'
				where `id`='".$option[id]."'");
		}
		
		$DB_site->query("UPDATE `".$dbprefix."products` set 
			`in_stock`='".($product[in_stock]-$item->quantity)."',
			`num_sold`='".($product[num_sold]+$item->quantity)."' 
			where `id`='".$product[id]."'");
	}
	
	$disc_used = $sess->gvar('disc_used');
	if (is_array($disc_used)) {
		foreach ($disc_used as $k => $v) {
			$disc = $DB_site->query_first("SELECT * FROM `".$dbprefix."discounts` where `id`='".$v."'");
			$DB_site->query("UPDATE `".$dbprefix."discounts` set `used`='".($disc[used]+1)."' where `id`='".$v."'");
		}
	}
	
	$coup_used = $sess->gvar('coup_used');
	if (is_array($coup_used)) {
		foreach ($coup_used as $k => $v) {
			$coup = $DB_site->query_first("SELECT * FROM `".$dbprefix."coupons` where `id`='".$v."'");
			$DB_site->query("UPDATE `".$dbprefix."coupons` set `used`='".($coup[used]+1)."' where `id`='".$v."'");
		}
	}
	
	if ($orderinfo[gift_cert] != "" && p($orderinfo[gift_cert_savings]) != p(0)) $gs->cert_update = 1;
	
	$data = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders` WHERE `id`='".$orderid."'");
	if (p($orderinfo[rewards_savings]) != p(0)) $rp->adjust_points($data);
	$rp->add_points($data);
	
	if ($semail) order_emails($orderid);
	return $orderid;
}

///////////////////////
//	Email Address Check
///////////////////////

function check_email_address ($email) {
	if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email)) return false;
	
	$email_array = explode("@", $email);
	$local_array = explode(".", $email_array[0]);
	for ($i = 0; $i < sizeof($local_array); $i++) {
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) return false;
	}
	
	if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) {
		$domain_array = explode(".", $email_array[1]);
		if (sizeof($domain_array) < 2) return false;
		for ($i = 0; $i < sizeof($domain_array); $i++) {
			if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) return false;
		}
	}
	return true;
}

///////////////
// Update Order
///////////////

function update_order ($id, $append_array, $semail=true) {
	global $DB_site, $dbprefix, $settings, $cart, $sess, $lang, $rp;
	
	$query  = "UPDATE `".$dbprefix."orders` set";
	$result = $DB_site->query("DESCRIBE `".$dbprefix."orders`");
	while ($field = $DB_site->fetch_assoc($result)) {
		$key = $field['Field'];
		if (isset($append_array[$key])) $query .= " `".$key."`='".sf($append_array[$key])."',";
	}
	$DB_site->query(substr($query, 0, -1)." WHERE `id`='".$id."'");
	
	$data = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders` WHERE `id`='".$id."'");
	$rp->update_points($data);
	
	if ($semail) order_emails($id);
	return $id;
}

/////////////////////////
// Product Details Output
/////////////////////////

function item_detail ($id, $product) {
    global $DB_site, $dbprefix, $settings, $cart, $sess, $userinfo, $lang, $tile_count, $ae;
	
	$product = calc_price($product, 1);
	
	if (islogged()) $userinfo = get('users', $sess->gvar('userid'));
	else $userinfo = get('groups', 1, 'id', 'group_');
	
	$compare_group = ((islogged())?$userinfo[group_in]:'1');
	if ($product[avail_to] != '0' && $product[avail_to] != $compare_group) $product[viewable] = "n";
	
	if ($product[viewable] == "n" || $product[id] == "") {
		$out = template('page_message_output.html', array('page' => array('heading' => $lang['product_detail']['pstatus'], 'message' => $lang['product_detail']['not_viewable'])));
		return $out;
	}
	
	$product[cookie_crumb]  = cookiecrumb($product[catid], $product);
	$_GET[c] = $product[catid];
	
	$product[message] = $ae->display();
	
	// Product Attributes
	$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_attributes` where `productid`='".$product[id]."' order by `dorder`");
	while ($atts = $DB_site->fetch_assoc($results)) {
		$atts = filter_data($atts);
		$option_out = array('name' => $atts[name], 'value' => $atts[value]);
		$product[attributes] .= template('product_detail_option.html', array('option_out' => $option_out));
	}
	
	// Product Options
	$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_options` where `productid`='".$product[id]."' order by `dorder`");
	$s_sql	 = ($settings[enforceoptionstock]=="Yes")?"AND `in_stock`>'0' ":"";
	while ($option = $DB_site->fetch_assoc($results)) {
		$option = filter_data($option);
		$option_out[name]	= $option[name];
		$option[name] 		= 'option['.$option[id].']';
		switch ($option[type]) {
			case 'textbox':
			case 'textarea':
				$option_out[value] = template('product_detail_option_'.$option[type].'.html', array('option' => $option));
				break;
			case 'select':
				$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$option[id]."' ".$s_sql."order by `dorder`");
				while ($item = $DB_site->fetch_assoc($items)) {
					$item = calc_option_price($item);
					$item[selected]		= ($item[value]==$option['default'])?'selected="selected"':'';
					$item[add_price]	= (p($item[price])!=p(0))?' ('.$lang['product_detail'][(($item[mod]!="-")?'addp':'subtract')].' '.p($item[price]).')':'';
					$option[options]	.= template('product_detail_option_select_option.html', array('item' => $item));
				}
				$option_out[value] = ($option[options]=="")?"":template('product_detail_option_select.html', array('option' => $option));
				break;
			case 'radio':
				$option_out[value] = "";
				$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$option[id]."' ".$s_sql."order by `dorder`");
				while ($item = $DB_site->fetch_assoc($items)) {
					$item = calc_option_price($item);
					$item[selected]		= ($item[value]==$option['default'])?'checked="checked"':'';
					$item[add_price]	= (p($item[price])!=p(0))?' ('.$lang['product_detail'][(($item[mod]!="-")?'addp':'subtract')].' '.p($item[price]).')':'';
					$option_out[value]	.= template('product_detail_option_radio_option.html', array('option' => $option, 'item' => $item));
				}
				break;
			case 'checkbox':
				$item = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$option[id]."' ".$s_sql."order by `dorder`");
				if ($item[id] != "") {
					$item = calc_option_price($item);
					$item[selected]		= ($item[value]==$option['default'])?'checked="checked"':'';
					$item[add_price]	= (p($item[price])!=p(0))?' ('.$lang['product_detail'][(($item[mod]!="-")?'addp':'subtract')].' '.p($item[price]).')':'';
					$option_out[value]	= template('product_detail_option_checkbox.html', array('option' => $option, 'item' => $item));
				}
				break;
		}
		$product[options] .= ($option_out[value]=="")?"":template('product_detail_option.html', array('option_out' => $option_out));
	}
	
	$product = pre_display($product, 'detail');
	
	// Additional Product Images
	$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_images` WHERE `productid`='".$product[id]."'");
	while ($image = $DB_site->fetch_assoc($items)) $tile[images] .= outputimage($image[id]);
	$tile[images] = close_images_cleanly($tile);
	$product[images] = template('product_detail_images.html', array('tile' => $tile));
	if ($tile[images] == "") $product[hide][] = 'Photos';
	
	// Related Products
	$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_related` pr LEFT JOIN `".$dbprefix."products` p on p.`id`=pr.`relatedto`
		WHERE pr.`productid`='".$product[id]."' 
		AND p.`viewable`='y'".restrict('p')." 
		order by pr.`dorder`");
	while ($prod = $DB_site->fetch_assoc($items)) $list[products] .= outputitem($prod[relatedto]);
	$tile[products] = close_cleanly($list);
	$product[related] = template('list_products_'.$settings[showitem].'.html', array($settings[showitem] => ${$settings[showitem]}));
	if ($list[products] == "") $product[hide][] = 'Related';
	
	// Product Reviews
	$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_reviews` WHERE `productid`='".$product[id]."' AND `status`='1' order by `datestamp` desc");
	while ($review = $DB_site->fetch_assoc($items)) {
		$review = filter_data($review);
		$review[date] = date($settings[datestamp].' '.$settings[timestamp], $review[datestamp]);
		$list[reviews] .= template('product_detail_reviews_item.html', array('review' => $review, 'lang' => $lang['product_detail']));
	}
	$rinfo 	= (islogged())?array('name' => $userinfo[bill_first_name].' '.$userinfo[bill_last_name], 'email' => $userinfo[email]):array();
	$list[reviews] 	= ($list[reviews]=="")?$lang['product_detail']['be_first']:$list[reviews];
	$product[reviews] = template('product_detail_reviews.html', array('list' => $list, 'lang' => $lang['product_detail'], 'form' => $form, 'rinfo' => $rinfo, 'hide' => array(($settings[imageverify]!="Yes")?'Image Verification':'')));
	
	if ($settings[reviews] != "Yes") $product[hide][] = 'Reviews';
	
	// Tell A Friend About Product
	$tinfo 	= (islogged())?array('yname' => $userinfo[bill_first_name].' '.$userinfo[bill_last_name], 'yemail' => $userinfo[email]):array();
	$tinfo 	= array_merge($tinfo , array('subject' => $lang['product_detail']['dsubject'], 'message' => $lang['product_detail']['dmessage']));
	$product[tell_friend] = template('product_detail_tell_friend.html', array('lang' => $lang['product_detail'], 'tinfo' => $tinfo, 'hide' => array(($settings[imageverify]!="Yes")?'Image Verification':'')));
	
	// Volume Pricing
	$extended  = vol_price($product[id]);
	if (!is_array($extended)) {
		$product[hide][] = 'Volume Pricing';
	} else {
		$product[v_numbers] = $extended[quans];
		$product[v_prices] =  $extended[prices];
	}
	
	$out = template('product_detail.html', array('lang' => $lang['product_detail'], 'product' => $product, 'hide' => $product[hide], 'tab' => array($_POST[d] => 'tabbertabdefault')));
	return $out;
}

/////////////////////
// Custom Fields Output
/////////////////////

function display_custom ($type, $usecurrent=false) {
	global $DB_site, $dbprefix, $settings, $sess, $lang;
	if ($usecurrent) {
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."users_custom_entries` where `userid`='".$sess->gvar('userid')."'");
		while ($entry = $DB_site->fetch_assoc($results)) {
			$match = $DB_site->query_first("SELECT * FROM `".$dbprefix."users_custom_fields_items` where `fieldid`='".addslashes($entry[fieldid])."' AND `value`='".addslashes($entry[value])."'");
			$saved[$entry[fieldid]] = ($match[id]!='')?$match[id]:$entry[value];
		}
	} else {
		$saved = ($type=='orders')?$sess->gvar('orderinfo', 'customfield'):$sess->gvar('customfield');
	}
	
	$results = $DB_site->query("SELECT * FROM `".$dbprefix.$type."_custom_fields` order by `dorder`");
	while ($field = $DB_site->fetch_assoc($results)) {
		$field = filter_data($field);
		$field_out[name] = $field[name];
		$field[name] = 'customfield['.$field[id].']';
		switch ($field[type]) {
			case 'textbox':
			case 'textarea':
				if ($saved[$field[id]] != "") $field['default'] = $saved[$field[id]];
				$field_out[value] = template('misc_custom_field_'.$field[type].'.html', array('field' => $field));
				break;
			case 'select':
				$items = $DB_site->query("SELECT * FROM `".$dbprefix.$type."_custom_fields_items` WHERE `fieldid`='".$field[id]."' order by `dorder`");
				while ($item = $DB_site->fetch_assoc($items)) {
					$item[selected]	 = (($item[value]==$field['default'] && $saved[$field[id]] == '') || $saved[$field[id]] == $item[id])?'selected="selected"':'';
					$field[options]	.= template('misc_custom_field_select_option.html', array('item' => $item));
				}
				$field_out[value] = ($field[options]=="")?"":template('misc_custom_field_select.html', array('field' => $field));
				break;
			case 'radio':
				$field_out[value] = "";
				$items = $DB_site->query("SELECT * FROM `".$dbprefix.$type."_custom_fields_items` WHERE `fieldid`='".$field[id]."' order by `dorder`");
				while ($item = $DB_site->fetch_assoc($items)) {
					$item[selected]		 = (($item[value]==$field['default'] && $saved[$field[id]] == '') || $saved[$field[id]] == $item[id])?' checked="checked"':'';
					$field_out[value]	.= template('misc_custom_field_radio_option.html', array('field' => $field, 'item' => $item));
				}
				break;
			case 'checkbox':
				$item = $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_custom_fields_items` WHERE `fieldid`='".$field[id]."' order by `dorder`");
				if ($item[id] != "") {
					$item[selected]		= (($item[value]==$field['default'] && $saved[$field[id]] == '') || $saved[$field[id]] == $item[id])?'checked="checked"':'';
					$field_out[value]	= template('misc_custom_field_checkbox.html', array('field' => $field, 'item' => $item));
				}
				break;
		}
		$field_out[required] = ($field[required]=='y')?'<span class="required">*</span>':'';
		$return .= ($field_out[value]=="")?"":template('misc_custom_field_output.html', array('field_out' => $field_out));
	}
	return $return;
}

/////////////////////
// Validate Custom Fields
/////////////////////

function check_custom ($type, $skip=false) {
	global $DB_site, $dbprefix, $settings, $lang, $sess, $ae;
	$error_exists = false;
	if (is_array($_POST[customfield])) {
		foreach ($_POST[customfield] as $k => $v) {
			$required = $DB_site->query_first("SELECT `required` FROM `".$dbprefix.$type."_custom_fields` where `id`='$k'");
			if ($required[required] == 'y' && $v == '') $error_exists = true;
		}
		
		switch ($type) {
			case 'users': 
				$sess->dvar('customfield');
				$sess->svar('customfield', $_POST[customfield]);
			break;
			case 'orders': 
				$sess->dvar('orderinfo', 'customfield');
				$sess->svar('orderinfo', $_POST[customfield], 'customfield');
			break;
		}
		
		if ($error_exists) {
			$ae->new_error($lang['order']['rqaddinfo']);
			if (!$skip) {
				switch ($type) {
					case 'users': header('location: '.$return); break;
					case 'orders':	header('location: checkout.php?l=review'); break;
				}
				exit;
			}
		}
	}
}

/////////////////////
// Store Custom Fields
/////////////////////

function custom_store ($type, $marker, $mark) {
	global $DB_site, $dbprefix, $settings, $lang, $sess;
	$saved = ($type=='orders')?$sess->gvar('orderinfo', 'customfield'):$sess->gvar('customfield');
	if (is_array($saved)) {
		foreach ($saved as $k => $v) {
			$field = $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_custom_fields` where `id`='$k'");
			$field_item = $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_custom_fields_items` where `id`='".addslashes($v)."'");
			$DB_site->query("INSERT INTO `".$dbprefix.$type."_custom_entries` set `$marker`='$mark', `fieldid`='$field[id]', `name`='".sf($field[name])."', `value`='".sf(($field_item[id]!='')?$field_item[value]:$v)."', `dorder`='$field[dorder]'");
			switch ($type) {
				case 'users': $sess->dvar('orderinfo', 'customfield'); break;
				case 'orders': $sess->dvar('customfield'); break;
			}
		}
	}
}

//////////////////////
// Calculate Vol Price
//////////////////////

function calc_vol_price ($info=array()) {
	global $DB_site, $dbprefix, $settings, $lang, $sess;
	if (!is_array($info)) return;
	$return = array();
	foreach ($info as $k => $v) $info[$k] = stripslashes($v);
        
	if (islogged()) $userinfo = get('users', $sess->gvar('userid'));
	else $userinfo = get('groups', 1, 'id', 'group_');
	
	if ($settings[globalpriceoffset] != "") {
		$number  = $settings[globalpriceoffset];
		$mod 	 = substr($number, 0, 1);
		$percent = substr($number, -1, 1);
		
		$number	 = ($mod=="-")?substr($number, 1):$number;
		$number	 = ($percent=="%")?substr($number, 0, -1):$number;
		
		$diff = ($percent=="%")?$info[price]*($number/100):$number;
		$info[price] = (p($info[price])!=p(0))?(($mod=="-")?$info[price]-$diff:$info[price]+$diff):'0';
	}
	
	if (p($userinfo[group_discount])!=p(0)) {
		$discount		= ($info[price]*($userinfo[group_discount]/100));
		$info[price]	= ($info[price]-$discount);
	}
	return $info;
}

/////////////////////////
// Calculate Option Price
/////////////////////////

function calc_option_price ($info=array()) {
	global $DB_site, $dbprefix, $settings, $lang, $sess;
	if (!is_array($info)) return;
	$return = array();
	foreach ($info as $k => $v) $info[$k] = stripslashes($v);
	
	if (islogged()) $userinfo = get('users', $sess->gvar('userid'));
	else $userinfo = get('groups', 1, 'id', 'group_');
	
	if ($settings[globalpriceoffset] != "") {
		$number  = $settings[globalpriceoffset];
		$mod 	 = substr($number, 0, 1);
		$percent = substr($number, -1, 1);
		
		$number	 = ($mod=="-")?substr($number, 1):$number;
		$number	 = ($percent=="%")?substr($number, 0, -1):$number;
		
		$diff = ($percent=="%")?$info[price]*($number/100):$number;
		$info[price] = (p($info[price])!=p(0))?(($mod=="-")?$info[price]-$diff:$info[price]+$diff):'0';
	}
	
	$info[mod]		= substr($info[price], 0, 1);
    $info[price]	= ($info[mod]=="-")?substr($info[price], 1):$info[price];
	
	if (p($userinfo[group_discount])!=p(0)) {
		$discount		= ($info[price]*($userinfo[group_discount]/100));
		$info[price]	= ($info[mod]=="-")?($info[price]+$discount):($info[price]-$discount);
	}
	
	if ($userinfo[group_showprices] == "0") {
		$info[price] = $lang['product_detail']['login'];
	}
	
	$info[mod] = ($info[mod]=="-")?$info[mod]:"";
	return $info;
}

//////////////////
// Calculate Price
//////////////////

function calc_price ($info, $quantity) {
	global $DB_site, $dbprefix, $settings, $lang, $sess;
	
	if (islogged()) $userinfo = get('users', $sess->gvar('userid'));
	else $userinfo = get('groups', 1, 'id', 'group_');
	
	if ($info[sku] != 'gift_cert') {
		$pricing = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_pricing` WHERE `productid`='".$info[id]."' 
			AND `groupid`='".$userinfo[group_id]."' AND `quantity`<='".$quantity."' ORDER BY `price`");
		if ($pricing[id] == "") {
			$pricing = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_pricing` WHERE 
			`productid`='".$info[id]."' AND `groupid`='0' AND `quantity`<='".$quantity."' ORDER BY `price`");
		}
	}
	
	$info[list_price]	= ($pricing[retail]!="")?$pricing[retail]:$info[list_price];
	$info[price]		= ($pricing[price]!="")?$pricing[price]:$info[price];
	$info[sale_price]	= ($pricing[price]!="")?$pricing[price]:$info[sale_price];
	
	if ($settings[globalpriceoffset] != "" && $info[sku] != 'gift_cert') {
		$number  = $settings[globalpriceoffset];
		$mod 	 = substr($number, 0, 1);
		$percent = substr($number, -1, 1);
		$number	 = ($mod=="-")?substr($number, 1):$number;
		$number	 = ($percent=="%")?substr($number, 0, -1):$number;
		$diff2 = ($percent=="%")?$info[price] * ($number/100):$number;
		$diff3 = ($percent=="%")?$info[sale_price] * ($number/100):$number;
		$info[price] = (p($info[price])!=p(0))?(($mod=="-")?$info[price]-$diff2:$info[price]+$diff2):'0';
		$info[sale_price] = (p($info[sale_price])!=p(0))?(($mod=="-")?$info[sale_price]-$diff3:$info[sale_price]+$diff3):'0';
	}
	
	$info[price]  		= (p($userinfo[group_discount])!=p(0) && $info[sku] != 'gift_cert')?($info[price]-($info[price]*($userinfo[group_discount]/100))):$info[price];
	$info[sale_price] 	= (p($userinfo[group_discount])!=p(0) && $info[sku] != 'gift_cert')?($info[sale_price]-($info[sale_price]*($userinfo[group_discount]/100))):$info[sale_price];
	$info[out_price]	= (p($info[sale_price])!=p(0))?$info[sale_price]:$info[price];
	
	if ($userinfo[group_showprices] == "0") {
		$info[retail] 		= p(0);
		$info[price] 		= $lang['product_detail']['login'];
		$info[out_price]	= $lang['product_detail']['login'];
		$info[sale_price]	= p(0);
	}
	return $info;
}

/////////////////
// Volume Pricing
/////////////////

function vol_price ($id) {
	global $DB_site, $dbprefix, $settings, $lang, $sess;
	
	if (islogged()) $userinfo = get('users', $sess->gvar('userid'));
	else $userinfo = get('groups', 1, 'id', 'group_');
	
	if ($userinfo[group_showprices] == "0") return '';
	
	$pricing = $DB_site->query("SELECT * FROM `".$dbprefix."products_pricing` WHERE `productid`='".$id."' AND `groupid`='".$userinfo[group_id]."' ORDER BY `quantity`");
	if ($DB_site->num_rows($pricing) == 0) $pricing = $DB_site->query("SELECT * FROM `".$dbprefix."products_pricing` WHERE `productid`='".$id."' AND `groupid`='0' ORDER BY `quantity`");
	while ($row = $DB_site->fetch_assoc($pricing)) {
		$row = calc_vol_price($row);
		$return[prices]	.= template('product_detail_volume_item.html', array('item' => array('data' => p($row[price]))));
		$return[quans]	.= template('product_detail_volume_item.html', array('item' => array('data' => $row[quantity].'+')));
	}
	return $return;
}

//////////////
// Filter Data
//////////////

function filter_data ($row=array()) {
	if (!is_array($row)) return;
	$return = array();
	foreach ($row as $k => $v) {
		$return[$k] = stripslashes($v);
	}
	return $return;
}

///////////////////
// Clean Javascript
///////////////////

function js_clean ($in) {
	$out = trim(str_replace(array("  ", "\t", "\r\n", "\r", "\n"), '', $in));
	$out = trim(str_replace("'", "\'", $out));
	return $out;
}

///////////////
// Order Review   
///////////////

function review_order ($alt="") {
	global $DB_site, $dbprefix, $settings, $lang, $cart, $sess, $tax_rates, $userinfo, $orderinfo, $gs, $discounts, $coupon, $ae, $rp;
	
	if (is_array($sess->gvar('userinfo'))) $userinfo = $sess->gvar('userinfo');
	
	foreach ($cart->items as $k => $item) {
		$product = get('products', $item->id);
		$product = calc_price($product, $item->quantity);
		$product[price] = $product[out_price];
		
		$product[quantity]	= $item->quantity;
		$product[price]		= $product[price] + $item->options_price_increase();
		$product[subtotal]	= p($product[price] * $item->quantity);
		$product[price]		= p($product[price]);
		$product[options]	= ($item->display_options()!="")?$item->display_options():"";
		
		$order[items] .= template('order_review_item.html', array('lang' => $lang['order'], 'product' => $product));
	}
	
	$discounts	= $cart->discount();
	$coupon		= $cart->discount('coupons');
	$tax_rates	= taxrates();
	
	$orderinfo[subtotal]		= $cart->subtotal();
	$orderinfo[tax]				= applytax($orderinfo[ship_price], $discounts[total]+$coupon[total]);
	$orderinfo[discount]		= $discounts[total];
	$orderinfo[coupon]			= $cart->coupon;
	$orderinfo[coupon_savings]	= $coupon[total];
	$orderinfo[total]			= ($cart->subtotal() + $orderinfo[tax] + $orderinfo[ship_price] - $discounts[total] - $coupon[total]);
	
	if (p($settings[order_min]) != p(0) && p($orderinfo[total], false) < p($settings[order_min], false)) { 
		$ae->new_error($lang['cart_view']['error_4']);
		header('location: '.$settings[secureurl].'index.php?l=cart_view'); 
		exit; 
	}
	
	$rp->available();
	$orderinfo[gift_cert_savings] = $gs->process_code($orderinfo[total]);
	$orderinfo[total]			  = ($orderinfo[total]-$orderinfo[gift_cert_savings]);
	$orderinfo[rewards_savings]	  = $rp->process($orderinfo[total]);
	$orderinfo[total]			  = ($orderinfo[total]-$orderinfo[rewards_savings]);
	
	$order[tax] 		= p(applytax($orderinfo[ship_price], $discounts[total]+$coupon[total]));
	$order[discount] 	= p($discounts[total]);
	$order[subtotal] 	= p($cart->subtotal());
	$order[shipping] 	= p($orderinfo[ship_price]);
	$order[gs_value]	= p($orderinfo[gift_cert_savings]);
	$order[rp_value]	= p($orderinfo[rewards_savings]);
	$order[total]		= p($orderinfo[total]);
	
	if (is_array($discounts[items])) {
		foreach ($discounts[items] as $v) {
			$order[discounts] .= ($v[total]==$lang[free_ship])?'':template('order_review_discount_item.html', array('discount' => array('name' => $v[name], 'total' => p($v[total]))));
		}
	}
	
	if (is_array($coupon[items])) {
		foreach ($coupon[items] as $v) {
			$order[discounts] .= ($v[total]==$lang[free_ship])?'':template('order_review_discount_item.html', array('discount' => array('name' => $v[name], 'total' => p($v[total]))));
		}
	}
	
	if (is_array($tax_rates)) {
		foreach ($tax_rates as $v) {
			$order[taxes] .= template('order_review_tax_item.html', array('tax' => array('name' => $v[name], 'rate' => $v[rate], 'price' => p($v[price]))));
		}
	}
	
	if (p($orderinfo[gift_cert_savings]) != p(0)) {
		$order[giftcert] = template('order_review_discount_item.html', array('discount' => array('name' => 'Gift Certificate', 'total' => $order[gs_value])));
	}
	
	if (p($orderinfo[rewards_savings]) != p(0)) {
		$order[rewards] = template('order_review_discount_item.html', array('discount' => array('name' => 'Rewards Points', 'total' => $order[rp_value])));
	}
	
	if ($gs->cert_update == 1) $gs->update_remaining($orderinfo);
	
	$order[alt_checkout] = $alt;
	
	$out = template('order_review.html', array('order' => $order, 'lang' => $lang['order'], 'hide' => $hide));
	return $out;
}

/////////////////
// Search Helper 
/////////////////

function search_helper ($s) {
	if (is_array($s)) {
		foreach ($s as $k => $v) $out .= '&s['.urlencode($k).']='.urlencode($v);
	}
	return $out;
}

//////////////////
// Search Listing 
//////////////////

function search_list () {
	global $DB_site, $dbprefix, $settings, $lang, $search;
	$_GET[pg] = (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;
	$list[categories]		= $search['optionlist'];
	$list[manufacturers]	= getoptionlist('manufacturers', 'id', 'name', 'WHERE viewable=\'1\'', '', 'name');
	$list[search]			= template('page_advanced_search.html', array('list' => $list, 'lang' => $lang['advanced_search']));
	
	$results = $DB_site->query(search($_GET[s]));
	$count	 = $DB_site->num_rows($results);
	$query 	 = search($_GET[s]).' LIMIT '.((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[itemsperpage]).','.$settings[itemsperpage];
	
	$query_string = preg_replace('/&amp;s\[.*\]=.*/', '', htmlentities($_SERVER["QUERY_STRING"]));
	$append = preg_replace("/pg=([0-9]*)/", '', (($_GET[pg]=="")?'&amp;':"").$query_string.htmlentities(search_helper($_GET[s])));
	$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[itemsperpage], $_GET[pg], $append);
	
	$list[total_count] = $count;
	$list[search_text] = $_GET[s][search];
	$list[pages] = $page->paginate();
	
	$results = $DB_site->query($query);
	while ($product = $DB_site->fetch_assoc($results)) {
		$list[products] .= outputitem($product[id], $forceview);
	}
	
	$tile[products] = close_cleanly($list);
	$list[products] = template('list_products_'.$settings[showitem].'.html', array($settings[showitem] => ${$settings[showitem]}));
	
	if ($list[total_count] == 0) $list[products] = template('list_products_search_empty.html', array('lang' => $lang['advanced_search']));
	
	return $list;
}

////////////////////
// Search Registries
////////////////////

function registry_list () {
	global $DB_site, $dbprefix, $settings, $lang, $ae;
	$_GET[pg] = (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;
	
	if (is_array($_GET[s])) {
		foreach($_GET[s] as $k => $v) { $_GET[s][$k] = sanitize($v); }
	}
	
	if (strlen($_GET[s][last]) < 2 || strlen($_GET[s][first]) < 1) {
		$ae->new_error('Please fill in at least a first and last name.');
		header('location: '.$settings[shopurl].'index.php?l=page_view&p=registry');
		exit;
	}
	
	$query = "SELECT ur.`id`, ur.`userid`, u.`ship_first_name`, u.`ship_last_name`, u.`ship_state`, ur.`name`, ur.`date`
		FROM `".$dbprefix."users_registry` ur LEFT JOIN `".$dbprefix."users` u on ur.`userid`=u.`id` WHERE 
		u.`ship_first_name` like '".fsearch($_GET[s][first])."%' AND
		u.`ship_last_name` like '".fsearch($_GET[s][last])."%'".
		(($_GET[s][email]!='')?" AND u.`email`='".fsearch($_GET[s][email])."'":"").
		(($_GET[s][month]!='')?" AND ur.`date` like '%-".fsearch($_GET[s][month])."-%'":"").
		(($_GET[s][year]!='')?" AND ur.`date` like '".fsearch($_GET[s][year])."-%-%'":"");
	$results = $DB_site->query($query);
	$count	 = $DB_site->num_rows($results);
	$query 	 = $query.' LIMIT '.((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[itemsperpage]).','.$settings[itemsperpage];
	
	$query_string = preg_replace('/&amp;s\[.*\]=.*/', '', htmlentities($_SERVER["QUERY_STRING"]));
	$append = preg_replace("/pg=([0-9]*)/", '', (($_GET[pg]=="")?'&amp;':"").$query_string.htmlentities(search_helper($_GET[s])));
	$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[itemsperpage], $_GET[pg], $append);
	
	$list[total_count]	= $count;
	$list[search_text]	= $_GET[s][last].', '.$_GET[s][first];
	$list[pages]		= $page->paginate();
	
	$results = $DB_site->query($query);
	while ($event = $DB_site->fetch_assoc($results)) {
		$event = filter_data($event);
		$event['date'] = date($settings[datestamp], strtotime($event[date]));
		$list[registries] .= template('list_registry_search_item.html', array('registry' => $event));
	}
	
	$list['years'] = get_years();
	if ($list[total_count] == 0) $list[registries] = template('list_registry_search_empty.html', array('lang' => $lang['registry']));
	$list[search] = template('page_registry.html', array('lang' => $lang['registry'], 'list' => $list));
	
	return $list;
}

////////////////////////
// Category Info Display
////////////////////////

function category_display ($id) {
	global $DB_site, $dbprefix, $settings, $tile_count, $lang;
	$category = get('categories', $id);
	$hide = array();
	
	// Check Category Image
	if ($category['thumb_image'] != "" && @is_file($settings[productpath].$category['thumb_image'])) {
		$size = @getimagesize($settings[productpath].$category['thumb_image'], $imageinfo);
		$category[image_size] = $size[3];
	} else {
		$hide[] = 'Image';
	}
	
	$items = $DB_site->query("SELECT * FROM `".$dbprefix."categories` c WHERE `subof`='".$category[id]."' AND `viewable`='1' ".restrict('c')." order by `dorder`");
	while ($sub = $DB_site->fetch_assoc($items)) {
		$list[subs_list] .= outputsub($sub[id]);
	}
	$category[subs_list] = close_subs_cleanly($list);
	if ($category[subs_list] == "") $hide[] = 'Subs';
	
	if ($category[description] == "" && in_array('Subs', $hide)) return;
	
	return template('list_products_category_detail.html', array('category' => $category, 'hide' => $hide));
}

////////////////////////////
// Manufacturer Info Display
////////////////////////////

function manufacturer_display ($id) {
	global $DB_site, $dbprefix, $settings, $lang;
	$man = get('manufacturers', $id);
	$hide = array();
	
	// Check Manufacturer Image
	if ($man['thumb_image'] != "" && @is_file($settings[productpath].$man['thumb_image'])) {
		$size = @getimagesize($settings[productpath].$man['thumb_image'], $imageinfo);
		$man[image_size] = $size[3];
	} else {
		$hide[] = 'Image';
	}
	
	if ($man[description] == "" && in_array('Image', $hide)) return;

	return template('list_products_manufacturer_detail.html', array('manufacturer' => $man, 'hide' => $hide));
}

//////////////////
// Product Listing
//////////////////

function product_list () {
	global $DB_site, $dbprefix, $settings, $lang;
	
	$_GET[pg] = (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;
	$list[cookie_crumb]	= (is_numeric($_GET[c]))?cookiecrumb($_GET[c]):'';
	$list[sub_cat_man]	= (!is_numeric($_GET[c])&&!is_numeric($_GET[m]))?'':((is_numeric($_GET[c]))?category_display($_GET[c]):manufacturer_display($_GET[m]));
	
	if (isset($_GET[sortby])) { $exp = explode(':', $_GET[sortby]); $sort = $exp[0].' '.$exp[1]; }
	else $sort = $settings[orderby];
	
	if (is_numeric($_GET[c])) {
		$query = "SELECT p.`id` FROM `".$dbprefix."products` p
			INNER JOIN (
				SELECT p.`id` AS pid
				FROM `".$dbprefix."products` p
				LEFT JOIN `".$dbprefix."categories` c ON c.`id`=p.`catid`
				WHERE p.`catid`='".$_GET[c]."'
				".restrict('c')."
				UNION SELECT `productid` AS pid
				FROM `".$dbprefix."products_categories` pc
				LEFT JOIN `".$dbprefix."categories` c ON c.`id`=pc.`catid`
				WHERE pc.`catid`='".$_GET[c]."'
				".restrict('c')."
			) prods ON prods.`pid`=p.`id`
			WHERE p.`viewable`='y'
			".restrict('p')."
			order by p.$sort LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[itemsperpage]).",$settings[itemsperpage]";
	} elseif (is_numeric($_GET[m])) {
		$query = "SELECT p.* FROM `".$dbprefix."products` p 
			LEFT JOIN `".$dbprefix."manufacturers` m ON p.manufacturer = m.`id`
			WHERE m.`viewable`='1' AND m.`id` = '".$_GET[m]."' AND p.`viewable`='y'
			".restrict('p')." order by p.$sort LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[itemsperpage]).",$settings[itemsperpage]";
	} else {
		switch ($_GET[c]) {
			case 'bestsellers':
				$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`title`<>'' AND p.`viewable`='y' ".restrict('p')." order by p.`num_sold` DESC LIMIT $settings[itemsperpage]";
				break;
			case 'new':
				$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`is_new`='y' AND p.`viewable`='y' ".restrict('p')." order by p.".(($_GET[sortby]=="")?'id DESC':$sort)." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[itemsperpage]).",$settings[itemsperpage]";
				break;
			case 'specials':
				$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`sale_price`>'0' AND p.`viewable`='y' ".restrict('p')." order by p.$sort LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[itemsperpage]).",$settings[itemsperpage]";
				break;
			case 'featured':
				$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`is_featured`='y' AND p.`viewable`='y' ".restrict('p')." order by p.$sort LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[itemsperpage]).",$settings[itemsperpage]";
				break;
			default:
				die('Invalid parameters specified!');
				break;
		}
	}
	
	$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
	$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[itemsperpage], $_GET[pg], $append);
	$list[pages] = ($_GET[c]!='bestsellers')?$page->paginate():'';
	
	$list[products_count] = 0;
	
	$results = $DB_site->query($query);
	while ($product = $DB_site->fetch_assoc($results)) {
		$list[products_count]++;
		$list[products] .= outputitem($product[id], $forceview);
	}
	
	$tile[products] = close_cleanly($list);
	$list[products] = template('list_products_'.$settings[showitem].'.html', array($settings[showitem] => ${$settings[showitem]}));
	
	return $list;
}

/////////////////////
// Output Subcategory
/////////////////////

function outputsub ($id) {
	global $DB_site, $dbprefix, $settings, $tile_count;
	$sub = get('categories', $id);
	
	// Check Category Image
	if ($sub['tiny_image'] != "" && @is_file($settings[productpath].$sub['tiny_image'])) {
		$size = @getimagesize($settings[productpath].$sub['tiny_image'], $imageinfo);
		$sub[image_size] = $size[3];
	} else {
		$hide[] = 'Image';
	}
	
    $sub[width]  = round(100/$settings[tilenum]);
	$sub[width] .= "%";
	if ($tile_count == "") { 
		$out .= template('list_products_category_detail_subs_start.html', array()); $tile_count = 1;
	}
	$out .= template('list_products_category_detail_subs_item.html', array('sub' => $sub, 'hide' =>  $hide));
	if ($tile_count == $settings[tilenum]) {
		$out .= template('list_products_category_detail_subs_end.html', array()); $tile_count = "";
	} else { 
		$tile_count++; 
	}
	
	return $out;
}

///////////////////////
// Close Images Cleanly
///////////////////////

function close_subs_cleanly ($tile) {
	global $settings, $tile_count;
	if ($tile_count == "") return $tile[subs_list];
	for ($i=$tile_count; $i<=$settings[tilenum]; $i++) {
		$sub[width]  = round(100/$settings[tilenum]);
		$sub[width] .= "%";
		$tile[subs_list] .= template('list_products_category_detail_subs_item.html', array('sub' => $sub, 'hide' => array('Image', 'Data')));
	}
	$tile[subs_list] .= template('list_products_category_detail_subs_end.html', array()); $tile_count = "";
	return $tile[subs_list];
}

///////////////
// Output Image
///////////////

function outputimage ($id) {
	global $DB_site, $dbprefix, $settings, $tile_count, $lang;
	$image = get('products_images', $id);
	
	// Check Product Image
	if ($image['thumb_image'] != "" && @is_file($settings[productpath].$image['thumb_image'])) {
		$size = @getimagesize($settings[productpath].$image['thumb_image'], $imageinfo);
		$image[image_size] = $size[3];
	}
	
    $image[width]  = round(100/$settings[tilenum]);
	$image[width] .= "%";
	if ($tile_count == "") { 
		$out .= template('product_detail_images_start.html', array()); $tile_count = 1;
	}
	$out .= template('product_detail_images_item.html', array('image' => $image, 'lang' => $lang['product_detail']));
	if ($tile_count == $settings[tilenum]) {
		$out .= template('product_detail_images_end.html', array()); $tile_count = "";
	} else { 
		$tile_count++; 
	}
	
	return $out;
}

///////////////
// XML To Array
///////////////

function XMLtoArray ($vals, $tags) {
	$at = 0; $act = 0; $return = array();
	$attribute = array(); reset($vals);
	while (list ($key, $val) = each ($vals)) {
		$tag = $val['tag']; $value = $val['value'];
		$type = $val['type']; $level = $val['level'];
		switch ($type) {
			case 'open':
				if (in_array($tag, $tags, false))
					$attribute[$at++] = $tag."][".$act++;
				else
					$attribute[$at++] = $tag;
			break;
			case 'complete':
			    $arraystring = "";
				for ($i=0; $i<$at; $i++) $arraystring .= "[".$attribute[$i]."]";
				@eval("\$return".addslashes($arraystring)."[".addslashes($tag)."] = \"".addslashes($value)."\";");
			break;
			case 'close':
				$at--;
			break;
		}
	}
	return $return;
}

///////////////////////
// Close Images Cleanly
///////////////////////

function close_images_cleanly ($tile) {
	global $settings, $tile_count;
	if ($tile_count == "") return $tile[images];
	for ($i=$tile_count; $i<=$settings[tilenum]; $i++) {
		$image[width]  = round(100/$settings[tilenum]);
		$image[width] .= "%";
		$tile[images] .= template('product_detail_images_item.html', array('image' => $image, 'hide' => array('Data')));
	}
	$tile[images] .= template('product_detail_images_end.html', array()); $tile_count = "";
	return $tile[images];
}

//////////////
// Output Item
//////////////

function outputitem ($itemid, $forceview="") {
	global $DB_site, $dbprefix, $settings, $tile_count, $lang, $product;
	$product = get('products', $itemid);
	$product = calc_price($product, 1);
	$product = pre_display($product, 'thumb');
	
	if ($settings[showitem] == "tile" || $forceview == "tile") {
	    $product[width]  = round(100/$settings[tilenum]);
		$product[width] .= "%";
		if ($tile_count == "") { 
			$out .= template('list_products_tile_start.html', array()); $tile_count = 1;
		}
	    $out .= template('list_products_tile_item.html', array('lang' => $lang['product_list'], 'product' => $product, 'hide' => $product[hide]));
		if ($tile_count == $settings[tilenum]) { 
			$out .= template('list_products_tile_end.html', array()); $tile_count = "";
		} else { 
			$tile_count++; 
		}
	} else {
		$out = template('list_products_list_item.html', array('lang' => $lang['product_list'], 'product' => $product, 'hide' => $product[hide]));
	}
	
	return $out;
}

/////////////////////
// Close Tile Cleanly
/////////////////////

function close_cleanly ($list) {
	global $settings, $tile_count;
	if ($tile_count == "") return  $list[products];
	for ($i=$tile_count; $i<=$settings[tilenum]; $i++) {
		$product[width]  = round(100/$settings[tilenum]);
		$product[width] .= "%";
		$list[products] .= template('list_products_tile_item.html', array('product' => $product, 'hide' => array('Data')));
	}
	$list[products] .= template('list_products_tile_end.html', array()); $tile_count = "";
	return $list[products];
}

/////////////////
// XML Formatting
/////////////////

function xf ($in) {
	$replace = array('&', '<', '>');
	$with = array('&#x26;', '&#x3c;', '&#x3e;');
	return str_replace($replace, $with, $in);
}

/////////////////////
// Apply Restrictions
/////////////////////

function restrict ($pref) {
	global $sess;
	if (islogged()) $userinfo = get('users', $sess->gvar('userid'));
	else $userinfo = get('groups', 1, 'id', 'group_');
	return " AND (".$pref.".avail_to ='0' OR ".$pref.".avail_to='".$userinfo[group_in]."')";
}

//////////////////////////
// Cookie Crumb Navigation
//////////////////////////

function cookiecrumb ($id, $product=array()) {
	global $DB_site, $dbprefix, $subs_arr, $lang, $settings;
	if (!is_array($subs_arr)) { $subs_arr = array(); $subs_arr[ids] = array(); $subs_arr[titles] = array(); }
	$result = get('categories', $id);
	array_push($subs_arr[ids], $id);
	array_push($subs_arr[titles], $result[title]);
	if ($result[subof] == 0) {
		$crumbs = array();
		for ($i=(count($subs_arr[ids])-1); $i>=0; $i--) {
			$crumb = array();
			$crumb['link']  = $settings[shopurl].'index.php?l=product_list&amp;c='.$subs_arr[ids][$i];
			$crumb['title'] = $subs_arr[titles][$i];
			$crumbs[path] .= template('misc_cookie_crumb_item.html', array('crumb' => $crumb));
		}
		$out = template('misc_cookie_crumb.html', array('crumbs' => $crumbs, 'lang' => $lang['index']));
	} else {
		$out = cookiecrumb($result[subof]);
	}
	return $out;
}

///////////////////
// Bestsellers List
///////////////////

function listbestsellers () {
	global $DB_site, $dbprefix, $settings, $lang;
	
	if (is_numeric($_GET[m])) {
		$query = "SELECT p.`id` FROM `".$dbprefix."products` p 
			LEFT JOIN `".$dbprefix."manufacturers` m ON p.`manufacturer`=m.`id`
			WHERE p.`viewable`='y' AND m.`viewable`='1' AND m.`id`='".$_GET[m]."'
			".restrict('p')." order by p.`num_sold` DESC LIMIT 0, 10";
	} else {
		if (!is_numeric($_GET[c])) {
			$query = "SELECT p.id FROM `".$dbprefix."products` p 
				WHERE p.viewable='y' ".restrict('p')." 
				order by p.`num_sold` DESC LIMIT 0,10";
		} else {
			$query = "SELECT p.`id` FROM `".$dbprefix."products` p
				INNER JOIN (
					SELECT p.`id` AS pid
					FROM `".$dbprefix."products` p
					LEFT JOIN `".$dbprefix."categories` c ON c.`id`=p.`catid`
					WHERE p.`catid`='".$_GET[c]."'
					".restrict('c')."
					UNION SELECT `productid` AS pid
					FROM `".$dbprefix."products_categories` pc
					LEFT JOIN `".$dbprefix."categories` c ON c.`id`=pc.`catid`
					WHERE pc.`catid`='".$_GET[c]."'
					".restrict('c')."
				) prods ON prods.`pid`=p.`id`
				WHERE p.`viewable`='y'
				".restrict('p')."
				order by p.`num_sold` DESC LIMIT 0,10";
		}
	}
	
	$result = $DB_site->query($query);
	$count = $DB_site->num_rows($result);
	if ($count > 0) {
		while ($product = $DB_site->fetch_assoc($result)) {
			$product = get('products', $product[id]);
			$product[title] = shortenit(stripslashes($product[title]), 50);
			$out .= template('table_bestsellers_item.html', array('product' => $product, 'lang' => $lang['index'], 'hide' => array('No Results')));
		}
	} else{
		$product[title] = $lang['bestsellers']['none'];
		$out = template('table_bestsellers_item.html', array('product' => $product, 'hide' => array('Item')));
	}
	return $out;
}

///////////////////
// Get Options List
///////////////////

function getoptionlist ($table, $value, $name, $sql="", $default="", $orderby="dorder", $blank=0) {
	global $DB_site, $settings, $dbprefix;
	$format_watch = array(" & "); $format_new = array(" &amp; ");
	
	if ($blank==1) $out = '<option value=""'.(($default=='')?' selected="selected"':'').'></option>';
	$result = $DB_site->query("SELECT * FROM `".$dbprefix.$table."` ".$sql." order by ".$orderby);
	while ($option = $DB_site->fetch_assoc($result)) {
		$out .= '<option value="'.$option[$value].'"'.(($option[$value]==$default)?' selected="selected"':'').'>'.str_replace($format_watch, $format_new, stripslashes($option[$name])).'</option>';
	}
	return $out;
}

////////////////
// Clear Session
////////////////

function clear_session () {
	global $orderinfo, $cart, $sess;
	$sess->dvar('userinfo');
	$cart =& $sess->gvar('cart');
	$cart->items = array();
	$cart->coupon = "";
	savecart();
	$orderinfo = "";
}

//////////////
// Return Data
//////////////

function return_data ($object) {
	ob_start();
	debug($object);
	$return = ob_get_contents();
	ob_end_clean();
	return $return;
}

//////////
// SunShop
//////////

function foot_out () {
	return '<div align="center" class="small">Powered by SunShop "<a href="http://www.turnkeywebtools.com/" title="Ecommerce Shopping Cart Software" class="small" target="_NEW">Shopping Cart Software</a>"</div>';
}

?>