<?PHP
/*
  checkout.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$abs_path = dirname(__FILE__);
include $abs_path."/global.php";

if (isset($_POST[l])) $_GET[l] = $_POST[l];
if (isset($_POST[m])) $_GET[m] = $_POST[m];
if (isset($_POST[p])) $_GET[p] = $_POST[p];

// Run Ajax Functions
$run_ajax = array('hold_order');
if (in_array($_GET[l], $run_ajax)) {
	$ajax = new ajax();
	echo $ajax->$_GET[l]($_GET[p]);
	exit;
}

// Set Global Data
$index[year]				= date('Y');
$index[foot_out]			= foot_out();
$categories['list'] 		= showcategories();
$search['optionlist']  		= catoptionlist(cats2array(0), 0, '');
$manufacturers['list'] 		= manufacturers_list();
$bestsellers['list'] 		= listbestsellers();
$cart_contents['list']		= cart_contents();
$cart_contents['subtotal']	= p($cart->subtotal());
$currency['list']			= currency_list();
$currency['self']			= 'checkout.php';

// Set Default Meta Tags
$index[page_title]			= $settings[metatitle];
$index[page_keywords]		= $settings[metakeywords];
$index[page_description]	= $settings[metadescription];

// Items In Cart?
$return = ($_GET['return']!="")?$_GET['return']:$_POST['return'];
if ($cart->product_count() <= 0 && $return == "") empty_redirect();

// Load Order Info
$orderinfo = (is_array($sess->gvar('orderinfo')))?$sess->gvar('orderinfo'):array();

// Check Processor Return
if ($return) {
	include $abs_path.'/include/methods/'.$return.'.php';
	$class_vars = module_vars($CLASS_NAME, 'methods');
	$method = new $CLASS_NAME($class_vars);
	$result = $method->catch_return();
	$_GET[l] = 'process_return';
}

// Set Base URL
if ($_GET[setbase] == 1) $index[base_url] = '<base href="'.$settings[secureurl].'" />';

switch ($_GET[l]) {
	case '':
		if (islogged()) {
			$userinfo = get('users', $sess->gvar('userid'));
			$hide = array('Login', 'Account', 'New Signup', 'Custom Fields');
		} else $hide[] = "New Signup";
		
		if ($sess->gvar('login_error') == 1) { $sess->dvar('login_error'); $ae->new_error($lang['account']['pass_error']); }
		
		$order[review] = review_order($alt_checkout);
		$userinfo['bill_state_list']	= getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.STATE.'\' OR type=\''.PROV.'\'', ($userinfo[bill_state]!="")?$userinfo[bill_state]:$settings[state], 'type,name');
		$userinfo['ship_state_list']	= getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.STATE.'\' OR type=\''.PROV.'\'', ($userinfo[ship_state]!="")?$userinfo[ship_state]:$settings[state], 'type,name');
		$userinfo['bill_country_list']	= getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.COUNTRY.'\'', ($userinfo[bill_country]!="")?$userinfo[bill_country]:$settings[country], 'name');
		$userinfo['ship_country_list']	= getoptionlist('state_country', 'abb', 'name', 'WHERE type=\''.COUNTRY.'\'', ($userinfo[ship_country]!="")?$userinfo[ship_country]:$settings[country], 'name');
		
		$userinfo[news_check]	= ($userinfo[newsletter]=="1")?'checked="checked"':'';
		$userinfo[same_check]	= ($userinfo[same]=="copy")?'checked="checked"':'';
		$userinfo[store_check]	= ($userinfo[store_info]=="store")?' checked="checked"':'';
		$userinfo[required]		= '<span class="required">*</span>';
		
		$custom[fields] = display_custom('users');
		if ($custom[fields] == "") array_push($hide, 'Custom Fields');
		
		$index[main_content] = template('order_customer_info.html', array('custom' => $custom, 'order' => $order, 'userinfo' => $userinfo, 'hide' => $hide, 'order' => $order, 'lang' => $lang[order], 'message' => array('error' => $ae->display())));
		break;
		
	case 'details':
		$errors = check_account($_POST[userinfo]);
		if ($errors) { header("location: ".$settings[secureurl]."checkout.php"); exit; }
		
		if (!is_array($sess->gvar('userinfo')) || !is_array($sess->gvar('orderinfo'))) { header('location: '.$settings[shopurl].'index.php?l=checkout'); exit; }
		
		$order[review]	= review_order();
		$shipping		= get_shipping();
		$methods		= methods_modules();
		
		$hide[] = ((p($orderinfo[rewards_points],false)==p(0,false)) || $settings[rewards_points] == "No")?'Rewards':'';
		$hide[]	= ($_SESSION[orderinfo][hide_method]=='1')?'Pay Methods':'';
		$hide[]	= ($ae->is_errors())?'Continue':'';
		$hide[]	= $methods[hide];
		
		$order[shipping_methods]	= $shipping[values];
		$order[payment_methods]		= $methods[data];
		$index[main_content]		= template('order_details.html', array('order' => $order, 'orderinfo' => $orderinfo, 'lang' => $lang['order'], 'message' => array('error' => $ae->display()), 'hide' => $hide));
		break;
		
	case 'payment':
		if (!is_array($sess->gvar('userinfo')) || !is_array($sess->gvar('orderinfo'))) { header('location: '.$settings[shopurl].'index.php?l=checkout'); exit; }
		
		$orderinfo_ship_info	= explode("->", $_POST['order']['shipping']);
		$orderinfo[usepoints]	= ($_POST['order']['usepoints']!="")?$_POST['order']['usepoints']:'';
		$orderinfo[pay_method]	= ($_POST['order']['payment_method']!="")?$_POST['order']['payment_method']:$orderinfo[pay_method];
		$orderinfo[ship_method]	= ($_POST['order']['shipping']!="")?$orderinfo_ship_info[0]:$orderinfo[ship_method];
		$orderinfo[ship_price]	= ($_POST['order']['shipping']!="")?$orderinfo_ship_info[1]:$orderinfo[ship_price];
		
		$gs->check_code();
		$order[review] = review_order();
		
		include $abs_path.'/include/methods/'.$orderinfo['pay_method'].'.php';
		$class_vars = module_vars($CLASS_NAME, 'methods');
		$method = new $CLASS_NAME($class_vars);
		$payment_form = $method->render();
		
		$index[main_content] = template('order_payment.html', array('order' => $order, 'lang' => $lang['order'], 'payment_form' => $payment_form));
		break;
		
	case 'review':
		if (!is_array($sess->gvar('userinfo')) || !is_array($sess->gvar('orderinfo'))) { header('location: '.$settings[shopurl].'index.php?l=checkout'); exit; }
		if (is_array($_POST['order'])) foreach($_POST['order'] as $k => $v) $orderinfo[$k] = ($k=="cc_card_no")?tempcryptit($v):$v;
		
		include $abs_path.'/include/methods/'.$orderinfo['pay_method'].'.php';
		$class_vars = module_vars($CLASS_NAME, 'methods');
		$method = new $CLASS_NAME($class_vars);
		$review	= $method->pre_process();
		
		$custom[fields] = display_custom('orders');
		
		$hide = array();
		foreach($sess->gvar('userinfo') as $k => $v) if ($v=="") array_push($hide, $k);
		if ($custom[fields] == "") array_push($hide, 'Custom Fields');
		
		$order[review] = review_order();
		$index[main_content] = template('order_overall_review.html', array('custom' => $custom, 'review' => $review, 'userinfo' => $sess->gvar('userinfo'), 'order' => $order, 'lang' => $lang['order'], 'hide' => $hide, 'message' => array('error' => $ae->display())));
		break;
		
	case 'process':
		if (!is_array($sess->gvar('userinfo')) || !is_array($sess->gvar('orderinfo'))) { header('location: '.$settings[shopurl].'index.php?l=checkout'); exit; }
		checkout_check();
		check_custom('orders');
		
		$_SESSION[orderinfo][comments] = $_POST['order']['comments'];
		
		include_once $abs_path.'/include/classes/class.connect.php';
		$cconnect = new curl_connect();
		
		include $abs_path.'/include/methods/'.$orderinfo['pay_method'].'.php';
		$class_vars = module_vars($CLASS_NAME, 'methods');
		$method = new $CLASS_NAME($class_vars);
		$result = $method->process();
		
		$errors = $ae->is_errors();
		if ($result['notes'] == "") $hide[] = "Notes";
		if ($errors) $hide[] = "OrderID";
		
		$order[review] = review_order();
		$index[main_content] = template('order_complete.html', array('result' => $result, 'order' => $order, 'lang' => $lang['order'], 'hide' => $hide, 'message' => array('error' => $ae->display())));
		if (!$errors) { clear_session(); $clear_cart = 1; }
		break;
		
	case 'process_return':
		$errors = $ae->is_errors();
		if ($result['notes'] == "") $hide[] = "Notes";
		if ($errors) $hide[] = "OrderID";
		
		$order[review] = review_order();
		$index[main_content] = template('order_complete.html', array('result' => $result, 'order' => $order, 'lang' => $lang['order'], 'hide' => $hide, 'message' => array('error' => $ae->display())));
		if (!$errors) { clear_session(); $clear_cart = 1; }
		break;
		
	default:
		break;
}

// Store Updated Data
$sess->dvar('orderinfo'); 
$sess->svar('orderinfo', $orderinfo);

///////////////////////
// Start Loading Tables
///////////////////////

$table_array = table_list();
for ($i=0; $i<count($table_array); $i++) {
	$file_name	= $table_array[$i][file_name];
	$table_name	= $table_array[$i][table_name];
	if ($table_name == 'information' && $settings[giftcerts] == 'No') $hide[] = 'Gift Certificates';
	if ($table_name == 'information' && $settings[registry] == 'No') $hide[] = 'Registry';
	if ($table_name == 'information' && !islogged()) $hide[] = 'Logout';
	$table[$table_name] = template($file_name, array($table_name => ${$table_name}, 'lang' => $lang[$table_name], 'hide' => $hide));
}

//////////////
// Page Output
//////////////

if ($settings[width] == '100%' || $settings[width] == '') $hide[] = 'Fixed1';
if ($settings[width] == '100%' || $settings[width] == '') $hide[] = 'Fixed2';
if (islogged()) $hide[] = 'Login';
else $hide[] = 'Logout';

$index_out = template('main_index.html', array('index' => $index, 'table' => $table, 'lang' => $lang['index'], 'hide' => $hide));
if ($sess->gvar('my_rate') != "" && $sess->gvar('my_rate') != $settings[defaultrate]) $index_out = parsePRICE($index_out);
if ($clear_cart == 1) $index_out = order_links($index_out);

echo stripslashes($index_out);

$DB_site->close();

//$cart->debug();
//$sess->debug();
?>